/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.mixin.rngevents;

import com.google.common.base.Objects;
import net.earthcomputer.clientcommands.features.PlayerRandCracker;
import net.earthcomputer.clientcommands.util.CUtil;
import net.earthcomputer.clientcommands.util.MultiVersionCompat;
import net.minecraft.class_10192;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_1893;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2360;
import net.minecraft.class_2374;
import net.minecraft.class_2680;
import net.minecraft.class_3481;
import net.minecraft.class_3486;
import net.minecraft.class_3726;
import net.minecraft.class_5321;
import net.minecraft.class_746;
import net.minecraft.class_9334;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={class_1309.class})
public abstract class LivingEntityMixin
extends class_1297 {
    @Unique
    private class_2338 clientLastPos;

    @Shadow
    public abstract boolean method_5805();

    public LivingEntityMixin(class_1299<?> entityType_1, class_1937 level_1) {
        super(entityType_1, level_1);
    }

    @Inject(method={"drop"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/Level;isClientSide()Z")})
    private void onDrop(CallbackInfoReturnable<class_1542> ci) {
        if (this.isThePlayer()) {
            PlayerRandCracker.onDropItem();
        }
    }

    @Inject(method={"pushEntities"}, at={@At(value="HEAD")})
    private void onEntityCramming(CallbackInfo ci) {
        if (this.isThePlayer() && this.method_73183().method_8333((class_1297)this, this.method_5829(), class_1297::method_5810).size() >= 24) {
            PlayerRandCracker.resetCracker(PlayerRandCracker.RNGCallType.ENTITY_CRAMMING);
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isAlive()Z", ordinal=0)})
    private void onUnderwater(CallbackInfo ci) {
        if (this.isThePlayer() && this.method_5805() && this.method_5777(class_3486.field_15517)) {
            PlayerRandCracker.resetCracker(PlayerRandCracker.RNGCallType.SWIM);
        }
    }

    @Inject(method={"breakItem"}, at={@At(value="HEAD")})
    private void onEquipmentBreak(class_1799 stack, CallbackInfo ci) {
        if (this.isThePlayer() && MultiVersionCompat.INSTANCE.getProtocolVersion() <= 404) {
            PlayerRandCracker.resetCracker(PlayerRandCracker.RNGCallType.ITEM_BREAK);
        }
    }

    @Inject(method={"onEquipItem"}, at={@At(value="HEAD")})
    private void onOnEquipItem(class_1304 slot, class_1799 oldItem, class_1799 newItem, CallbackInfo ci) {
        if (this.isThePlayer()) {
            class_10192 equippable;
            boolean emptySlotClickWithEmpty;
            boolean bl = emptySlotClickWithEmpty = newItem.method_7960() && oldItem.method_7960();
            if (!(emptySlotClickWithEmpty || class_1799.method_31577((class_1799)oldItem, (class_1799)newItem) || this.field_5953 || (equippable = (class_10192)newItem.method_58694(class_9334.field_54196)) == null || slot != equippable.comp_3174())) {
                PlayerRandCracker.onEquipItem();
            }
        }
    }

    @Inject(method={"updateFallFlying"}, at={@At(value="HEAD")})
    private void onUpdateFallFlying(CallbackInfo ci) {
        if (this.isThePlayer() && MultiVersionCompat.INSTANCE.getProtocolVersion() >= 768) {
            PlayerRandCracker.resetCracker(PlayerRandCracker.RNGCallType.FALL_FLYING);
        }
    }

    @Inject(method={"tickEffects"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/entity/LivingEntity;isInvisible()Z")})
    private void onPotionParticles(CallbackInfo ci) {
        if (this.isThePlayer()) {
            PlayerRandCracker.resetCracker(PlayerRandCracker.RNGCallType.POTION);
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="RETURN")})
    private void testFrostWalker(CallbackInfo ci) {
        class_2338 pos;
        if (!this.isThePlayer()) {
            return;
        }
        if (MultiVersionCompat.INSTANCE.getProtocolVersion() < 767 && !Objects.equal((Object)(pos = this.method_24515()), (Object)this.clientLastPos)) {
            int frostWalkerLevel;
            this.clientLastPos = pos;
            if (this.method_24828() && (frostWalkerLevel = CUtil.getEnchantmentLevel((class_5321<class_1887>)class_1893.field_9122, (class_1309)this)) > 0) {
                class_2680 frostedIce = class_2246.field_10110.method_9564();
                int radius = Math.min(16, frostWalkerLevel + 2);
                for (class_2338 offsetPos : class_2338.method_10097((class_2338)pos.method_10069(-radius, -1, -radius), (class_2338)pos.method_10069(radius, -1, radius))) {
                    class_2680 offsetState;
                    if (!offsetPos.method_19769((class_2374)this.method_73189(), (double)radius) || (offsetState = this.method_73183().method_8320(offsetPos)) != class_2360.method_51170() || !this.method_73183().method_8628(frostedIce, offsetPos, class_3726.method_16194()) || !this.method_73183().method_22347(offsetPos.method_10084())) continue;
                    PlayerRandCracker.resetCracker(PlayerRandCracker.RNGCallType.FROST_WALKER);
                }
            }
        }
    }

    @Inject(method={"baseTick"}, at={@At(value="RETURN")})
    private void testSoulSpeed(CallbackInfo ci) {
        boolean hasSoulSpeed;
        if (!this.isThePlayer()) {
            return;
        }
        boolean bl = hasSoulSpeed = CUtil.getEnchantmentLevel((class_5321<class_1887>)class_1893.field_23071, (class_1309)this) > 0;
        if (hasSoulSpeed && this.method_73183().method_8320(this.method_23314()).method_26164(class_3481.field_23063)) {
            PlayerRandCracker.resetCracker(PlayerRandCracker.RNGCallType.SOUL_SPEED);
        }
    }

    @Inject(method={"handleDamageEvent"}, at={@At(value="HEAD")})
    private void onHandleDamageEvent(CallbackInfo ci) {
        if (this.isThePlayer()) {
            PlayerRandCracker.resetCracker(PlayerRandCracker.RNGCallType.PLAYER_HURT);
        }
    }

    @Unique
    private boolean isThePlayer() {
        return this instanceof class_746;
    }
}

