/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.logging.LogUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1011;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1533;
import net.minecraft.class_1799;
import net.minecraft.class_1806;
import net.minecraft.class_1937;
import net.minecraft.class_22;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_318;
import net.minecraft.class_3620;
import net.minecraft.class_638;
import net.minecraft.class_9334;
import net.minecraft.class_9691;
import org.joml.Vector2i;
import org.joml.Vector4i;
import org.slf4j.Logger;

public class MapCommand {
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final SimpleCommandExceptionType NO_HELD_MAP_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.cmap.noHeldMap"));
    private static final SimpleCommandExceptionType FAILED_SAVE_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.cmap.failedSave"));

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cmap").then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"export").executes(ctx -> MapCommand.exportMap((FabricClientCommandSource)ctx.getSource(), 1))).then(ClientCommandManager.argument((String)"scale", (ArgumentType)IntegerArgumentType.integer((int)1, (int)64)).executes(ctx -> MapCommand.exportMap((FabricClientCommandSource)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"scale"))))));
    }

    private static int exportMap(FabricClientCommandSource source, int scale) throws CommandSyntaxException {
        class_22 data = MapCommand.fromHand((class_1309)source.getPlayer());
        if (data != null) {
            return MapCommand.exportMap(source, new MapInfo[][]{{new MapInfo(data, 0)}}, scale, false);
        }
        MapInfo[][] worldData = MapCommand.fromWorld(source.getClient().field_1692, source.getClient().field_1687, source.getPlayer().method_5735());
        if (worldData != null) {
            return MapCommand.exportMap(source, worldData, scale, true);
        }
        throw NO_HELD_MAP_EXCEPTION.create();
    }

    private static class_22 fromHand(class_1309 entity) {
        class_1799 item = entity.method_6047();
        if (item.method_57826(class_9334.field_49646)) {
            return class_1806.method_8001((class_1799)item, (class_1937)entity.method_73183());
        }
        item = entity.method_6079();
        if (item.method_57826(class_9334.field_49646)) {
            return class_1806.method_8001((class_1799)item, (class_1937)entity.method_73183());
        }
        return null;
    }

    private static MapInfo[][] fromWorld(class_1297 entity, class_638 level, class_2350 facing) {
        if (!(entity instanceof class_1533)) {
            return null;
        }
        class_1533 frame = (class_1533)entity;
        class_1799 item = frame.method_6940();
        class_2350 direction = frame.method_5735();
        if (!item.method_57826(class_9334.field_49646)) {
            return null;
        }
        class_2350 xAxis = switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11043, class_2350.field_11035, class_2350.field_11034, class_2350.field_11039 -> class_2350.field_11033;
            case class_2350.field_11036 -> facing.method_10153();
            case class_2350.field_11033 -> facing;
        };
        class_2350 yAxis = switch (direction) {
            default -> throw new MatchException(null, null);
            case class_2350.field_11043 -> class_2350.field_11039;
            case class_2350.field_11034 -> class_2350.field_11043;
            case class_2350.field_11035 -> class_2350.field_11034;
            case class_2350.field_11039 -> class_2350.field_11035;
            case class_2350.field_11036 -> class_2350.method_10139((int)((xAxis.method_10161() + 3) % 4));
            case class_2350.field_11033 -> class_2350.method_10139((int)((xAxis.method_10161() + 1) % 4));
        };
        Map frames = StreamSupport.stream(level.method_18112().spliterator(), true).filter(e -> {
            class_1533 itemFrame;
            return e instanceof class_1533 && (itemFrame = (class_1533)e).method_5735() == direction;
        }).map(class_1533.class::cast).collect(Collectors.toMap(class_9691::method_59940, Function.identity(), (a, b) -> {
            boolean aHas = a.method_6940().method_57826(class_9334.field_49646);
            boolean bHas = b.method_6940().method_57826(class_9334.field_49646);
            if (aHas && bHas) {
                LOGGER.warn("More than one map item frame found at {}.", (Object)a.method_59940());
            }
            if (aHas) {
                return a;
            }
            return b;
        }));
        class_2338 initialPos = frame.method_59940();
        HashMap<Vector2i, MapInfo> positionsAndData = new HashMap<Vector2i, MapInfo>();
        HashSet<class_2338> visited = new HashSet<class_2338>();
        ArrayDeque<class_2338> toVisit = new ArrayDeque<class_2338>();
        toVisit.addLast(frame.method_59940());
        while (!toVisit.isEmpty()) {
            int rotationOffset;
            class_1533 frameAtPos;
            class_2338 pos = (class_2338)toVisit.removeFirst();
            if (!visited.add(pos) || (frameAtPos = (class_1533)frames.get(pos)) == null) continue;
            class_22 savedData = class_1806.method_8001((class_1799)frameAtPos.method_6940(), (class_1937)level);
            class_2338 relPos = pos.method_10059((class_2382)initialPos);
            Vector2i position = new Vector2i(relPos.method_30558(xAxis.method_10166()) * xAxis.method_10171().method_10181(), relPos.method_30558(yAxis.method_10166()) * yAxis.method_10171().method_10181());
            switch (xAxis) {
                default: {
                    throw new MatchException(null, null);
                }
                case field_11039: {
                    int n = 3;
                    break;
                }
                case field_11034: {
                    int n = 1;
                    break;
                }
                case field_11035: {
                    int n;
                    if (direction == class_2350.field_11036) {
                        n = 0;
                        break;
                    }
                    n = 2;
                    break;
                }
                case field_11043: 
                case field_11036: {
                    int n;
                    if (direction == class_2350.field_11036) {
                        n = 2;
                        break;
                    }
                    n = 0;
                    break;
                }
                case field_11033: {
                    int n = rotationOffset = 0;
                }
            }
            if (savedData != null) {
                positionsAndData.put(position, new MapInfo(savedData, frameAtPos.method_6934() + rotationOffset));
            }
            List<class_2338> adjacent = switch (direction.method_10166()) {
                default -> throw new MatchException(null, null);
                case class_2350.class_2351.field_11048 -> List.of(pos.method_10095(), pos.method_10072(), pos.method_10084(), pos.method_10074());
                case class_2350.class_2351.field_11052 -> List.of(pos.method_10095(), pos.method_10072(), pos.method_10078(), pos.method_10067());
                case class_2350.class_2351.field_11051 -> List.of(pos.method_10078(), pos.method_10067(), pos.method_10084(), pos.method_10074());
            };
            toVisit.addAll(adjacent);
        }
        Vector4i bounds = positionsAndData.keySet().stream().reduce(new Vector4i(0), (bound, value) -> new Vector4i(Math.min(bound.x, value.x), Math.min(bound.y, value.y), Math.max(bound.z, value.x), Math.max(bound.w, value.y)), (a, b) -> new Vector4i(Math.min(a.x, b.x), Math.min(a.y, b.y), Math.max(a.z, b.z), Math.max(a.w, b.w)));
        int width = Math.abs(bounds.z - bounds.x) + 1;
        int height = Math.abs(bounds.w - bounds.y) + 1;
        MapInfo[][] data = new MapInfo[width][height];
        for (Map.Entry entry : positionsAndData.entrySet()) {
            data[((Vector2i)entry.getKey()).x - bounds.x][((Vector2i)entry.getKey()).y - bounds.y] = (MapInfo)entry.getValue();
        }
        return data;
    }

    private static int exportMap(FabricClientCommandSource source, MapInfo[][] data, int scale, boolean world) throws CommandSyntaxException {
        int height = data.length * 128;
        int width = Arrays.stream(data).mapToInt(a -> ((MapInfo[])a).length).max().orElseThrow() * 128;
        class_1011 image = new class_1011(class_1011.class_1012.field_4997, width, height, true);
        for (int y = 0; y < data.length; ++y) {
            for (int x = 0; x < data[y].length; ++x) {
                MapInfo savedData = data[y][x];
                if (savedData == null) continue;
                MapCommand.drawMapWithOffsets(image, x * 128 * scale, y * 128 * scale, scale, savedData);
            }
        }
        File screenshotDir = new File(source.getClient().field_1697, "screenshots");
        if (!screenshotDir.exists() && !screenshotDir.mkdirs()) {
            throw FAILED_SAVE_EXCEPTION.create();
        }
        File imageFile = class_318.method_1660((File)screenshotDir);
        try {
            image.method_4325(imageFile);
        }
        catch (IOException e) {
            throw FAILED_SAVE_EXCEPTION.create();
        }
        source.sendFeedback((class_2561)class_2561.method_43469((String)(world ? "commands.cmap.export.success.world" : "commands.cmap.export.success.hand"), (Object[])new Object[]{class_2561.method_43470((String)imageFile.getName()).method_27692(class_124.field_1073).method_27694(s -> s.method_10958((class_2558)new class_2558.class_10607(imageFile.getAbsoluteFile())))}));
        return 1;
    }

    private static void drawMapWithOffsets(class_1011 image, int offsetX, int offsetY, int scale, MapInfo info) {
        for (int y = 0; y < info.getHeight(); ++y) {
            for (int x = 0; x < info.getWidth(); ++x) {
                int color = class_3620.method_38480((int)info.getMapColor(x, y));
                for (int i = 0; i < scale; ++i) {
                    for (int j = 0; j < scale; ++j) {
                        image.method_61941(x * scale + i + offsetX, y * scale + j + offsetY, color);
                    }
                }
            }
        }
    }

    private record MapInfo(class_22 data, int rotation) {
        public byte getMapColor(int x, int y) {
            switch (this.rotation % 4) {
                case 0: {
                    return this.data.field_122[x + y * 128];
                }
                case 1: {
                    int newX = y;
                    int newY = 127 - x;
                    return this.data.field_122[newX + newY * 128];
                }
                case 2: {
                    int newX = 127 - x;
                    int newY = 127 - y;
                    return this.data.field_122[newX + newY * 128];
                }
                case 3: {
                    int newX = 127 - y;
                    int newY = x;
                    return this.data.field_122[newX + newY * 128];
                }
            }
            throw new IllegalStateException("unreachable");
        }

        public int getWidth() {
            if (this.rotation % 2 == 0) {
                return 128;
            }
            return 128;
        }

        public int getHeight() {
            if (this.rotation % 2 == 0) {
                return 128;
            }
            return 128;
        }
    }
}

