/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.features;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import com.seedfinding.mcseed.lcg.LCG;
import com.seedfinding.mcseed.rand.Rand;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import net.earthcomputer.clientcommands.Configs;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.earthcomputer.clientcommands.event.ClientLevelEvents;
import net.earthcomputer.clientcommands.features.LegacyEnchantment;
import net.earthcomputer.clientcommands.features.PlayerRandCracker;
import net.earthcomputer.clientcommands.task.ItemThrowTask;
import net.earthcomputer.clientcommands.task.LongTask;
import net.earthcomputer.clientcommands.task.LongTaskList;
import net.earthcomputer.clientcommands.task.OneTickTask;
import net.earthcomputer.clientcommands.task.SimpleTask;
import net.earthcomputer.clientcommands.task.TaskManager;
import net.earthcomputer.clientcommands.util.MultiVersionCompat;
import net.minecraft.class_124;
import net.minecraft.class_1703;
import net.minecraft.class_1718;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2331;
import net.minecraft.class_2338;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2828;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_338;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;
import net.minecraft.class_3542;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_746;
import net.minecraft.class_7924;
import net.minecraft.class_9636;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class EnchantmentCracker {
    public static final Logger LOGGER = LogUtils.getLogger();
    private static final int PROGRESS_BAR_WIDTH = 50;
    private static WeakReference<LongTask> currentEnchantingTask = null;
    private static boolean isCurrentlyThrowingItems = false;
    private static int expectedNumBookshelves = -1;
    static Set<Integer> possibleXPSeeds = new HashSet<Integer>(0x100000);
    private static int firstXpSeed;
    public static class_2338 enchantingTablePos;
    private static boolean doneEnchantment;

    public static void registerEvents() {
        ClientLevelEvents.UNLOAD_LEVEL.register(isDisconnect -> {
            if (isDisconnect) {
                expectedNumBookshelves = -1;
            }
        });
        PlayerRandCracker.RNG_CALLED_EVENT.register(EnchantmentCracker::onRNGCallEvent);
    }

    public static void drawEnchantmentGUIOverlay(class_332 graphics) {
        class_638 level = class_310.method_1551().field_1687;
        assert (level != null);
        CrackState crackState = Configs.enchCrackState;
        ArrayList<class_5250> lines = new ArrayList<class_5250>();
        lines.add(class_2561.method_43469((String)"enchCrack.state", (Object[])new Object[]{class_2561.method_43471((String)("enchCrack.state." + crackState.method_15434()))}));
        lines.add(class_2561.method_43469((String)"playerManip.state", (Object[])new Object[]{class_2561.method_43471((String)("playerManip.state." + Configs.playerCrackState.method_15434()))}));
        lines.add(class_2561.method_43473());
        if (crackState == CrackState.CRACKED) {
            lines.add(class_2561.method_43469((String)"enchCrack.xpSeed.one", (Object[])new Object[]{String.format("%08X", possibleXPSeeds.iterator().next())}));
        } else if (crackState == CrackState.CRACKING) {
            lines.add(class_2561.method_43469((String)"enchCrack.xpSeed.many", (Object[])new Object[]{possibleXPSeeds.size()}));
        }
        lines.add(class_2561.method_43473());
        if (enchantingTablePos != null) {
            int numBookshelves = EnchantmentCracker.getEnchantPower((class_1937)level, enchantingTablePos);
            if (expectedNumBookshelves == -1) {
                lines.add(class_2561.method_43469((String)"enchCrack.bookshelfCount", (Object[])new Object[]{numBookshelves}));
            } else {
                boolean bookshelfCountMatches = numBookshelves == expectedNumBookshelves || numBookshelves > 15 && expectedNumBookshelves == 15;
                lines.add(class_2561.method_43469((String)"enchCrack.bookshelfCount.expected", (Object[])new Object[]{expectedNumBookshelves}));
                lines.add(class_2561.method_43469((String)"enchCrack.bookshelfCount.actual", (Object[])new Object[]{class_2561.method_43470((String)String.valueOf(numBookshelves)).method_27692(bookshelfCountMatches ? class_124.field_1060 : class_124.field_1061)}));
                if (!bookshelfCountMatches) {
                    lines.add(class_2561.method_43471((String)"enchCrack.bookshelfCount.incorrect").method_27692(class_124.field_1061));
                }
            }
            lines.add(class_2561.method_43473());
        }
        if (crackState == CrackState.CRACKED) {
            lines.add(class_2561.method_43471((String)"enchCrack.enchantments"));
        } else {
            lines.add(class_2561.method_43471((String)"enchCrack.clues"));
        }
        for (int slot = 0; slot < 3; ++slot) {
            lines.add(class_2561.method_43469((String)"enchCrack.slot", (Object[])new Object[]{slot + 1}));
            List<class_1889> enchs = EnchantmentCracker.getEnchantmentsInTable(slot);
            if (enchs == null) continue;
            EnchantmentCracker.sortIntoTooltipOrder((class_2378<class_1887>)level.method_30349().method_30530(class_7924.field_41265), enchs);
            for (class_1889 class_18892 : enchs) {
                lines.add(class_2561.method_43470((String)"   ").method_10852(class_1887.method_8179((class_6880)class_18892.comp_3486(), (int)class_18892.comp_3487())));
            }
        }
        class_327 font = class_310.method_1551().field_1772;
        int y = 0;
        for (class_2561 class_25612 : lines) {
            graphics.method_51439(font, class_25612, 0, y, -1, false);
            Objects.requireNonNull(font);
            y += 9;
        }
    }

    public static void resetCracker() {
        Configs.enchCrackState = CrackState.UNCRACKED;
        possibleXPSeeds.clear();
    }

    private static void prepareForNextEnchantmentSeedCrack(int serverReportedXPSeed) {
        serverReportedXPSeed &= 0xFFF0;
        for (int highBits = 0; highBits < 65536; ++highBits) {
            for (int low4Bits = 0; low4Bits < 16; ++low4Bits) {
                possibleXPSeeds.add(highBits << 16 | serverReportedXPSeed | low4Bits);
            }
        }
    }

    public static void addEnchantmentSeedInfo(class_1937 level, class_1718 menu) {
        CrackState crackState = Configs.enchCrackState;
        if (crackState == CrackState.CRACKED) {
            return;
        }
        class_1799 itemToEnchant = menu.method_7611(0).method_7677();
        if (itemToEnchant.method_7960() || !itemToEnchant.method_7923()) {
            return;
        }
        if (enchantingTablePos == null) {
            return;
        }
        class_2338 tablePos = enchantingTablePos;
        if (crackState == CrackState.UNCRACKED) {
            Configs.enchCrackState = CrackState.CRACKING;
            EnchantmentCracker.prepareForNextEnchantmentSeedCrack(menu.method_17413());
        }
        int power = EnchantmentCracker.getEnchantPower(level, tablePos);
        class_5819 rand = class_5819.method_43047();
        int[] actualEnchantCosts = menu.field_7808;
        int[] actualEnchantmentClues = menu.field_7812;
        int[] actualLevelClues = menu.field_7810;
        class_2378 enchantmentRegistry = level.method_30349().method_30530(class_7924.field_41265);
        class_2359 enchantmentIdMap = enchantmentRegistry.method_40295();
        int version = MultiVersionCompat.INSTANCE.getProtocolVersion();
        Iterator<Integer> xpSeedItr = possibleXPSeeds.iterator();
        block0: while (xpSeedItr.hasNext()) {
            int slot;
            int xpSeed = xpSeedItr.next();
            rand.method_43052((long)xpSeed);
            for (slot = 0; slot < 3; ++slot) {
                int cost = class_1890.method_8227((class_5819)rand, (int)slot, (int)power, (class_1799)itemToEnchant);
                if (cost < slot + 1) {
                    cost = 0;
                }
                if (cost == actualEnchantCosts[slot]) continue;
                xpSeedItr.remove();
                continue block0;
            }
            for (slot = 0; slot < 3; ++slot) {
                if (actualEnchantCosts[slot] <= 0) continue;
                List<class_1889> enchantments = EnchantmentCracker.getEnchantmentList((class_2378<class_1887>)enchantmentRegistry, rand, xpSeed, itemToEnchant, slot, actualEnchantCosts[slot], version);
                if (enchantments == null || enchantments.isEmpty()) {
                    if (actualEnchantmentClues[slot] == -1 && actualLevelClues[slot] == -1) continue;
                    xpSeedItr.remove();
                    continue block0;
                }
                class_1889 clue = enchantments.get(rand.method_43048(enchantments.size()));
                if (enchantmentIdMap.method_10206((Object)clue.comp_3486()) == actualEnchantmentClues[slot] && clue.comp_3487() == actualLevelClues[slot]) continue;
                xpSeedItr.remove();
                continue block0;
            }
        }
        if (possibleXPSeeds.isEmpty()) {
            Configs.enchCrackState = CrackState.UNCRACKED;
            LOGGER.warn("Invalid enchantment seed information. Has the server got unknown mods, is there a desync, or is the client just bugged?");
        } else if (possibleXPSeeds.size() == 1) {
            Configs.enchCrackState = CrackState.CRACKED;
            EnchantmentCracker.addPlayerRNGInfo(possibleXPSeeds.iterator().next());
        }
    }

    private static void addPlayerRNGInfo(int enchantmentSeed) {
        if (Configs.playerCrackState == PlayerRandCracker.CrackState.ENCH_CRACKING_1) {
            firstXpSeed = enchantmentSeed;
            Configs.playerCrackState = PlayerRandCracker.CrackState.HALF_CRACKED;
        } else if (Configs.playerCrackState == PlayerRandCracker.CrackState.ENCH_CRACKING_2) {
            long max_1 = Integer.toUnsignedLong(firstXpSeed) + 1L;
            long min_1 = Integer.toUnsignedLong(firstXpSeed);
            long max_2 = Integer.toUnsignedLong(enchantmentSeed) + 1L;
            long a = 24667315L * max_1 + 18218081L * max_2 >> 32;
            long b = -4824621L * min_1 + 7847617L * max_2 >> 32;
            boolean valid = true;
            long seed = 7847617L * a - 18218081L * b & 0xFFFFFFFFFFFFL;
            if ((int)(seed >>> 16) != firstXpSeed) {
                valid = false;
            }
            if ((int)((seed = seed * 25214903917L + 11L & 0xFFFFFFFFFFFFL) >>> 16) != enchantmentSeed) {
                valid = false;
            }
            if (valid) {
                PlayerRandCracker.setSeed(seed);
                Configs.playerCrackState = PlayerRandCracker.CrackState.CRACKED;
            } else {
                Configs.playerCrackState = PlayerRandCracker.CrackState.UNCRACKED;
                LOGGER.warn("Invalid player RNG information. Has the server got unknown mods, is there a desync, has an operator used /give, or is the client just bugged?");
            }
        }
    }

    private static void onRNGCallEvent(PlayerRandCracker.RNGCallEvent event) {
        if (event.getType() != PlayerRandCracker.RNGCallType.ENCHANTING) {
            LongTask enchantingTask;
            LongTask longTask = enchantingTask = currentEnchantingTask == null ? null : (LongTask)currentEnchantingTask.get();
            if (enchantingTask != null && !isCurrentlyThrowingItems) {
                ClientCommandHelper.sendError((class_2561)class_2561.method_43469((String)"commands.cenchant.unexpectedCall", (Object[])new Object[]{event.getType().getResetMessage()}));
                enchantingTask._break();
            }
            return;
        }
        if (Configs.playerCrackState == PlayerRandCracker.CrackState.UNCRACKED && !EnchantmentCracker.isEnchantingPredictionEnabled()) {
            return;
        }
        if (Configs.playerCrackState.knowsSeed()) {
            long prevSeed = PlayerRandCracker.getSeed();
            int xpSeed = PlayerRandCracker.nextInt();
            PlayerRandCracker.setSeed(prevSeed);
            possibleXPSeeds.clear();
            possibleXPSeeds.add(xpSeed);
            Configs.playerCrackState = PlayerRandCracker.CrackState.CRACKED;
            Configs.enchCrackState = CrackState.CRACKED;
            event.setMaintained();
        } else if (Configs.playerCrackState == PlayerRandCracker.CrackState.HALF_CRACKED) {
            possibleXPSeeds.clear();
            Configs.playerCrackState = PlayerRandCracker.CrackState.ENCH_CRACKING_2;
            Configs.enchCrackState = CrackState.UNCRACKED;
            event.setMaintainedEvenIfSeedUnknown();
        } else if (Configs.playerCrackState == PlayerRandCracker.CrackState.UNCRACKED || Configs.playerCrackState == PlayerRandCracker.CrackState.ENCH_CRACKING_1 || Configs.playerCrackState == PlayerRandCracker.CrackState.ENCH_CRACKING_2) {
            possibleXPSeeds.clear();
            Configs.playerCrackState = PlayerRandCracker.CrackState.ENCH_CRACKING_1;
            Configs.enchCrackState = CrackState.UNCRACKED;
            event.setMaintainedEvenIfSeedUnknown();
        }
        doneEnchantment = true;
        expectedNumBookshelves = -1;
    }

    public static String manipulateEnchantments(class_1792 item, Predicate<List<class_1889>> enchantmentsPredicate, final boolean simulate, final Consumer<@Nullable ManipulateResult> callback) throws CommandSyntaxException {
        final class_746 player = class_310.method_1551().field_1724;
        assert (player != null);
        final ExecutorService threadPool = Executors.newFixedThreadPool(Math.max(1, Runtime.getRuntime().availableProcessors() - (class_310.method_1551().method_1496() ? 2 : 1)), new ThreadFactoryBuilder().setNameFormat("Enchantment Cracker #%d").build());
        int noDummyXpSeed = Configs.enchCrackState == CrackState.CRACKED ? possibleXPSeeds.iterator().next() : 0;
        class_1799 stack = new class_1799((class_1935)item);
        long playerSeed = PlayerRandCracker.getSeed();
        class_2378 enchantmentRegistry = player.method_56673().method_30530(class_7924.field_41265);
        int version = MultiVersionCompat.INSTANCE.getProtocolVersion();
        final ArrayList<CompletableFuture<@Nullable ManipulateResult>> futures = new ArrayList<CompletableFuture<ManipulateResult>>();
        int i = Configs.enchCrackState == CrackState.CRACKED ? -1 : 0;
        while (i < (Configs.playerCrackState.knowsSeed() ? Configs.getMaxEnchantItemThrows() : 0)) {
            int times = i++;
            futures.add(CompletableFuture.supplyAsync(() -> {
                try {
                    Rand playerRand = new Rand(LCG.JAVA, playerSeed);
                    playerRand.advance((long)Math.max(times, 0) * 4L);
                    int xpSeed = times == -1 ? noDummyXpSeed : (int)playerRand.nextBits(32);
                    int[] enchantLevels = new int[3];
                    class_5819 rand = class_5819.method_43047();
                    for (int bookshelvesNeeded = Configs.getMinEnchantBookshelves(); bookshelvesNeeded <= Configs.getMaxEnchantBookshelves(); ++bookshelvesNeeded) {
                        rand.method_43052((long)xpSeed);
                        for (int slot = 0; slot < 3; ++slot) {
                            int level = class_1890.method_8227((class_5819)rand, (int)slot, (int)bookshelvesNeeded, (class_1799)stack);
                            if (level < slot + 1) {
                                level = 0;
                            }
                            enchantLevels[slot] = level;
                        }
                        int maxEnchantSlot = Configs.getMaxEnchantSlot();
                        for (int slot = 0; slot < maxEnchantSlot; ++slot) {
                            List<class_1889> enchantments = EnchantmentCracker.getEnchantmentList((class_2378<class_1887>)enchantmentRegistry, rand, xpSeed, stack, slot, enchantLevels[slot], version);
                            if (!enchantmentsPredicate.test(enchantments) || enchantLevels[slot] < Configs.getMinEnchantLevels() || enchantLevels[slot] > Configs.getMaxEnchantLevels()) continue;
                            return new ManipulateResult(times, bookshelvesNeeded, slot, enchantments);
                        }
                    }
                }
                catch (Throwable e) {
                    LOGGER.error("An error occurred simulating enchantments", e);
                }
                return null;
            }, threadPool));
        }
        final LongTaskList taskList = new LongTaskList(){

            @Override
            public Set<Object> getMutexKeys() {
                return simulate ? Set.of(EnchantmentCracker.class) : Set.of(EnchantmentCracker.class, ItemThrowTask.class);
            }

            @Override
            public void onCompleted() {
                super.onCompleted();
                currentEnchantingTask = null;
            }
        };
        currentEnchantingTask = new WeakReference<1>(taskList);
        taskList.addTask(new SimpleTask(){
            private int index = 0;
            ManipulateResult finalResult = null;
            private boolean hasShutDown = false;

            @Override
            protected void onTick() {
                CompletableFuture future;
                while (this.index < futures.size() && (future = (CompletableFuture)futures.get(this.index)).isDone()) {
                    ManipulateResult result = (ManipulateResult)future.join();
                    if (result != null) {
                        this.finalResult = result;
                        this._break();
                        return;
                    }
                    ++this.index;
                }
            }

            @Override
            public boolean condition() {
                return this.index < futures.size();
            }

            @Override
            public boolean stopOnLevelUnload(boolean isDisconnect) {
                if (!this.hasShutDown) {
                    threadPool.shutdownNow();
                    this.hasShutDown = true;
                }
                return true;
            }

            @Override
            public void onCompleted() {
                if (!this.hasShutDown) {
                    threadPool.shutdownNow();
                    this.hasShutDown = true;
                }
                if (!simulate && this.finalResult != null) {
                    doneEnchantment = false;
                    int timesNeeded = this.finalResult.itemThrows();
                    if (timesNeeded != -1) {
                        if (timesNeeded != 0) {
                            player.method_5808(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), 90.0f);
                            player.field_3944.method_52787((class_2596)new class_2828.class_2831(player.method_36454(), 90.0f, player.method_24828(), player.field_5976));
                        }
                        if (timesNeeded > 0) {
                            isCurrentlyThrowingItems = true;
                            taskList.addTask(new ItemThrowTask(timesNeeded, 2){

                                @Override
                                public void onCompleted() {
                                    super.onCompleted();
                                    class_310.method_1551().field_1724.method_17356((class_3414)class_3417.field_14622.comp_349(), class_3419.field_15248, 1.0f, 2.0f);
                                    isCurrentlyThrowingItems = false;
                                }

                                @Override
                                protected void onFailedToThrowItem(PlayerRandCracker.ThrowItemsResult throwItemsResult) {
                                    super.onFailedToThrowItem(throwItemsResult);
                                    if (throwItemsResult.getType() != PlayerRandCracker.ThrowItemsResult.Type.NOT_ENOUGH_ITEMS) {
                                        taskList._break();
                                    }
                                }

                                @Override
                                protected void onUnexpectedRNGCall(PlayerRandCracker.RNGCallType callType) {
                                    ClientCommandHelper.sendError((class_2561)class_2561.method_43469((String)"commands.cenchant.unexpectedCall", (Object[])new Object[]{callType.getResetMessage()}));
                                    taskList._break();
                                }

                                @Override
                                protected void onItemThrown(int current, int total) {
                                    class_5250 builder = class_2561.method_43473();
                                    int color = class_3532.method_15369((float)((float)current / ((float)total * 3.0f)), (float)1.0f, (float)1.0f);
                                    builder.method_10852((class_2561)class_2561.method_43470((String)"[").method_54663(0xAAAAAA));
                                    builder.method_10852((class_2561)class_2561.method_43470((String)("~" + Math.round(100.0 * (double)current / (double)total) + "%")).method_54663(color));
                                    builder.method_10852((class_2561)class_2561.method_43470((String)"] ").method_54663(0xAAAAAA));
                                    int filledWidth = (int)Math.round(50.0 * (double)current / (double)total);
                                    int unfilledWidth = 50 - filledWidth;
                                    builder.method_10852((class_2561)class_2561.method_43470((String)"|".repeat(filledWidth)).method_54663(color));
                                    builder.method_10852((class_2561)class_2561.method_43470((String)"|".repeat(unfilledWidth)).method_54663(0xAAAAAA));
                                    class_310.method_1551().field_1705.method_1758((class_2561)builder, false);
                                }
                            });
                        }
                        taskList.addTask(new LongTask(this){

                            @Override
                            public void initialize() {
                                class_310.method_1551().field_1705.method_1743().method_1812((class_2561)class_2561.method_43471((String)"enchCrack.insn.dummy"));
                            }

                            @Override
                            public boolean condition() {
                                return !doneEnchantment;
                            }

                            @Override
                            public void increment() {
                            }

                            @Override
                            public void body() {
                                this.scheduleDelay();
                            }

                            public String toString() {
                                return "Enchantment Cracker Wait Dummy";
                            }
                        });
                    }
                    taskList.addTask(new OneTickTask(){

                        @Override
                        public void run() {
                            if (Configs.enchCrackState == CrackState.CRACKED) {
                                class_338 chat = class_310.method_1551().field_1705.method_1743();
                                chat.method_1812((class_2561)class_2561.method_43471((String)"enchCrack.insn.ready").method_27692(class_124.field_1067));
                                chat.method_1812((class_2561)class_2561.method_43469((String)"enchCrack.insn.bookshelves", (Object[])new Object[]{finalResult.bookshelves}));
                                chat.method_1812((class_2561)class_2561.method_43469((String)"enchCrack.insn.slot", (Object[])new Object[]{finalResult.slot + 1}));
                                expectedNumBookshelves = finalResult.bookshelves;
                            }
                        }

                        public String toString() {
                            return "Enchantment Cracker Done Message";
                        }
                    });
                }
                callback.accept(this.finalResult);
            }

            public String toString() {
                return "Enchantment Cracker Worker Poller";
            }
        });
        return TaskManager.addTask("enchantmentCracker", taskList);
    }

    public static boolean isEnchantingPredictionEnabled() {
        return Configs.enchantingPrediction;
    }

    private static int getEnchantPower(class_1937 level, class_2338 tablePos) {
        int power = 0;
        int protocolVersion = MultiVersionCompat.INSTANCE.getProtocolVersion();
        for (class_2338 bookshelfOffset : class_2331.field_36535) {
            class_2338 obstructionPos;
            if (protocolVersion <= 757) {
                obstructionPos = tablePos.method_10069(class_3532.method_15340((int)bookshelfOffset.method_10263(), (int)-1, (int)1), 0, class_3532.method_15340((int)bookshelfOffset.method_10260(), (int)-1, (int)1));
                if (!level.method_8320(tablePos.method_10081((class_2382)bookshelfOffset)).method_27852(class_2246.field_10504) || !level.method_8320(obstructionPos).method_26215()) continue;
                ++power;
                continue;
            }
            if (protocolVersion < 763) {
                obstructionPos = tablePos.method_10069(bookshelfOffset.method_10263() / 2, bookshelfOffset.method_10264(), bookshelfOffset.method_10260() / 2);
                if (!level.method_8320(tablePos.method_10081((class_2382)bookshelfOffset)).method_27852(class_2246.field_10504) || !level.method_8320(obstructionPos).method_26215()) continue;
                ++power;
                continue;
            }
            if (!class_2331.method_40445((class_1937)level, (class_2338)tablePos, (class_2338)bookshelfOffset)) continue;
            ++power;
        }
        return power;
    }

    private static List<class_1889> getEnchantmentList(class_2378<class_1887> enchantmentRegistry, class_5819 rand, int xpSeed, class_1799 stack, int enchantSlot, int level, int version) {
        List list;
        rand.method_43052((long)(xpSeed + enchantSlot));
        if (version >= 767) {
            Iterable tag = enchantmentRegistry.method_40286(class_9636.field_51547);
            list = class_1890.method_8230((class_5819)rand, (class_1799)stack, (int)level, StreamSupport.stream(tag.spliterator(), false));
        } else {
            list = LegacyEnchantment.addRandomEnchantments(rand, stack, level, false, version).stream().flatMap(legacyEnch -> enchantmentRegistry.method_46746(legacyEnch.ench().enchantmentKey).map(ench -> new class_1889((class_6880)ench, legacyEnch.level())).stream()).collect(Collectors.toCollection(ArrayList::new));
        }
        if (stack.method_7909() == class_1802.field_8529 && list.size() > 1) {
            list.remove(rand.method_43048(list.size()));
        }
        return list;
    }

    @Nullable
    public static List<class_1889> getEnchantmentsInTable(int slot) {
        class_746 player = class_310.method_1551().field_1724;
        assert (player != null);
        class_2378 enchantmentRegistry = player.method_56673().method_30530(class_7924.field_41265);
        CrackState crackState = Configs.enchCrackState;
        class_1703 class_17032 = player.field_7512;
        if (!(class_17032 instanceof class_1718)) {
            return null;
        }
        class_1718 enchMenu = (class_1718)class_17032;
        if (crackState != CrackState.CRACKED) {
            if (enchMenu.field_7812[slot] == -1) {
                return null;
            }
            class_6880 enchantment = (class_6880)enchantmentRegistry.method_40295().method_10200(enchMenu.field_7812[slot]);
            if (enchantment == null) {
                return null;
            }
            return new ArrayList<class_1889>(Collections.singletonList(new class_1889(enchantment, enchMenu.field_7810[slot])));
        }
        class_5819 rand = class_5819.method_43047();
        int xpSeed = possibleXPSeeds.iterator().next();
        class_1799 enchantingStack = enchMenu.method_7611(0).method_7677();
        int enchantLevels = enchMenu.field_7808[slot];
        return EnchantmentCracker.getEnchantmentList((class_2378<class_1887>)enchantmentRegistry, rand, xpSeed, enchantingStack, slot, enchantLevels, MultiVersionCompat.INSTANCE.getProtocolVersion());
    }

    public static void sortIntoTooltipOrder(class_2378<class_1887> enchantmentRegistry, List<class_1889> list) {
        if (MultiVersionCompat.INSTANCE.getProtocolVersion() < 767) {
            return;
        }
        Iterable tooltipOrder = enchantmentRegistry.method_40286(class_9636.field_51362);
        Object2IntOpenHashMap tooltipIndex = new Object2IntOpenHashMap();
        int index = 0;
        for (class_6880 ench : tooltipOrder) {
            tooltipIndex.put((Object)ench, index++);
        }
        list.sort(Comparator.comparingInt(arg_0 -> EnchantmentCracker.lambda$sortIntoTooltipOrder$4((Object2IntMap)tooltipIndex, arg_0)));
    }

    private static /* synthetic */ int lambda$sortIntoTooltipOrder$4(Object2IntMap tooltipIndex, class_1889 ench) {
        return tooltipIndex.getInt((Object)ench.comp_3486());
    }

    static {
        enchantingTablePos = null;
        doneEnchantment = false;
    }

    public static enum CrackState implements class_3542
    {
        UNCRACKED("uncracked"),
        CRACKED("cracked"),
        CRACKING("cracking");

        private final String name;

        private CrackState(String name) {
            this.name = name;
        }

        public String method_15434() {
            return this.name;
        }
    }

    public record ManipulateResult(int itemThrows, int bookshelves, int slot, List<class_1889> enchantments) {
        public static final int NO_DUMMY = -1;
    }
}

