/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands;

import com.google.common.base.Suppliers;
import dev.xpple.betterconfig.api.BetterConfigAPI;
import dev.xpple.betterconfig.api.Config;
import dev.xpple.betterconfig.api.ModConfig;
import java.util.Locale;
import java.util.function.Supplier;
import net.earthcomputer.clientcommands.features.ChorusManipulation;
import net.earthcomputer.clientcommands.features.EnchantmentCracker;
import net.earthcomputer.clientcommands.features.FishingCracker;
import net.earthcomputer.clientcommands.features.PlayerRandCracker;
import net.earthcomputer.clientcommands.features.ServerBrandManager;
import net.earthcomputer.clientcommands.util.MultiVersionCompat;
import net.minecraft.class_2561;
import net.minecraft.class_3532;
import net.minecraft.class_3542;

public class Configs {
    private static final Supplier<ModConfig<class_2561>> CONFIG_REF = Suppliers.memoize(() -> BetterConfigAPI.getInstance().getModConfig("clientcommands"));
    @Config(readOnly=true, temporary=true)
    public static double calcAnswer = 0.0;
    @Config(readOnly=true, temporary=true)
    public static EnchantmentCracker.CrackState enchCrackState = EnchantmentCracker.CrackState.UNCRACKED;
    @Config(readOnly=true, temporary=true)
    public static PlayerRandCracker.CrackState playerCrackState = PlayerRandCracker.CrackState.UNCRACKED;
    @Config(onChange="onChangeEnchantingPrediction", temporary=true)
    public static boolean enchantingPrediction = false;
    @Config(onChange="onChangeFishingManipulation", temporary=true, condition="conditionLessThan1_20")
    public static FishingManipulation fishingManipulation = FishingManipulation.OFF;
    @Config(temporary=true)
    public static boolean playerRNGMaintenance = true;
    @Config
    public static boolean toolBreakWarning = false;
    @Config(setter=@Config.Setter(value="setMaxEnchantItemThrows"))
    private static int maxEnchantItemThrows = 16384;
    @Config(setter=@Config.Setter(value="setMinEnchantBookshelves"), temporary=true)
    private static int minEnchantBookshelves = 0;
    @Config(setter=@Config.Setter(value="setMaxEnchantBookshelves"), temporary=true)
    private static int maxEnchantBookshelves = 15;
    @Config(setter=@Config.Setter(value="setMinEnchantLevels"), temporary=true)
    private static int minEnchantLevels = 1;
    @Config(setter=@Config.Setter(value="setMaxEnchantSlot"), temporary=true)
    private static int maxEnchantSlot = 3;
    @Config(setter=@Config.Setter(value="setMaxEnchantLevels"), temporary=true)
    private static int maxEnchantLevels = 30;
    @Config(onChange="onChangeChorusManipulation", temporary=true)
    public static boolean chorusManipulation = false;
    @Config(setter=@Config.Setter(value="setMaxChorusItemThrows"))
    private static int maxChorusItemThrows = 2048;
    @Config(temporary=true)
    public static String autoPrefix = "";
    @Config(temporary=true, condition="conditionLessThan1_21")
    public static boolean infiniteTools = false;
    @Config
    public static int commandExecutionLimit = 65536;
    @Config
    public static boolean acceptC2CPackets = false;
    @Config
    public static float itemThrowsPerTick = 1.0f;
    @Config
    public static PacketDumpMethod packetDumpMethod = PacketDumpMethod.REFLECTION;
    @Config
    public static int maximumPacketFieldDepth = 10;
    @Config(temporary=true, setter=@Config.Setter(value="setMinimumReplyDelaySeconds"))
    public static float minimumReplyDelaySeconds = 0.5f;
    @Config(readOnly=true)
    public static int overriddenFps = 0;

    public static void save() {
        CONFIG_REF.get().save();
    }

    private static void onChangeEnchantingPrediction(boolean oldEnchantingPrediction, boolean enchantingPrediction) {
        if (enchantingPrediction) {
            ServerBrandManager.rngWarning();
        } else {
            EnchantmentCracker.resetCracker();
        }
    }

    private static void onChangeFishingManipulation(FishingManipulation oldFishingManipulation, FishingManipulation fishingManipulation) {
        if (fishingManipulation.isEnabled()) {
            ServerBrandManager.rngWarning();
        } else {
            FishingCracker.reset();
        }
    }

    public static int getMaxEnchantItemThrows() {
        return maxEnchantItemThrows;
    }

    public static void setMaxEnchantItemThrows(int maxEnchantItemThrows) {
        Configs.maxEnchantItemThrows = class_3532.method_15340((int)maxEnchantItemThrows, (int)0, (int)1000000);
    }

    public static int getMinEnchantBookshelves() {
        return minEnchantBookshelves;
    }

    public static void setMinEnchantBookshelves(int minEnchantBookshelves) {
        Configs.minEnchantBookshelves = class_3532.method_15340((int)minEnchantBookshelves, (int)0, (int)15);
        maxEnchantBookshelves = Math.max(maxEnchantBookshelves, Configs.minEnchantBookshelves);
    }

    public static int getMaxEnchantBookshelves() {
        return maxEnchantBookshelves;
    }

    public static void setMaxEnchantBookshelves(int maxEnchantBookshelves) {
        Configs.maxEnchantBookshelves = class_3532.method_15340((int)maxEnchantBookshelves, (int)0, (int)15);
        minEnchantBookshelves = Math.min(minEnchantBookshelves, Configs.maxEnchantBookshelves);
    }

    public static int getMinEnchantLevels() {
        return minEnchantLevels;
    }

    public static void setMinEnchantLevels(int minEnchantLevels) {
        Configs.minEnchantLevels = class_3532.method_15340((int)minEnchantLevels, (int)1, (int)30);
        maxEnchantLevels = Math.max(maxEnchantLevels, Configs.minEnchantLevels);
    }

    public static int getMaxEnchantSlot() {
        return maxEnchantSlot;
    }

    public static void setMaxEnchantSlot(int minEnchantLevels) {
        maxEnchantSlot = class_3532.method_15340((int)maxEnchantSlot, (int)1, (int)3);
    }

    public static int getMaxEnchantLevels() {
        return maxEnchantLevels;
    }

    public static void setMaxEnchantLevels(int maxEnchantLevels) {
        Configs.maxEnchantLevels = class_3532.method_15340((int)maxEnchantLevels, (int)1, (int)30);
        minEnchantLevels = Math.min(minEnchantLevels, Configs.maxEnchantLevels);
    }

    public static void onChangeChorusManipulation(boolean oldChorusManipulation, boolean chorusManipulation) {
        if (chorusManipulation) {
            ServerBrandManager.rngWarning();
            ChorusManipulation.onChorusManipEnabled();
        }
    }

    public static int getMaxChorusItemThrows() {
        return maxChorusItemThrows;
    }

    public static void setMaxChorusItemThrows(int maxChorusItemThrows) {
        Configs.maxChorusItemThrows = class_3532.method_15340((int)maxChorusItemThrows, (int)0, (int)1000000);
    }

    public static boolean conditionLessThan1_20() {
        return MultiVersionCompat.INSTANCE.getProtocolVersion() < 763;
    }

    public static boolean conditionLessThan1_21() {
        return MultiVersionCompat.INSTANCE.getProtocolVersion() < 767;
    }

    public static void setMinimumReplyDelaySeconds(float minimumReplyDelaySeconds) {
        Configs.minimumReplyDelaySeconds = Math.clamp(minimumReplyDelaySeconds, 0.0f, 300.0f);
    }

    public static enum FishingManipulation implements class_3542
    {
        OFF,
        MANUAL,
        AFK;


        public String method_15434() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public boolean isEnabled() {
            return this != OFF;
        }
    }

    public static enum PacketDumpMethod {
        REFLECTION,
        BYTE_BUF;

    }
}

