/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import net.earthcomputer.clientcommands.Configs;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.earthcomputer.clientcommands.command.Flag;
import net.earthcomputer.clientcommands.command.arguments.ItemAndEnchantmentsPredicateArgument;
import net.earthcomputer.clientcommands.features.EnchantmentCracker;
import net.earthcomputer.clientcommands.features.LegacyEnchantment;
import net.earthcomputer.clientcommands.features.PlayerRandCracker;
import net.earthcomputer.clientcommands.util.MultiVersionCompat;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1935;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import net.minecraft.class_9636;

public class CEnchantCommand {
    private static final Flag<Boolean> FLAG_SIMULATE = Flag.ofFlag("simulate").build();

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 context) {
        LiteralCommandNode cenchant = dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cenchant").then(ClientCommandManager.argument((String)"itemAndEnchantmentsPredicate", (ArgumentType)ItemAndEnchantmentsPredicateArgument.itemAndEnchantmentsPredicate((class_7225.class_7874)context).withEnchantmentPredicate(CEnchantCommand::enchantmentPredicate).constrainMaxLevel()).executes(ctx -> CEnchantCommand.cenchant((FabricClientCommandSource)ctx.getSource(), ItemAndEnchantmentsPredicateArgument.getItemAndEnchantmentsPredicate(ctx, "itemAndEnchantmentsPredicate")))));
        FLAG_SIMULATE.addToCommand(dispatcher, (LiteralCommandNode<FabricClientCommandSource>)cenchant, ctx -> true);
    }

    private static boolean enchantmentPredicate(class_1792 item, class_6880<class_1887> ench) {
        LegacyEnchantment legacyEnch;
        boolean inEnchantingTable = MultiVersionCompat.INSTANCE.getProtocolVersion() < 767 ? (legacyEnch = LegacyEnchantment.byEnchantmentKey((class_5321<class_1887>)((class_5321)ench.method_40230().orElseThrow()))) != null && legacyEnch.inEnchantmentTable() : ench.method_40220(class_9636.field_51547);
        return inEnchantingTable && (item == class_1802.field_8529 || ((class_1887)ench.comp_349()).method_8192(new class_1799((class_1935)item)));
    }

    private static int cenchant(FabricClientCommandSource source, ItemAndEnchantmentsPredicateArgument.ItemAndEnchantmentsPredicate itemAndEnchantmentsPredicate) throws CommandSyntaxException {
        if (!Configs.enchantingPrediction) {
            class_5250 component = class_2561.method_43471((String)"commands.cenchant.needEnchantingPrediction").method_27692(class_124.field_1061).method_27693(" ").method_10852(ClientCommandHelper.getCommandTextComponent("commands.client.enable", "/cconfig clientcommands enchantingPrediction set true"));
            source.sendFeedback((class_2561)component);
            return 1;
        }
        if (!Configs.playerCrackState.knowsSeed() && Configs.enchCrackState != EnchantmentCracker.CrackState.CRACKED) {
            class_5250 component = class_2561.method_43471((String)"commands.cenchant.uncracked").method_27692(class_124.field_1061).method_27693(" ").method_10852(ClientCommandHelper.getCommandTextComponent("commands.client.crack", "/ccrackrng"));
            source.sendFeedback((class_2561)component);
            return 1;
        }
        boolean simulate = ClientCommandHelper.getFlag(source, FLAG_SIMULATE);
        String taskName = EnchantmentCracker.manipulateEnchantments(itemAndEnchantmentsPredicate.item(), itemAndEnchantmentsPredicate.predicate(), simulate, result -> {
            class_638 level = class_310.method_1551().field_1687;
            if (level == null) {
                return;
            }
            if (result == null) {
                source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.cenchant.failed"));
                if (Configs.playerCrackState != PlayerRandCracker.CrackState.CRACKED) {
                    class_5250 help = class_2561.method_43471((String)"commands.cenchant.help.uncrackedPlayerSeed").method_27693(" ").method_10852(ClientCommandHelper.getCommandTextComponent("commands.client.crack", "/ccrackrng"));
                    ClientCommandHelper.sendHelp((class_2561)help);
                }
            } else {
                if (result.itemThrows() < 0) {
                    source.sendFeedback((class_2561)class_2561.method_43471((String)"enchCrack.insn.itemThrows.noDummy"));
                } else {
                    source.sendFeedback((class_2561)class_2561.method_43469((String)"enchCrack.insn.itemThrows", (Object[])new Object[]{result.itemThrows(), Float.valueOf((float)result.itemThrows() / (Configs.itemThrowsPerTick * 20.0f))}));
                }
                source.sendFeedback((class_2561)class_2561.method_43469((String)"enchCrack.insn.bookshelves", (Object[])new Object[]{result.bookshelves()}));
                source.sendFeedback((class_2561)class_2561.method_43469((String)"enchCrack.insn.slot", (Object[])new Object[]{result.slot() + 1}));
                source.sendFeedback((class_2561)class_2561.method_43471((String)"enchCrack.insn.enchantments"));
                ArrayList<class_1889> enchantments = new ArrayList<class_1889>(result.enchantments());
                EnchantmentCracker.sortIntoTooltipOrder((class_2378<class_1887>)level.method_30349().method_30530(class_7924.field_41265), enchantments);
                for (class_1889 ench : enchantments) {
                    source.sendFeedback((class_2561)class_2561.method_43470((String)"- ").method_10852(class_1887.method_8179((class_6880)ench.comp_3486(), (int)ench.comp_3487())));
                }
            }
        });
        source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.cenchant.success").method_27693(" ").method_10852(ClientCommandHelper.getCommandTextComponent("commands.client.cancel", "/ctask stop " + taskName)));
        return 1;
    }
}

