/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.demonwav.mcdev.annotations.Translatable;
import com.mojang.brigadier.context.CommandContext;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.earthcomputer.clientcommands.command.Flag;
import net.earthcomputer.clientcommands.interfaces.IClientSuggestionsProvider;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_5250;

public class ClientCommandHelper {
    private static final Map<UUID, Callback> callbacks = new ConcurrentHashMap<UUID, Callback>();

    public static <T> T getFlag(CommandContext<FabricClientCommandSource> ctx, Flag<T> flag) {
        return ClientCommandHelper.getFlag(Flag.getActualSource(ctx), flag);
    }

    public static <T> T getFlag(FabricClientCommandSource source, Flag<T> flag) {
        return ((IClientSuggestionsProvider)source).clientcommands_getFlag(flag);
    }

    public static <T> FabricClientCommandSource withFlag(FabricClientCommandSource source, Flag<T> flag, T value) {
        return (FabricClientCommandSource)((IClientSuggestionsProvider)source).clientcommands_withFlag(flag, value);
    }

    public static void sendError(class_2561 error) {
        ClientCommandHelper.sendFeedback((class_2561)class_2561.method_43470((String)"").method_10852(error).method_27692(class_124.field_1061));
    }

    public static void sendHelp(class_2561 help) {
        ClientCommandHelper.sendFeedback((class_2561)class_2561.method_43470((String)"").method_10852(help).method_27692(class_124.field_1075));
    }

    public static void sendFeedback(@Translatable String message, Object ... args) {
        ClientCommandHelper.sendFeedback((class_2561)class_2561.method_43469((String)message, (Object[])args));
    }

    public static void sendFeedback(class_2561 message) {
        class_310.method_1551().field_1705.method_1743().method_1812(message);
    }

    public static void sendRequiresRestart() {
        ClientCommandHelper.sendFeedback((class_2561)class_2561.method_43471((String)"commands.client.requiresRestart").method_27692(class_124.field_1054));
    }

    public static void addOverlayMessage(class_2561 message, int time) {
        class_329 gui = class_310.method_1551().field_1705;
        gui.method_1758(message, false);
        gui.field_2041 = time;
    }

    public static class_2561 getLookCoordsTextComponent(class_2338 pos) {
        return ClientCommandHelper.getCommandTextComponent(class_2561.method_43469((String)"commands.client.blockpos", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}), String.format("/clook block %d %d %d", pos.method_10263(), pos.method_10264(), pos.method_10260()));
    }

    public static class_2561 getLookCoordsTextComponent(class_5250 component, class_2338 pos) {
        return ClientCommandHelper.getCommandTextComponent(component, String.format("/clook block %d %d %d", pos.method_10263(), pos.method_10264(), pos.method_10260()));
    }

    public static class_2561 getGlowCoordsTextComponent(class_2338 pos) {
        return ClientCommandHelper.getCommandTextComponent(class_2561.method_43469((String)"commands.client.blockpos", (Object[])new Object[]{pos.method_10263(), pos.method_10264(), pos.method_10260()}), String.format("/cglow block %d %d %d 10", pos.method_10263(), pos.method_10264(), pos.method_10260()));
    }

    public static class_2561 getGlowButtonTextComponent(class_2338 pos) {
        return ClientCommandHelper.getCommandTextComponent(class_2561.method_43471((String)"commands.client.glow"), String.format("/cglow block %d %d %d 10", pos.method_10263(), pos.method_10264(), pos.method_10260()));
    }

    public static class_2561 getGlowButtonTextComponent(class_1297 entity) {
        return ClientCommandHelper.getCommandTextComponent(class_2561.method_43471((String)"commands.client.glow"), "/cglow entities " + entity.method_5845());
    }

    public static class_2561 getCommandTextComponent(@Translatable String translationKey, String command) {
        return ClientCommandHelper.getCommandTextComponent(class_2561.method_43471((String)translationKey), command);
    }

    public static class_2561 getCommandTextComponent(class_5250 component, String command) {
        return component.method_27694(style -> style.method_27706(class_124.field_1073).method_10958((class_2558)new class_2558.class_10609(command)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)command))));
    }

    public static class_2558 callbackClickEvent(Runnable runnable) {
        return ClientCommandHelper.callbackClickEvent(runnable, 60000000000L);
    }

    public static class_2558 callbackClickEvent(Runnable callback, long timeoutNanos) {
        UUID callbackId = UUID.randomUUID();
        callbacks.put(callbackId, new Callback(callback, System.nanoTime() + timeoutNanos));
        return new class_2558.class_10609("/ccallback " + String.valueOf(callbackId));
    }

    public static boolean runCallback(UUID callbackId) {
        Callback callback = callbacks.get(callbackId);
        if (callback == null) {
            return false;
        }
        callback.callback.run();
        return true;
    }

    private record Callback(Runnable callback, long timeout) {
        static {
            Thread.ofVirtual().name("Clientcommands callback cleanup").start(() -> {
                while (true) {
                    try {
                        Thread.sleep(1000L);
                    }
                    catch (InterruptedException e) {
                        break;
                    }
                    long now = System.nanoTime();
                    callbacks.values().removeIf(callback -> now - callback.timeout <= 0L);
                }
            });
        }
    }
}

