/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import net.earthcomputer.clientcommands.Configs;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class FramerateCommand {
    private static final int[] COMMON_REFRESH_RATES = new int[]{30, 45, 60, 75, 90, 100, 120, 144, 165, 180, 240, 300, 360, 420, 480, 540, 600};

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cfps").executes(ctx -> FramerateCommand.getMaxFps((FabricClientCommandSource)ctx.getSource()))).then(ClientCommandManager.literal((String)"unlimited").executes(ctx -> FramerateCommand.maxFps((FabricClientCommandSource)ctx.getSource(), Integer.MAX_VALUE)))).then(ClientCommandManager.argument((String)"maxfps", (ArgumentType)IntegerArgumentType.integer((int)1)).suggests((context, builder) -> {
            int maxFps = FramerateCommand.getDisplayMaxFramerate();
            for (int refreshRate : COMMON_REFRESH_RATES) {
                if (refreshRate > maxFps) break;
                builder.suggest(refreshRate);
            }
            return builder.buildFuture();
        }).executes(ctx -> FramerateCommand.maxFps((FabricClientCommandSource)ctx.getSource(), IntegerArgumentType.getInteger((CommandContext)ctx, (String)"maxfps"))))).then(ClientCommandManager.literal((String)"reset").executes(ctx -> FramerateCommand.resetMaxFps((FabricClientCommandSource)ctx.getSource()))));
    }

    private static int getMaxFps(FabricClientCommandSource source) {
        int framerateLimit = Configs.overriddenFps;
        if (framerateLimit <= 0) {
            framerateLimit = source.getClient().method_61964().method_61937();
        }
        if (framerateLimit < Integer.MAX_VALUE) {
            source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cfps.getMaxFps", (Object[])new Object[]{framerateLimit}));
        } else {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.cfps.getMaxFps.unlimited"));
        }
        return framerateLimit;
    }

    private static int maxFps(FabricClientCommandSource source, int maxFps) {
        Configs.overriddenFps = maxFps;
        Configs.save();
        if (maxFps == Integer.MAX_VALUE) {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.cfps.setMaxFps.unlimited"));
        } else {
            source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cfps.setMaxFps", (Object[])new Object[]{maxFps}));
        }
        return maxFps;
    }

    private static int resetMaxFps(FabricClientCommandSource source) {
        Configs.overriddenFps = 0;
        Configs.save();
        source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.cfps.resetMaxFps.success"));
        return 1;
    }

    private static int getDisplayMaxFramerate() {
        return class_310.method_1551().field_1686.field_16255.field_1993.values().stream().mapToInt(monitor -> monitor.method_1617().method_1671()).max().orElseThrow();
    }
}

