/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.xpple.clientarguments.arguments.CBlockPosArgument;
import dev.xpple.clientarguments.arguments.CBlockPredicateArgument;
import dev.xpple.clientarguments.arguments.CBlockStateArgument;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2694;
import net.minecraft.class_3341;
import net.minecraft.class_4538;
import net.minecraft.class_638;
import net.minecraft.class_7157;

public class GhostBlockCommand {
    private static final SimpleCommandExceptionType SET_FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.setblock.failed"));
    private static final SimpleCommandExceptionType FILL_FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.fill.failed"));

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher, class_7157 context) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cghostblock").then(ClientCommandManager.literal((String)"set").then(ClientCommandManager.argument((String)"pos", (ArgumentType)CBlockPosArgument.blockPos()).then(ClientCommandManager.argument((String)"block", (ArgumentType)CBlockStateArgument.blockState((class_7157)context)).executes(ctx -> GhostBlockCommand.setGhostBlock((FabricClientCommandSource)ctx.getSource(), CBlockPosArgument.getBlockPos((CommandContext)ctx, (String)"pos"), CBlockStateArgument.getBlockState((CommandContext)ctx, (String)"block").getState())))))).then(ClientCommandManager.literal((String)"fill").then(ClientCommandManager.argument((String)"from", (ArgumentType)CBlockPosArgument.blockPos()).then(ClientCommandManager.argument((String)"to", (ArgumentType)CBlockPosArgument.blockPos()).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"block", (ArgumentType)CBlockStateArgument.blockState((class_7157)context)).executes(ctx -> GhostBlockCommand.fillGhostBlocks((FabricClientCommandSource)ctx.getSource(), CBlockPosArgument.getBlockPos((CommandContext)ctx, (String)"from"), CBlockPosArgument.getBlockPos((CommandContext)ctx, (String)"to"), CBlockStateArgument.getBlockState((CommandContext)ctx, (String)"block").getState(), pos -> true))).then(ClientCommandManager.literal((String)"replace").then(ClientCommandManager.argument((String)"filter", (ArgumentType)CBlockPredicateArgument.blockPredicate((class_7157)context)).executes(ctx -> GhostBlockCommand.fillGhostBlocks((FabricClientCommandSource)ctx.getSource(), CBlockPosArgument.getBlockPos((CommandContext)ctx, (String)"from"), CBlockPosArgument.getBlockPos((CommandContext)ctx, (String)"to"), CBlockStateArgument.getBlockState((CommandContext)ctx, (String)"block").getState(), CBlockPredicateArgument.getBlockPredicate((CommandContext)ctx, (String)"filter"))))))))));
    }

    private static int setGhostBlock(FabricClientCommandSource source, class_2338 pos, class_2680 state) throws CommandSyntaxException {
        class_638 level = source.getWorld();
        assert (level != null);
        GhostBlockCommand.checkLoaded(level, pos);
        boolean result = level.method_8652(pos, state, 18);
        if (result) {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.cghostblock.set.success"));
            return 1;
        }
        throw SET_FAILED_EXCEPTION.create();
    }

    private static int fillGhostBlocks(FabricClientCommandSource source, class_2338 from, class_2338 to, class_2680 state, Predicate<class_2694> filter) throws CommandSyntaxException {
        class_638 level = source.getWorld();
        assert (level != null);
        GhostBlockCommand.checkLoaded(level, from);
        GhostBlockCommand.checkLoaded(level, to);
        class_3341 range = class_3341.method_34390((class_2382)from, (class_2382)to);
        int successCount = 0;
        for (class_2338 pos : class_2338.method_10094((int)range.method_35415(), (int)range.method_35416(), (int)range.method_35417(), (int)range.method_35418(), (int)range.method_35419(), (int)range.method_35420())) {
            if (!filter.test(new class_2694((class_4538)level, pos, true)) || !level.method_8652(pos, state, 18)) continue;
            ++successCount;
        }
        if (successCount == 0) {
            throw FILL_FAILED_EXCEPTION.create();
        }
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cghostblock.fill.success", (Object[])new Object[]{successCount}));
        return successCount;
    }

    private static void checkLoaded(class_638 level, class_2338 pos) throws CommandSyntaxException {
        if (!level.method_22340(pos)) {
            throw CBlockPosArgument.UNLOADED_EXCEPTION.create();
        }
        if (!level.method_24794(pos)) {
            throw CBlockPosArgument.OUT_OF_WORLD_EXCEPTION.create();
        }
    }
}

