/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.Dynamic2CommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import dev.xpple.clientarguments.arguments.CMessageArgument;
import java.util.ArrayList;
import java.util.List;
import net.earthcomputer.clientcommands.Configs;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2561;
import org.jetbrains.annotations.Nullable;

public class ReplyCommand {
    public static final float MAXIMUM_REPLY_DELAY_SECONDS = 300.0f;
    private static final SimpleCommandExceptionType NO_TARGET_FOUND_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.creply.noTargetFound"));
    private static final Dynamic2CommandExceptionType MESSAGE_TOO_LONG_EXCEPTION = new Dynamic2CommandExceptionType((a, b) -> class_2561.method_43469((String)"commands.creply.messageTooLong", (Object[])new Object[]{a, b}));
    private static final List<ReplyCandidate> replyCandidates = new ArrayList<ReplyCandidate>();

    @Nullable
    public static String getCurrentTarget() {
        ReplyCandidate candidate;
        int i;
        long now = System.currentTimeMillis();
        for (i = 0; i < replyCandidates.size(); ++i) {
            candidate = replyCandidates.get(i);
            if (!((float)(now - candidate.timestampMs) > 300000.0f)) break;
            replyCandidates.remove(i--);
        }
        for (i = replyCandidates.size() - 1; i >= 0; --i) {
            candidate = replyCandidates.get(i);
            if (!((float)(now - candidate.timestampMs) >= Configs.minimumReplyDelaySeconds * 1000.0f)) continue;
            return candidate.username;
        }
        return null;
    }

    public static void addReplyCandidate(String username, long timestamp) {
        replyCandidates.add(new ReplyCandidate(username, timestamp));
    }

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralCommandNode command = dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"creply").then(ClientCommandManager.argument((String)"message", (ArgumentType)CMessageArgument.message()).executes(ctx -> ReplyCommand.reply((FabricClientCommandSource)ctx.getSource(), CMessageArgument.getMessage((CommandContext)ctx, (String)"message")))));
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cr").redirect((CommandNode)command));
    }

    public static int reply(FabricClientCommandSource source, class_2561 message) throws CommandSyntaxException {
        String target = ReplyCommand.getCurrentTarget();
        if (target == null) {
            throw NO_TARGET_FOUND_EXCEPTION.create();
        }
        String text = message.getString();
        String command = String.format("w %s %s", target, text);
        if (command.length() > 256) {
            throw MESSAGE_TOO_LONG_EXCEPTION.create((Object)(256 - (command.length() - text.length())), (Object)text.length());
        }
        source.getClient().method_1562().method_45730(command);
        return 1;
    }

    private record ReplyCandidate(String username, long timestampMs) {
    }
}

