/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.ArrayList;
import net.earthcomputer.clientcommands.task.TaskManager;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2561;

public class TaskCommand {
    private static final SimpleCommandExceptionType NO_MATCH_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.ctask.stop.noMatch"));

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"ctask").then(ClientCommandManager.literal((String)"list").executes(ctx -> TaskCommand.listTasks((FabricClientCommandSource)ctx.getSource())))).then(ClientCommandManager.literal((String)"stop-all").executes(ctx -> TaskCommand.stopTasks((FabricClientCommandSource)ctx.getSource(), "")))).then(ClientCommandManager.literal((String)"stop").then(ClientCommandManager.argument((String)"pattern", (ArgumentType)StringArgumentType.string()).executes(ctx -> TaskCommand.stopTasks((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"pattern"))))));
    }

    private static int listTasks(FabricClientCommandSource source) {
        Iterable<String> tasks = TaskManager.getTaskNames();
        int taskCount = TaskManager.getTaskCount();
        if (taskCount == 0) {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.ctask.list.noTasks"));
        } else {
            source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.ctask.list.success", (Object[])new Object[]{taskCount}).method_27692(class_124.field_1067));
            for (String task : tasks) {
                source.sendFeedback((class_2561)class_2561.method_43470((String)("- " + task)));
            }
        }
        return taskCount;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int stopTasks(FabricClientCommandSource source, String pattern) throws CommandSyntaxException {
        ArrayList<String> tasksToStop = new ArrayList<String>();
        for (String task : TaskManager.getTaskNames()) {
            if (!task.contains(pattern)) continue;
            tasksToStop.add(task);
        }
        for (String task : tasksToStop) {
            TaskManager.removeTask(task);
        }
        if (tasksToStop.isEmpty()) {
            if (!pattern.isEmpty()) throw NO_MATCH_EXCEPTION.create();
            source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.ctask.list.noTasks"));
            return tasksToStop.size();
        } else {
            source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.ctask.stop.success", (Object[])new Object[]{tasksToStop.size()}));
        }
        return tasksToStop.size();
    }
}

