/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.concurrent.CompletableFuture;
import net.earthcomputer.clientcommands.command.arguments.TranslationQueryArgument;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import org.apache.http.client.utils.URIBuilder;

public class TranslateCommand {
    private static final SimpleCommandExceptionType UNKNOWN_ERROR_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.ctranslate.unknownError"));
    private static final String URL = "https://translate.googleapis.com/translate_a/single?client=gtx&dt=t";
    private static final HttpClient httpClient = HttpClient.newHttpClient();
    private static final Duration DURATION = Duration.ofSeconds(5L);

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"ctranslate").then(ClientCommandManager.argument((String)"query", (ArgumentType)TranslationQueryArgument.translationQuery()).executes(ctx -> TranslateCommand.translate((FabricClientCommandSource)ctx.getSource(), TranslationQueryArgument.getTranslationQuery((CommandContext<FabricClientCommandSource>)ctx, "query")))));
    }

    private static int translate(FabricClientCommandSource source, TranslationQueryArgument.TranslationQuery query) throws CommandSyntaxException {
        try {
            HttpRequest request = HttpRequest.newBuilder(TranslateCommand.createUri(query.from(), query.to(), query.query())).timeout(DURATION).GET().build();
            ((CompletableFuture)httpClient.sendAsync(request, HttpResponse.BodyHandlers.ofString()).thenApply(HttpResponse::body)).thenAccept(response -> source.getClient().method_63588(() -> {
                JsonArray result = JsonParser.parseString((String)response).getAsJsonArray();
                source.sendFeedback(TranslateCommand.createText(result.get(0).getAsJsonArray().get(0).getAsJsonArray().get(0).getAsString()));
            }));
        }
        catch (Exception e) {
            throw UNKNOWN_ERROR_EXCEPTION.create();
        }
        return 1;
    }

    private static URI createUri(String from, String to, String query) throws URISyntaxException {
        URIBuilder builder = new URIBuilder(URL, Charset.defaultCharset());
        builder.addParameter("sl", from);
        builder.addParameter("tl", to);
        builder.addParameter("q", query);
        return builder.build();
    }

    private static class_2561 createText(String translation) {
        return class_2561.method_43470((String)translation).method_27694(s -> s.method_30938(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10606(translation)).method_10975(translation).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"commands.ctranslate.hoverText"))));
    }
}

