/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.google.common.collect.Iterables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.ParseResults;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedCommandNode;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.brigadier.tree.CommandNode;
import com.mojang.brigadier.tree.LiteralCommandNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.UnaryOperator;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.earthcomputer.clientcommands.command.Flag;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_5250;

public class UsageTreeCommand {
    private static final SimpleCommandExceptionType FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.help.failed"));
    private static final Flag<UnaryOperator<CommandDispatcher<FabricClientCommandSource>>> FLAG_DISPATCHER = Flag.of(UnaryOperator.class, "all").withDefaultValue(UnaryOperator.identity()).build();

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralCommandNode cusagetree = dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cusagetree").executes(ctx -> UsageTreeCommand.usage((FabricClientCommandSource)ctx.getSource(), (CommandDispatcher<FabricClientCommandSource>)((CommandDispatcher)ClientCommandHelper.getFlag((CommandContext<FabricClientCommandSource>)ctx, FLAG_DISPATCHER).apply(dispatcher))))).then(ClientCommandManager.argument((String)"command", (ArgumentType)StringArgumentType.greedyString()).suggests((ctx, builder) -> class_2172.method_9265(((CommandDispatcher)ClientCommandHelper.getFlag((CommandContext<FabricClientCommandSource>)ctx, FLAG_DISPATCHER).apply(dispatcher)).getRoot().getChildren().stream().map(CommandNode::getUsageText).toList(), (SuggestionsBuilder)builder)).executes(ctx -> UsageTreeCommand.usageCommand((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"command"), (CommandDispatcher<FabricClientCommandSource>)((CommandDispatcher)ClientCommandHelper.getFlag((CommandContext<FabricClientCommandSource>)ctx, FLAG_DISPATCHER).apply(dispatcher))))));
        FLAG_DISPATCHER.addToCommand(dispatcher, (LiteralCommandNode<FabricClientCommandSource>)cusagetree, ctx -> d -> Objects.requireNonNull(class_310.method_1551().method_1562()).method_2886());
    }

    private static int usage(FabricClientCommandSource source, CommandDispatcher<FabricClientCommandSource> dispatcher) {
        List<class_2561> content = UsageTreeCommand.tree((CommandNode<FabricClientCommandSource>)dispatcher.getRoot());
        source.sendFeedback((class_2561)class_2561.method_43470((String)"/"));
        for (class_2561 line : content) {
            source.sendFeedback(line);
        }
        return content.size();
    }

    private static int usageCommand(FabricClientCommandSource source, String cmdName, CommandDispatcher<FabricClientCommandSource> dispatcher) throws CommandSyntaxException {
        ParseResults parseResults = dispatcher.parse(cmdName, (Object)source);
        if (parseResults.getContext().getNodes().isEmpty()) {
            throw FAILED_EXCEPTION.create();
        }
        CommandNode node = ((ParsedCommandNode)Iterables.getLast((Iterable)parseResults.getContext().getNodes())).getNode();
        List<class_2561> content = UsageTreeCommand.tree((CommandNode<FabricClientCommandSource>)node);
        source.sendFeedback((class_2561)class_2561.method_43470((String)("/" + cmdName)).method_27694(s -> s.method_10977(node.getCommand() != null ? class_124.field_1060 : class_124.field_1068)));
        for (class_2561 line : content) {
            source.sendFeedback(line);
        }
        return content.size();
    }

    private static List<class_2561> tree(CommandNode<FabricClientCommandSource> root) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        List children = List.copyOf(root.getChildren());
        for (int i = 0; i < children.size(); ++i) {
            CommandNode child = (CommandNode)children.get(i);
            class_5250 childName = class_2561.method_43470((String)child.getUsageText()).method_27694(s -> s.method_10977(child.getCommand() != null ? class_124.field_1060 : class_124.field_1068));
            List<class_2561> childLines = UsageTreeCommand.tree((CommandNode<FabricClientCommandSource>)child);
            if (i + 1 < children.size()) {
                lines.add((class_2561)class_2561.method_43470((String)"\u251c\u2500 ").method_27694(s -> s.method_10977(class_124.field_1080)).method_10852((class_2561)childName));
                lines.addAll(childLines.stream().map(line -> class_2561.method_43470((String)"\u2502  ").method_27694(s -> s.method_10977(class_124.field_1080)).method_10852(line)).toList());
                continue;
            }
            lines.add((class_2561)class_2561.method_43470((String)"\u2514\u2500 ").method_27694(s -> s.method_10977(class_124.field_1080)).method_10852((class_2561)childName));
            lines.addAll(childLines.stream().map(line -> class_2561.method_43470((String)"   ").method_10852(line)).toList());
        }
        return lines;
    }
}

