/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.logging.LogUtils;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import dev.xpple.clientarguments.arguments.CBlockPosArgument;
import dev.xpple.clientarguments.arguments.CDimensionArgument;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.earthcomputer.clientcommands.ClientCommands;
import net.earthcomputer.clientcommands.render.RenderQueue;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.rendering.v1.HudLayerRegistrationCallback;
import net.fabricmc.fabric.api.client.rendering.v1.IdentifiedLayer;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1041;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_155;
import net.minecraft.class_156;
import net.minecraft.class_1937;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5250;
import net.minecraft.class_5321;
import net.minecraft.class_5348;
import net.minecraft.class_631;
import net.minecraft.class_757;
import net.minecraft.class_9779;
import net.minecraft.class_9974;
import org.jetbrains.annotations.VisibleForTesting;
import org.joml.Quaternionfc;
import org.joml.Vector2d;
import org.joml.Vector2dc;
import org.slf4j.Logger;

public class WaypointCommand {
    private static final class_2960 HUD_LAYER_ID = class_2960.method_60655((String)"clientcommands", (String)"waypoints");
    private static final Map<String, Map<String, WaypointLocation>> waypoints = new HashMap<String, Map<String, WaypointLocation>>();
    private static final Logger LOGGER = LogUtils.getLogger();
    private static final SimpleCommandExceptionType SAVE_FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.cwaypoint.saveFailed"));
    private static final DynamicCommandExceptionType ALREADY_EXISTS_EXCEPTION = new DynamicCommandExceptionType(name -> class_2561.method_43469((String)"commands.cwaypoint.alreadyExists", (Object[])new Object[]{name}));
    private static final DynamicCommandExceptionType NOT_FOUND_EXCEPTION = new DynamicCommandExceptionType(name -> class_2561.method_43469((String)"commands.cwaypoint.notFound", (Object[])new Object[]{name}));

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cwaypoint").then(ClientCommandManager.literal((String)"add").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.word()).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"pos", (ArgumentType)CBlockPosArgument.blockPos()).executes(ctx -> WaypointCommand.add((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), CBlockPosArgument.getBlockPos((CommandContext)ctx, (String)"pos")))).then(ClientCommandManager.argument((String)"dimension", (ArgumentType)CDimensionArgument.dimension()).executes(ctx -> WaypointCommand.add((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), CBlockPosArgument.getBlockPos((CommandContext)ctx, (String)"pos"), (class_5321<class_1937>)CDimensionArgument.getDimension((CommandContext)ctx, (String)"dimension")))))))).then(ClientCommandManager.literal((String)"remove").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            Map<String, WaypointLocation> worldWaypoints = waypoints.get(WaypointCommand.getWorldIdentifier(((FabricClientCommandSource)ctx.getSource()).getClient()));
            return class_2172.method_9265(worldWaypoints != null ? worldWaypoints.keySet() : Collections.emptySet(), (SuggestionsBuilder)builder);
        }).executes(ctx -> WaypointCommand.remove((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name")))))).then(ClientCommandManager.literal((String)"edit").then(ClientCommandManager.argument((String)"name", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> {
            Map<String, WaypointLocation> worldWaypoints = waypoints.get(WaypointCommand.getWorldIdentifier(((FabricClientCommandSource)ctx.getSource()).getClient()));
            return class_2172.method_9265(worldWaypoints != null ? worldWaypoints.keySet() : Collections.emptySet(), (SuggestionsBuilder)builder);
        }).then(((RequiredArgumentBuilder)ClientCommandManager.argument((String)"pos", (ArgumentType)CBlockPosArgument.blockPos()).executes(ctx -> WaypointCommand.edit((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), CBlockPosArgument.getBlockPos((CommandContext)ctx, (String)"pos")))).then(ClientCommandManager.argument((String)"dimension", (ArgumentType)CDimensionArgument.dimension()).executes(ctx -> WaypointCommand.edit((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"name"), CBlockPosArgument.getBlockPos((CommandContext)ctx, (String)"pos"), (class_5321<class_1937>)CDimensionArgument.getDimension((CommandContext)ctx, (String)"dimension")))))))).then(((LiteralArgumentBuilder)ClientCommandManager.literal((String)"list").executes(ctx -> WaypointCommand.list((FabricClientCommandSource)ctx.getSource()))).then(ClientCommandManager.argument((String)"current", (ArgumentType)BoolArgumentType.bool()).executes(ctx -> WaypointCommand.list((FabricClientCommandSource)ctx.getSource(), BoolArgumentType.getBool((CommandContext)ctx, (String)"current"))))));
    }

    private static String getWorldIdentifier(class_310 minecraft) {
        String worldIdentifier = minecraft.method_1496() ? minecraft.method_1576().field_23784.method_27005() : minecraft.method_1562().method_48296().method_10755().toString();
        return worldIdentifier;
    }

    private static int add(FabricClientCommandSource source, String name, class_2338 pos) throws CommandSyntaxException {
        return WaypointCommand.add(source, name, pos, (class_5321<class_1937>)source.getWorld().method_27983());
    }

    private static int add(FabricClientCommandSource source, String name, class_2338 pos, class_5321<class_1937> dimension) throws CommandSyntaxException {
        String worldIdentifier = WaypointCommand.getWorldIdentifier(source.getClient());
        Map worldWaypoints = waypoints.computeIfAbsent(worldIdentifier, key -> new HashMap());
        if (worldWaypoints.putIfAbsent(name, new WaypointLocation(dimension, pos)) != null) {
            throw ALREADY_EXISTS_EXCEPTION.create((Object)name);
        }
        WaypointCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cwaypoint.add.success", (Object[])new Object[]{name, WaypointCommand.formatCoordinates(pos), dimension.method_29177()}));
        return 1;
    }

    private static int remove(FabricClientCommandSource source, String name) throws CommandSyntaxException {
        String worldIdentifier = WaypointCommand.getWorldIdentifier(source.getClient());
        Map<String, WaypointLocation> worldWaypoints = waypoints.get(worldIdentifier);
        if (worldWaypoints == null) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        if (worldWaypoints.remove(name) == null) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        WaypointCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cwaypoint.remove.success", (Object[])new Object[]{name}));
        return 1;
    }

    private static int edit(FabricClientCommandSource source, String name, class_2338 pos) throws CommandSyntaxException {
        return WaypointCommand.edit(source, name, pos, (class_5321<class_1937>)source.getWorld().method_27983());
    }

    private static int edit(FabricClientCommandSource source, String name, class_2338 pos, class_5321<class_1937> dimension) throws CommandSyntaxException {
        String worldIdentifier = WaypointCommand.getWorldIdentifier(source.getClient());
        Map<String, WaypointLocation> worldWaypoints = waypoints.get(worldIdentifier);
        if (worldWaypoints == null) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        if (worldWaypoints.computeIfPresent(name, (key, value) -> new WaypointLocation(dimension, pos)) == null) {
            throw NOT_FOUND_EXCEPTION.create((Object)name);
        }
        WaypointCommand.saveFile();
        source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cwaypoint.edit.success", (Object[])new Object[]{name, WaypointCommand.formatCoordinates(pos), dimension.method_29177()}));
        return 1;
    }

    private static int list(FabricClientCommandSource source) {
        return WaypointCommand.list(source, false);
    }

    private static int list(FabricClientCommandSource source, boolean current) {
        if (current) {
            String worldIdentifier2 = WaypointCommand.getWorldIdentifier(source.getClient());
            Map<String, WaypointLocation> worldWaypoints2 = waypoints.get(worldIdentifier2);
            if (worldWaypoints2 == null || worldWaypoints2.isEmpty()) {
                source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.cwaypoint.list.empty"));
                return 0;
            }
            worldWaypoints2.forEach((name, waypoint) -> source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cwaypoint.list", (Object[])new Object[]{name, WaypointCommand.formatCoordinates(waypoint.location()), waypoint.dimension().method_29177()})));
            return worldWaypoints2.size();
        }
        if (waypoints.isEmpty()) {
            source.sendFeedback((class_2561)class_2561.method_43471((String)"commands.cwaypoint.list.empty"));
            return 0;
        }
        int[] count = new int[]{0};
        waypoints.forEach((worldIdentifier, worldWaypoints) -> {
            if (worldWaypoints.isEmpty()) {
                return;
            }
            count[0] = count[0] + worldWaypoints.size();
            source.sendFeedback((class_2561)class_2561.method_43470((String)worldIdentifier).method_27693(":"));
            worldWaypoints.forEach((name, waypoint) -> source.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cwaypoint.list", (Object[])new Object[]{name, WaypointCommand.formatCoordinates(waypoint.location()), waypoint.dimension().method_29177()})));
        });
        return count[0];
    }

    private static void saveFile() throws CommandSyntaxException {
        try {
            class_2487 rootTag = new class_2487();
            rootTag.method_10569("DataVersion", class_155.method_16673().method_37912().method_38494());
            class_2487 compoundTag = new class_2487();
            waypoints.forEach((worldIdentifier, worldWaypoints) -> compoundTag.method_10566(worldIdentifier, (class_2520)worldWaypoints.entrySet().stream().collect(class_2487::new, (result, entry) -> {
                class_2487 waypoint = new class_2487();
                waypoint.method_67494("pos", class_2338.field_25064, (Object)((WaypointLocation)entry.getValue()).location());
                String dimension = ((WaypointLocation)entry.getValue()).dimension().method_29177().toString();
                waypoint.method_10582("Dimension", dimension);
                result.method_10566((String)entry.getKey(), (class_2520)waypoint);
            }, class_2487::method_10543)));
            rootTag.method_10566("Waypoints", (class_2520)compoundTag);
            Path newFile = Files.createTempFile(ClientCommands.CONFIG_DIR, "waypoints", ".dat", new FileAttribute[0]);
            class_2507.method_10630((class_2487)rootTag, (Path)newFile);
            Path backupFile = ClientCommands.CONFIG_DIR.resolve("waypoints.dat_old");
            Path currentFile = ClientCommands.CONFIG_DIR.resolve("waypoints.dat");
            class_156.method_30626((Path)currentFile, (Path)newFile, (Path)backupFile);
        }
        catch (IOException e) {
            throw SAVE_FAILED_EXCEPTION.create();
        }
    }

    private static void loadFile() throws Exception {
        waypoints.clear();
        class_2487 rootTag = class_2507.method_10633((Path)ClientCommands.CONFIG_DIR.resolve("waypoints.dat"));
        if (rootTag == null) {
            return;
        }
        waypoints.putAll(WaypointCommand.deserializeWaypoints(rootTag));
    }

    @VisibleForTesting
    public static Map<String, Map<String, WaypointLocation>> deserializeWaypoints(class_2487 rootTag) {
        HashMap<String, Map<String, WaypointLocation>> waypoints = new HashMap<String, Map<String, WaypointLocation>>();
        class_2487 compoundTag = rootTag.method_68568("Waypoints");
        compoundTag.method_10541().forEach(worldIdentifier -> {
            class_2487 worldWaypoints = compoundTag.method_68568(worldIdentifier);
            waypoints.put((String)worldIdentifier, worldWaypoints.method_10541().stream().collect(Collectors.toMap(Function.identity(), name -> {
                class_2487 waypoint = worldWaypoints.method_68568(name);
                class_2338 pos = (class_2338)waypoint.method_67491("pos", class_2338.field_25064).orElseThrow();
                class_5321 dimension = (class_5321)class_1937.field_25178.parse(new Dynamic((DynamicOps)class_2509.field_11560, (Object)waypoint.method_10580("Dimension"))).resultOrPartial(arg_0 -> ((Logger)LOGGER).error(arg_0)).orElseThrow();
                return new WaypointLocation((class_5321<class_1937>)dimension, pos);
            })));
        });
        return waypoints;
    }

    private static class_2561 formatCoordinates(class_2338 waypoint) {
        return class_2564.method_10885((class_2561)class_2561.method_43470((String)waypoint.method_23854())).method_27694(style -> style.method_10977(class_124.field_1060).method_10958((class_2558)new class_2558.class_10606(waypoint.method_10263() + " " + waypoint.method_10264() + " " + waypoint.method_10260())).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"chat.copy.click"))));
    }

    public static void registerEvents() {
        HudLayerRegistrationCallback.EVENT.register(drawerWrapper -> drawerWrapper.addLayer(IdentifiedLayer.of((class_2960)HUD_LAYER_ID, WaypointCommand::renderWaypointLabels)));
        WorldRenderEvents.AFTER_ENTITIES.register(WaypointCommand::renderWaypointBoxes);
    }

    private static void renderWaypointLabels(class_332 guiGraphics, class_9779 deltaTracker) {
        int line;
        String worldIdentifier = WaypointCommand.getWorldIdentifier(class_310.method_1551());
        Map<String, WaypointLocation> waypoints = WaypointCommand.waypoints.get(worldIdentifier);
        if (waypoints == null) {
            return;
        }
        class_310 minecraft = class_310.method_1551();
        class_757 gameRenderer = minecraft.field_1773;
        class_4184 camera = gameRenderer.method_19418();
        class_1297 cameraEntity = camera.method_19331();
        float partialTicks = deltaTracker.method_60637(true);
        double verticalFovRad = Math.toRadians(gameRenderer.method_3196(camera, partialTicks, false));
        class_1041 window = minecraft.method_22683();
        double aspectRatio = (double)window.method_4486() / (double)window.method_4502();
        double horizontalFovRad = 2.0 * Math.atan(Math.tan(verticalFovRad / 2.0) * aspectRatio);
        class_243 viewVector3 = cameraEntity.method_5828(1.0f);
        Vector2d viewVector = new Vector2d(viewVector3.field_1352, viewVector3.field_1350);
        Vector2d position = new Vector2d(cameraEntity.method_33571().field_1352, cameraEntity.method_33571().field_1350);
        ArrayList<WaypointLabelLocation> xPositions = new ArrayList<WaypointLabelLocation>();
        waypoints.forEach((waypointName, waypoint) -> {
            int x;
            if (!waypoint.dimension().method_29177().equals((Object)minecraft.field_1687.method_27983().method_29177())) {
                return;
            }
            double distanceSquared = waypoint.location().method_19770((class_2374)cameraEntity.method_19538());
            long distance = Math.round(Math.sqrt(distanceSquared));
            class_5250 label = class_2564.method_10885((class_2561)class_2561.method_43470((String)(waypointName + " " + distance)).method_27692(class_124.field_1054));
            Vector2d waypointLocation = new Vector2d((double)waypoint.location().method_10263(), (double)waypoint.location().method_10260());
            double angleRad = viewVector.angle((Vector2dc)waypointLocation.sub((Vector2dc)position, new Vector2d()));
            boolean right = angleRad > 0.0;
            if ((angleRad = Math.abs(angleRad)) > horizontalFovRad / 2.0) {
                int width = minecraft.field_1772.method_27525((class_5348)label);
                x = right ? guiGraphics.method_51421() - width / 2 : width / 2;
            } else {
                double mv = Math.tan(angleRad) * (double)0.05f;
                double av = Math.tan(horizontalFovRad / 2.0) * (double)0.05f;
                double ab = 2.0 * av;
                double am = right ? mv + av : ab - (mv + av);
                double perc = am / ab;
                x = (int)(perc * (double)guiGraphics.method_51421());
            }
            xPositions.add(new WaypointLabelLocation((class_2561)label, x));
        });
        xPositions.sort(Comparator.comparingInt(WaypointLabelLocation::location));
        ArrayList positions = new ArrayList();
        positions.add(xPositions);
        for (line = 0; line < positions.size(); ++line) {
            List waypointLabelLocations = (List)positions.get(line);
            int i = 0;
            while (i < waypointLabelLocations.size() - 1) {
                int rightWidth;
                WaypointLabelLocation left = (WaypointLabelLocation)waypointLabelLocations.get(i);
                WaypointLabelLocation right = (WaypointLabelLocation)waypointLabelLocations.get(i + 1);
                int leftX = left.location();
                int rightX = right.location();
                int leftWidth = minecraft.field_1772.method_27525((class_5348)left.label());
                if (leftWidth / 2 + (rightWidth = minecraft.field_1772.method_27525((class_5348)right.label())) / 2 > rightX - leftX) {
                    if (line + 1 == positions.size()) {
                        positions.add(new ArrayList());
                    }
                    List nextLevel = (List)positions.get(line + 1);
                    WaypointLabelLocation removed = (WaypointLabelLocation)waypointLabelLocations.remove(i + 1);
                    nextLevel.add(removed);
                    continue;
                }
                ++i;
            }
        }
        for (line = 0; line < positions.size(); ++line) {
            List w = (List)positions.get(line);
            for (WaypointLabelLocation waypoint2 : w) {
                class_327 class_3272 = minecraft.field_1772;
                class_2561 class_25612 = waypoint2.label();
                int n = waypoint2.location();
                Objects.requireNonNull(minecraft.field_1772);
                guiGraphics.method_27534(class_3272, class_25612, n, 1 + line * 9, 0xFFFFFF);
            }
        }
    }

    private static void renderWaypointBoxes(WorldRenderContext context) {
        String worldIdentifier = WaypointCommand.getWorldIdentifier(class_310.method_1551());
        Map<String, WaypointLocation> waypoints = WaypointCommand.waypoints.get(worldIdentifier);
        if (waypoints == null) {
            return;
        }
        class_631 chunkSource = context.world().method_2935();
        waypoints.forEach((waypointName, waypoint) -> {
            if (!waypoint.dimension().method_29177().equals((Object)context.world().method_27983().method_29177())) {
                return;
            }
            class_2338 waypointLocation = waypoint.location();
            if (!chunkSource.method_12123(waypointLocation.method_10263() >> 4, waypointLocation.method_10260() >> 4)) {
                return;
            }
            class_243 cameraPosition = context.camera().method_19326();
            float distance = (float)waypointLocation.method_19770((class_2374)cameraPosition);
            distance = (float)Math.sqrt(distance) / 6.0f;
            class_4587 stack = context.matrixStack();
            stack.method_22903();
            stack.method_61958(cameraPosition.method_1021(-1.0));
            class_238 box = new class_238(waypointLocation);
            class_9974.method_62295((class_4587)stack, (class_4588)context.consumers().getBuffer(RenderQueue.LINES_NO_DEPTH_LAYER), (class_238)box, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            stack.method_61958(waypointLocation.method_46558().method_1019(new class_243(0.0, 1.0, 0.0)));
            stack.method_22907((Quaternionfc)context.camera().method_23767());
            stack.method_22905(0.025f * distance, -0.025f * distance, 0.025f * distance);
            class_327 font = class_310.method_1551().field_1772;
            int width = font.method_1727(waypointName) / 2;
            int backgroundColour = (int)(class_310.method_1551().field_1690.method_19343(0.25f) * 255.0f) << 24;
            font.method_27521(waypointName, (float)(-width), 0.0f, 0xFFFFFF, false, stack.method_23760().method_23761(), context.consumers(), class_327.class_6415.field_33994, backgroundColour, 0xF00000);
            stack.method_22909();
        });
    }

    static {
        try {
            WaypointCommand.loadFile();
        }
        catch (Exception e) {
            LOGGER.error("Could not load waypoints file, hence /cwaypoint will not work!", (Throwable)e);
        }
    }

    @VisibleForTesting
    public record WaypointLocation(class_5321<class_1937> dimension, class_2338 location) {
    }

    record WaypointLabelLocation(class_2561 label, int location) {
    }
}

