/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command.arguments;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Either;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Predicate;
import net.earthcomputer.clientcommands.command.arguments.ListArgument;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1922;
import net.minecraft.class_2248;
import net.minecraft.class_2259;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_6885;
import net.minecraft.class_7157;
import net.minecraft.class_7225;
import net.minecraft.class_7924;
import org.apache.commons.lang3.tuple.Pair;

public class ClientBlockPredicateArgument
implements ArgumentType<ParseResult> {
    private final class_7225<class_2248> holderLookup;
    private boolean allowNbt = true;
    private boolean allowTags = true;

    private ClientBlockPredicateArgument(class_7157 context) {
        this.holderLookup = context.method_46762(class_7924.field_41254);
    }

    public static ClientBlockPredicateArgument blockPredicate(class_7157 context) {
        return new ClientBlockPredicateArgument(context);
    }

    public ClientBlockPredicateArgument disallowNbt() {
        this.allowNbt = false;
        return this;
    }

    public ClientBlockPredicateArgument disallowTags() {
        this.allowTags = false;
        return this;
    }

    public ParseResult parse(StringReader stringReader) throws CommandSyntaxException {
        Either result = class_2259.method_41960(this.holderLookup, (StringReader)stringReader, (boolean)this.allowNbt);
        return new ParseResult((Either<class_2259.class_7211, class_2259.class_7212>)result, this.holderLookup);
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        return class_2259.method_9666(this.holderLookup, (SuggestionsBuilder)builder, (boolean)this.allowTags, (boolean)this.allowNbt);
    }

    public static ClientBlockPredicate getBlockPredicate(CommandContext<FabricClientCommandSource> context, String arg) throws CommandSyntaxException {
        return ClientBlockPredicateArgument.getBlockPredicate((ParseResult)context.getArgument(arg, ParseResult.class));
    }

    public static ClientBlockPredicate getBlockPredicate(ParseResult result) throws CommandSyntaxException {
        final Predicate<class_2680> predicate = ClientBlockPredicateArgument.getPredicateForListWithoutNbt(Collections.singletonList(result.result));
        final class_2487 nbtData = (class_2487)result.result.map(class_2259.class_7211::comp_624, class_2259.class_7212::comp_627);
        if (nbtData == null) {
            return ClientBlockPredicate.simple(predicate);
        }
        return new ClientBlockPredicate(){

            @Override
            public boolean test(class_7225.class_7874 holderLookupProvider, class_1922 blockGetter, class_2338 pos) {
                if (!predicate.test(blockGetter.method_8320(pos))) {
                    return false;
                }
                class_2586 be = blockGetter.method_8321(pos);
                return be != null && class_2512.method_10687((class_2520)nbtData, (class_2520)be.method_38244(holderLookupProvider), (boolean)true);
            }

            @Override
            public boolean canEverMatch(class_2680 state) {
                return predicate.test(state);
            }
        };
    }

    public static ClientBlockPredicate getBlockPredicateList(CommandContext<FabricClientCommandSource> context, String arg) throws CommandSyntaxException {
        List<ParseResult> results = ListArgument.getList(context, arg);
        final Predicate<class_2680> predicate = ClientBlockPredicateArgument.getPredicateForListWithoutNbt(results.stream().map(ParseResult::result).toList());
        final ArrayList<Object> nbtPredicates = new ArrayList<Object>(results.size());
        boolean nbtSensitive = false;
        for (ParseResult result : results) {
            class_2487 nbtData = (class_2487)result.result.map(class_2259.class_7211::comp_624, class_2259.class_7212::comp_627);
            if (nbtData != null) {
                nbtSensitive = true;
            }
            nbtPredicates.add(Pair.of(ClientBlockPredicateArgument.getPredicateWithoutNbt(result.result), (Object)nbtData));
        }
        if (!nbtSensitive) {
            return ClientBlockPredicate.simple(predicate);
        }
        nbtPredicates.sort(Map.Entry.comparingByValue(Comparator.nullsFirst(Comparator.comparingInt(System::identityHashCode))));
        return new ClientBlockPredicate(){

            @Override
            public boolean test(class_7225.class_7874 holderLookupProvider, class_1922 blockGetter, class_2338 pos) {
                class_2680 state = blockGetter.method_8320(pos);
                if (!predicate.test(state)) {
                    return false;
                }
                class_2487 actualNbt = null;
                for (Pair nbtPredicate : nbtPredicates) {
                    if (!((Predicate)nbtPredicate.getLeft()).test(state)) continue;
                    class_2487 nbt = (class_2487)nbtPredicate.getRight();
                    if (nbt == null) {
                        return true;
                    }
                    if (actualNbt == null) {
                        class_2586 be = blockGetter.method_8321(pos);
                        if (be == null) {
                            return false;
                        }
                        actualNbt = be.method_38244(holderLookupProvider);
                    }
                    if (!class_2512.method_10687((class_2520)nbt, actualNbt, (boolean)true)) continue;
                    return true;
                }
                return false;
            }

            @Override
            public boolean canEverMatch(class_2680 state) {
                return predicate.test(state);
            }
        };
    }

    private static Predicate<class_2680> getPredicateForListWithoutNbt(List<Either<class_2259.class_7211, class_2259.class_7212>> results) throws CommandSyntaxException {
        class_2680 state;
        ArrayList<Predicate<class_2680>> predicates = new ArrayList<Predicate<class_2680>>(results.size());
        for (Either<class_2259.class_7211, class_2259.class_7212> result : results) {
            predicates.add(ClientBlockPredicateArgument.getPredicateWithoutNbt(result));
        }
        BitSet mask = new BitSet();
        int id = 0;
        while ((state = (class_2680)class_2248.field_10651.method_10200(id)) != null) {
            for (Predicate predicate : predicates) {
                if (!predicate.test(state)) continue;
                mask.set(id);
                break;
            }
            ++id;
        }
        return blockState -> mask.get(class_2248.field_10651.method_10206(blockState));
    }

    private static Predicate<class_2680> getPredicateWithoutNbt(Either<class_2259.class_7211, class_2259.class_7212> result) throws CommandSyntaxException {
        return (Predicate)result.map(blockResult -> {
            Map props = blockResult.comp_623();
            return state -> {
                if (!state.method_27852(blockResult.comp_622().method_26204())) {
                    return false;
                }
                for (Map.Entry entry : props.entrySet()) {
                    if (state.method_11654((class_2769)entry.getKey()) == entry.getValue()) continue;
                    return false;
                }
                return true;
            };
        }, tagResult -> {
            class_6885 myTag = tagResult.comp_625();
            Map props = tagResult.comp_626();
            return state -> {
                if (!state.method_40143(myTag)) {
                    return false;
                }
                for (Map.Entry entry : props.entrySet()) {
                    class_2769 prop = state.method_26204().method_9595().method_11663((String)entry.getKey());
                    if (prop == null) {
                        return false;
                    }
                    Comparable expectedValue = prop.method_11900((String)entry.getValue()).orElse(null);
                    if (expectedValue == null) {
                        return false;
                    }
                    if (state.method_11654(prop) == expectedValue) continue;
                    return false;
                }
                return true;
            };
        });
    }

    public record ParseResult(Either<class_2259.class_7211, class_2259.class_7212> result, class_7225<class_2248> holderLookup) {
    }

    public static interface ClientBlockPredicate {
        public boolean test(class_7225.class_7874 var1, class_1922 var2, class_2338 var3) throws CommandSyntaxException;

        public boolean canEverMatch(class_2680 var1);

        public static ClientBlockPredicate simple(final Predicate<class_2680> delegate) {
            return new ClientBlockPredicate(){

                @Override
                public boolean test(class_7225.class_7874 holderLookupProvider, class_1922 blockGetter, class_2338 pos) {
                    return delegate.test(blockGetter.method_8320(pos));
                }

                @Override
                public boolean canEverMatch(class_2680 state) {
                    return delegate.test(state);
                }
            };
        }
    }
}

