/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command.arguments;

import com.google.common.collect.ImmutableMap;
import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.jetbrains.annotations.Nullable;

public class ExtendedMarkdownArgument
implements ArgumentType<class_5250> {
    private static final Collection<String> EXAMPLES = Arrays.asList("Earth", "bold{xpple}", "red{hello blue{world}!}", "*italic*");
    private static final SimpleCommandExceptionType TOO_DEEPLY_NESTED_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.client.componentTooDeeplyNested"));
    private static final DynamicCommandExceptionType INVALID_CLICK_ACTION_EXCEPTION = new DynamicCommandExceptionType(action -> class_2561.method_43469((String)"commands.client.invalidClickAction", (Object[])new Object[]{action}));
    private static final DynamicCommandExceptionType INVALID_HOVER_ACTION_EXCEPTION = new DynamicCommandExceptionType(action -> class_2561.method_43469((String)"commands.client.invalidHoverAction", (Object[])new Object[]{action}));
    private static final DynamicCommandExceptionType INVALID_HOVER_EVENT_EXCEPTION = new DynamicCommandExceptionType(event -> class_2561.method_43469((String)"commands.client.invalidHoverEvent", (Object[])new Object[]{event}));

    private ExtendedMarkdownArgument() {
    }

    public static ExtendedMarkdownArgument extendedMarkdown() {
        return new ExtendedMarkdownArgument();
    }

    public static class_5250 getExtendedMarkdown(CommandContext<FabricClientCommandSource> context, String arg) {
        return (class_5250)context.getArgument(arg, class_5250.class);
    }

    public class_5250 parse(StringReader reader) throws CommandSyntaxException {
        return new Parser(reader).parse();
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        Parser parser = new Parser(reader);
        try {
            parser.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (parser.suggestor != null) {
            parser.suggestor.accept(builder);
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    private static class Parser {
        private static final int MAX_NESTING = 50;
        private final StringReader reader;
        private Consumer<SuggestionsBuilder> suggestor;

        public Parser(StringReader reader) {
            this.reader = reader;
        }

        public class_5250 parse() throws CommandSyntaxException {
            return this.parse(this.reader.getTotalLength(), 0);
        }

        private class_5250 parse(int end, int depth) throws CommandSyntaxException {
            if (depth > 50) {
                throw TOO_DEEPLY_NESTED_EXCEPTION.createWithContext((ImmutableStringReader)this.reader);
            }
            StringBuilder plainText = new StringBuilder();
            ArrayList<class_5250> components = new ArrayList<class_5250>();
            while (this.reader.getCursor() < end) {
                int cursor = this.reader.getCursor();
                this.suggestor = builder -> {
                    SuggestionsBuilder newBuilder = builder.createOffset(cursor);
                    class_2172.method_9264(FormattedCode.CODES.keySet().stream().map(str -> str + "{"), (SuggestionsBuilder)newBuilder);
                    builder.add(newBuilder);
                };
                String word = this.readWordNotSurroundedByUnderscore();
                if (!word.isEmpty() && this.reader.canRead() && this.reader.peek() == '{') {
                    FormattedCode.Styler styler;
                    class_124 legacyFormatting;
                    this.reader.skip();
                    word = word.toLowerCase(Locale.ROOT);
                    if (word.length() == 1 && (legacyFormatting = class_124.method_544((char)word.charAt(0))) != null && legacyFormatting != class_124.field_1070) {
                        word = legacyFormatting.method_537().toLowerCase(Locale.ROOT);
                    }
                    if ((styler = FormattedCode.CODES.get(word)) != null) {
                        int innerStart = this.reader.getCursor();
                        int braceCount = 1;
                        while (braceCount > 0) {
                            int openIndex = this.findUnescaped('{', end);
                            int closeIndex = this.findUnescaped('}', end);
                            if (closeIndex == end) break;
                            if (openIndex < closeIndex) {
                                ++braceCount;
                                this.reader.setCursor(openIndex + 1);
                                continue;
                            }
                            --braceCount;
                            this.reader.setCursor(closeIndex + 1);
                        }
                        int innerEnd = braceCount == 0 ? this.reader.getCursor() - 1 : end;
                        this.reader.setCursor(innerStart);
                        ArrayList<String> arguments = new ArrayList<String>(styler.argumentCount());
                        if (styler.argumentCount() > 0) {
                            this.reader.skipWhitespace();
                            int argStart = this.reader.getCursor();
                            this.suggestor = builder -> {
                                SuggestionsBuilder newBuilder = builder.createOffset(argStart);
                                class_2172.method_9253((String[])styler.suggestions(), (SuggestionsBuilder)newBuilder);
                                builder.add(newBuilder);
                            };
                            arguments.add(this.readArgument());
                            this.reader.skipWhitespace();
                            this.reader.expect(',');
                            this.reader.skipWhitespace();
                            for (int i = 1; i < styler.argumentCount(); ++i) {
                                this.suggestor = SuggestionsBuilder::buildFuture;
                                arguments.add(this.readArgument());
                                this.reader.skipWhitespace();
                                this.reader.expect(',');
                                this.reader.skipWhitespace();
                            }
                        }
                        class_5250 innerComponent = this.parse(innerEnd, depth + 1);
                        this.reader.expect('}');
                        innerComponent.method_27696(styler.operator().apply(innerComponent.method_10866(), arguments));
                        if (!plainText.isEmpty()) {
                            components.add(class_2561.method_43470((String)plainText.toString()));
                            plainText.setLength(0);
                        }
                        components.add(innerComponent);
                        continue;
                    }
                }
                plainText.append(word);
                if (this.reader.getCursor() >= end) break;
                char ch = this.reader.read();
                switch (ch) {
                    case '~': {
                        if (this.reader.getCursor() < end && this.reader.peek() == '~') {
                            this.reader.skip();
                            class_5250 innerComponent = this.parse(this.findUnescaped("~~", end), depth + 1).method_27694(style -> style.method_36140(Boolean.valueOf(true)));
                            this.reader.expect('~');
                            this.reader.expect('~');
                            if (!plainText.isEmpty()) {
                                components.add(class_2561.method_43470((String)plainText.toString()));
                                plainText.setLength(0);
                            }
                            components.add(innerComponent);
                            break;
                        }
                        plainText.append('~');
                        break;
                    }
                    case '*': {
                        if (this.reader.getCursor() < end && this.reader.peek() == '*') {
                            this.reader.skip();
                            class_5250 innerComponent = this.parse(this.findUnescaped("**", end), depth + 1).method_27694(style -> style.method_10982(Boolean.valueOf(true)));
                            this.reader.expect('*');
                            this.reader.expect('*');
                            if (!plainText.isEmpty()) {
                                components.add(class_2561.method_43470((String)plainText.toString()));
                                plainText.setLength(0);
                            }
                            components.add(innerComponent);
                            break;
                        }
                        class_5250 innerComponent = this.parse(this.findUnescaped('*', end), depth + 1).method_27694(style -> style.method_10978(Boolean.valueOf(true)));
                        this.reader.expect('*');
                        if (!plainText.isEmpty()) {
                            components.add(class_2561.method_43470((String)plainText.toString()));
                            plainText.setLength(0);
                        }
                        components.add(innerComponent);
                        break;
                    }
                    case '_': {
                        if (this.reader.getCursor() < end && this.reader.peek() == '_') {
                            this.reader.skip();
                            class_5250 innerComponent = this.parse(this.findUnescaped("__", end), depth + 1).method_27694(style -> style.method_30938(Boolean.valueOf(true)));
                            this.reader.expect('_');
                            this.reader.expect('_');
                            if (!plainText.isEmpty()) {
                                components.add(class_2561.method_43470((String)plainText.toString()));
                                plainText.setLength(0);
                            }
                            components.add(innerComponent);
                            break;
                        }
                        class_5250 innerComponent = this.parse(this.findUnescaped('_', end), depth + 1).method_27694(style -> style.method_10978(Boolean.valueOf(true)));
                        this.reader.expect('_');
                        if (!plainText.isEmpty()) {
                            components.add(class_2561.method_43470((String)plainText.toString()));
                            plainText.setLength(0);
                        }
                        components.add(innerComponent);
                        break;
                    }
                    case '[': {
                        String linkHref;
                        class_5250 linkComponent = this.parse(this.findUnescaped(']', end), depth + 1);
                        this.reader.expect(']');
                        if (this.reader.getCursor() < end && this.reader.peek() == '(') {
                            this.reader.skip();
                            this.suggestor = SuggestionsBuilder::build;
                            int hrefEnd = this.reader.getString().indexOf(41, this.reader.getCursor(), end);
                            if (hrefEnd == -1) {
                                hrefEnd = end;
                            }
                            linkHref = this.reader.getString().substring(this.reader.getCursor(), hrefEnd).trim();
                            this.reader.setCursor(hrefEnd);
                            this.reader.expect(')');
                        } else {
                            linkHref = linkComponent.getString();
                        }
                        if (!plainText.isEmpty()) {
                            components.add(class_2561.method_43470((String)plainText.toString()));
                            plainText.setLength(0);
                        }
                        URI linkHrefUri = Parser.tryParseUri(linkHref);
                        components.add(linkComponent.method_27694(style -> {
                            if (linkHrefUri != null) {
                                style = style.method_10958((class_2558)new class_2558.class_10608(linkHrefUri));
                            }
                            return style.method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)linkHref))).method_10977(class_124.field_1078).method_30938(Boolean.valueOf(true));
                        }));
                        break;
                    }
                    case '\\': {
                        if (this.reader.getCursor() < end) {
                            String escapedWord = this.readWordNotSurroundedByUnderscore();
                            if (!escapedWord.isEmpty()) {
                                plainText.append(escapedWord);
                                break;
                            }
                            plainText.append(this.reader.read());
                            break;
                        }
                        plainText.append('\\');
                        break;
                    }
                    default: {
                        plainText.append(ch);
                    }
                }
            }
            if (!plainText.isEmpty()) {
                components.add(class_2561.method_43470((String)plainText.toString()));
            }
            return switch (components.size()) {
                case 0 -> class_2561.method_43473();
                case 1 -> (class_5250)components.getFirst();
                default -> {
                    if (((class_5250)components.getFirst()).method_10866().method_10967()) {
                        for (int i = 1; i < components.size(); ++i) {
                            ((class_5250)components.getFirst()).method_10852((class_2561)components.get(i));
                        }
                        yield (class_5250)components.getFirst();
                    }
                    class_5250 parent = class_2561.method_43473();
                    components.forEach(arg_0 -> ((class_5250)parent).method_10852(arg_0));
                    yield parent;
                }
            };
        }

        @Nullable
        private static URI tryParseUri(String uriStr) {
            try {
                return new URI(uriStr);
            }
            catch (URISyntaxException e) {
                return null;
            }
        }

        private boolean isEscaped(int index) {
            boolean isEscaped = false;
            for (int i = index - 1; i >= 0 && this.reader.getString().charAt(i) == '\\'; --i) {
                isEscaped = !isEscaped;
            }
            return isEscaped;
        }

        private int findUnescaped(char ch, int endIndex) {
            int index = this.reader.getString().indexOf(ch, this.reader.getCursor(), endIndex);
            while (index != -1 && this.isEscaped(index)) {
                index = this.reader.getString().indexOf(ch, index + 1, endIndex);
            }
            return index == -1 ? endIndex : index;
        }

        private int findUnescaped(String str, int endIndex) {
            int index = this.reader.getString().indexOf(str, this.reader.getCursor(), endIndex);
            while (index != -1 && this.isEscaped(index)) {
                index = this.reader.getString().indexOf(str, index + 1, endIndex);
            }
            return index;
        }

        private String readArgument() {
            int start = this.reader.getCursor();
            while (this.reader.canRead() && Parser.isAllowedInArgument(this.reader.peek())) {
                this.reader.skip();
            }
            return this.reader.getString().substring(start, this.reader.getCursor());
        }

        private static boolean isAllowedInArgument(char c) {
            return c != ',' && c != '{' && c != '}';
        }

        private String readWordNotSurroundedByUnderscore() {
            int start = this.reader.getCursor();
            String word = this.reader.readUnquotedString();
            if (word.startsWith("_")) {
                this.reader.setCursor(start);
                return "";
            }
            while (word.endsWith("_")) {
                word = word.substring(0, word.length() - 1);
                this.reader.setCursor(this.reader.getCursor() - 1);
            }
            return word;
        }
    }

    private static class FormattedCode {
        private static final Map<String, Styler> CODES = ImmutableMap.builder().put((Object)"aqua", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1075), 0, new String[0])).put((Object)"black", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1074), 0, new String[0])).put((Object)"blue", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1078), 0, new String[0])).put((Object)"bold", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1067), 0, new String[0])).put((Object)"dark_aqua", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1062), 0, new String[0])).put((Object)"dark_blue", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1058), 0, new String[0])).put((Object)"dark_gray", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1063), 0, new String[0])).put((Object)"dark_green", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1077), 0, new String[0])).put((Object)"dark_purple", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1064), 0, new String[0])).put((Object)"dark_red", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1079), 0, new String[0])).put((Object)"gold", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1065), 0, new String[0])).put((Object)"gray", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1080), 0, new String[0])).put((Object)"green", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1060), 0, new String[0])).put((Object)"italic", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1056), 0, new String[0])).put((Object)"light_purple", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1076), 0, new String[0])).put((Object)"obfuscated", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1051), 0, new String[0])).put((Object)"red", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1061), 0, new String[0])).put((Object)"strikethrough", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1055), 0, new String[0])).put((Object)"underline", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1073), 0, new String[0])).put((Object)"white", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1068), 0, new String[0])).put((Object)"yellow", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1054), 0, new String[0])).put((Object)"font", (Object)new Styler((s, o) -> s.method_27704(class_2960.method_12835((StringReader)new StringReader((String)o.getFirst()))), 1, "alt", "default")).put((Object)"hex", (Object)new Styler((s, o) -> s.method_27703(class_5251.method_27717((int)FormattedCode.parseHex((String)o.getFirst()))), 1, new String[0])).put((Object)"insert", (Object)new Styler((s, o) -> s.method_10975((String)o.getFirst()), 1, new String[0])).put((Object)"strike", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1055), 0, new String[0])).put((Object)"magic", (Object)new Styler((s, o) -> s.method_27706(class_124.field_1051), 0, new String[0])).build();
        private final StylerFunc styler;
        private final class_5250 argument;
        private final List<String> args;

        public FormattedCode(StylerFunc styler, class_5250 argument, List<String> args) {
            this.styler = styler;
            this.argument = argument;
            this.args = args;
        }

        public class_5250 style() throws CommandSyntaxException {
            return this.argument.method_10862(this.styler.apply(this.argument.method_10866(), this.args));
        }

        private static int parseHex(String hex) throws CommandSyntaxException {
            try {
                return Integer.parseInt(hex, 16);
            }
            catch (NumberFormatException e) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().create((Object)hex);
            }
        }

        @FunctionalInterface
        static interface StylerFunc {
            public class_2583 apply(class_2583 var1, List<String> var2) throws CommandSyntaxException;
        }

        private record Styler(StylerFunc operator, int argumentCount, String[] suggestions) {
        }
    }
}

