/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.features;

import com.demonwav.mcdev.annotations.Translatable;
import com.google.common.cache.CacheBuilder;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.xpple.clientarguments.arguments.CGameProfileArgument;
import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Stream;
import net.earthcomputer.clientcommands.c2c.C2CPacketHandler;
import net.earthcomputer.clientcommands.c2c.packets.StartTwoPlayerGameC2CPacket;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.earthcomputer.clientcommands.command.ConnectFourCommand;
import net.earthcomputer.clientcommands.command.TicTacToeCommand;
import net.earthcomputer.clientcommands.event.ClientConnectionEvents;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_124;
import net.minecraft.class_2172;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_634;
import net.minecraft.class_640;
import org.jetbrains.annotations.Nullable;

public class TwoPlayerGame<T, S extends class_437> {
    public static final Map<class_2960, TwoPlayerGame<?, ?>> TYPE_BY_NAME = new LinkedHashMap();
    private static final SimpleCommandExceptionType PLAYER_NOT_FOUND_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"twoPlayerGame.playerNotFound"));
    private static final SimpleCommandExceptionType NO_GAME_WITH_PLAYER_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"twoPlayerGame.noGameWithPlayer"));
    public static final TwoPlayerGame<TicTacToeCommand.TicTacToeGame, TicTacToeCommand.TicTacToeGameScreen> TIC_TAC_TOE_GAME_TYPE = TwoPlayerGame.register(new TwoPlayerGame<TicTacToeCommand.TicTacToeGame, TicTacToeCommand.TicTacToeGameScreen>("commands.ctictactoe.name", "ctictactoe", class_2960.method_60655((String)"clientcommands", (String)"tictactoe"), (opponent, firstPlayer) -> new TicTacToeCommand.TicTacToeGame(opponent, firstPlayer ? TicTacToeCommand.TicTacToeGame.Mark.CROSS : TicTacToeCommand.TicTacToeGame.Mark.NOUGHT), TicTacToeCommand.TicTacToeGameScreen::new));
    public static final TwoPlayerGame<ConnectFourCommand.ConnectFourGame, ConnectFourCommand.ConnectFourGameScreen> CONNECT_FOUR_GAME_TYPE = TwoPlayerGame.register(new TwoPlayerGame<ConnectFourCommand.ConnectFourGame, ConnectFourCommand.ConnectFourGameScreen>("commands.cconnectfour.name", "cconnectfour", class_2960.method_60655((String)"clientcommands", (String)"connectfour"), (opponent, firstPlayer) -> new ConnectFourCommand.ConnectFourGame(opponent, firstPlayer ? ConnectFourCommand.Piece.RED : ConnectFourCommand.Piece.YELLOW), ConnectFourCommand.ConnectFourGameScreen::new));
    private final class_2561 translation;
    private final String command;
    private final class_2960 id;
    private final Set<UUID> pendingInvites;
    private final Map<UUID, T> activeGames;
    private final GameFactory<T> gameFactory;
    private final ScreenFactory<T, S> screenFactory;

    TwoPlayerGame(@Translatable String translationKey, String command, class_2960 id, GameFactory<T> gameFactory, ScreenFactory<T, S> screenFactory) {
        this.translation = class_2561.method_43471((String)translationKey);
        this.command = command;
        this.id = id;
        this.pendingInvites = Collections.newSetFromMap(CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(5L)).build().asMap());
        this.activeGames = CacheBuilder.newBuilder().expireAfterWrite(Duration.ofMinutes(15L)).build().asMap();
        this.gameFactory = gameFactory;
        this.screenFactory = screenFactory;
    }

    private static <T, S extends class_437> TwoPlayerGame<T, S> register(TwoPlayerGame<T, S> instance) {
        TYPE_BY_NAME.put(instance.id, instance);
        return instance;
    }

    @Nullable
    public static TwoPlayerGame<?, ?> getById(class_2960 id) {
        return TYPE_BY_NAME.get(id);
    }

    public static void onPlayerLeave(UUID opponentUUID) {
        for (TwoPlayerGame<?, ?> game : TYPE_BY_NAME.values()) {
            game.activeGames.remove(opponentUUID);
            game.pendingInvites.remove(opponentUUID);
        }
    }

    public class_2561 translate() {
        return this.translation;
    }

    public class_2960 getId() {
        return this.id;
    }

    public Set<UUID> getPendingInvites() {
        return this.pendingInvites;
    }

    public Map<UUID, T> getActiveGames() {
        return this.activeGames;
    }

    @Nullable
    public T getActiveGame(UUID opponent) {
        return this.activeGames.get(opponent);
    }

    public void removeActiveGame(UUID opponent) {
        this.activeGames.remove(opponent);
    }

    public void addNewGame(class_640 opponent, boolean isFirstPlayer) {
        this.activeGames.put(opponent.method_2966().getId(), this.gameFactory.create(opponent, isFirstPlayer));
    }

    public LiteralArgumentBuilder<FabricClientCommandSource> createCommandTree() {
        class_310 mc = class_310.method_1551();
        class_634 connection = mc.method_1562();
        assert (connection != null);
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)ClientCommandManager.literal((String)this.command).then(ClientCommandManager.literal((String)"start").then(ClientCommandManager.argument((String)"opponent", (ArgumentType)CGameProfileArgument.gameProfile((boolean)true)).executes(ctx -> this.start((FabricClientCommandSource)ctx.getSource(), CGameProfileArgument.getSingleProfileArgument((CommandContext)ctx, (String)"opponent")))))).then(ClientCommandManager.literal((String)"open").then(ClientCommandManager.argument((String)"opponent", (ArgumentType)StringArgumentType.word()).suggests((ctx, builder) -> class_2172.method_9264(this.getActiveGames().keySet().stream().flatMap(uuid -> Stream.ofNullable(connection.method_2871(uuid))).map(info -> info.method_2966().getName()), (SuggestionsBuilder)builder)).executes(ctx -> this.open((FabricClientCommandSource)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"opponent")))));
    }

    public int start(FabricClientCommandSource source, GameProfile player) throws CommandSyntaxException {
        class_640 recipient = source.getClient().method_1562().method_2871(player.getId());
        if (recipient == null) {
            throw PLAYER_NOT_FOUND_EXCEPTION.create();
        }
        StartTwoPlayerGameC2CPacket packet = new StartTwoPlayerGameC2CPacket(player.getName(), player.getId(), false, this);
        C2CPacketHandler.getInstance().sendPacket(packet, recipient);
        this.pendingInvites.add(player.getId());
        this.activeGames.remove(player.getId());
        source.sendFeedback((class_2561)class_2561.method_43469((String)"c2cpacket.startTwoPlayerGameC2CPacket.outgoing.invited", (Object[])new Object[]{player.getName(), this.translate()}));
        return 1;
    }

    public int open(FabricClientCommandSource source, String name) throws CommandSyntaxException {
        class_640 opponent = source.getClient().method_1562().method_2874(name);
        if (opponent == null) {
            throw PLAYER_NOT_FOUND_EXCEPTION.create();
        }
        if (!this.openGame(opponent.method_2966().getId())) {
            throw NO_GAME_WITH_PLAYER_EXCEPTION.create();
        }
        return 1;
    }

    private boolean openGame(UUID opponentUuid) {
        class_310 mc = class_310.method_1551();
        T game = this.activeGames.get(opponentUuid);
        if (game != null) {
            mc.method_63588(() -> mc.method_1507(this.screenFactory.createScreen(game)));
            return true;
        }
        return false;
    }

    public static void onStartTwoPlayerGame(StartTwoPlayerGameC2CPacket packet) {
        class_310 mc = class_310.method_1551();
        String sender = packet.sender();
        TwoPlayerGame<?, ?> game = packet.game();
        class_640 opponent = class_310.method_1551().method_1562().method_2874(sender);
        if (opponent == null) {
            return;
        }
        if (packet.accept() && game.getPendingInvites().remove(opponent.method_2966().getId())) {
            packet.game().addNewGame(opponent, true);
            class_5250 clickable = class_2561.method_43471((String)"twoPlayerGame.clickToMakeYourMove");
            clickable.method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10977(class_124.field_1060).method_10958((class_2558)new class_2558.class_10609("/" + game.command + " open " + sender)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("/" + game.command + " open " + sender)))));
            ClientCommandHelper.sendFeedback((class_2561)class_2561.method_43469((String)"c2cpacket.startTwoPlayerGameC2CPacket.incoming.accepted", (Object[])new Object[]{sender, game.translate()}).method_27693(" [").method_10852((class_2561)clickable).method_27693("]"));
        } else {
            game.getActiveGames().remove(opponent.method_2966().getId());
            class_5250 clickable = class_2561.method_43471((String)"c2cpacket.startTwoPlayerGameC2CPacket.incoming.accept").method_27694(style -> style.method_30938(Boolean.valueOf(true)).method_10977(class_124.field_1060).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43471((String)"c2cpacket.startTwoPlayerGameC2CPacket.incoming.accept.hover"))).method_10958(ClientCommandHelper.callbackClickEvent(() -> {
                if (!game.openGame(opponent.method_2966().getId())) {
                    game.addNewGame(opponent, false);
                    StartTwoPlayerGameC2CPacket acceptPacket = new StartTwoPlayerGameC2CPacket(mc.method_53462().getName(), mc.method_53462().getId(), true, game);
                    try {
                        C2CPacketHandler.getInstance().sendPacket(acceptPacket, opponent);
                    }
                    catch (CommandSyntaxException e) {
                        ClientCommandHelper.sendFeedback(class_2561.method_54155((Message)e.getRawMessage()));
                    }
                    ClientCommandHelper.sendFeedback("c2cpacket.startTwoPlayerGameC2CPacket.outgoing.accept", new Object[0]);
                }
            })));
            ClientCommandHelper.sendFeedback((class_2561)class_2561.method_43469((String)"c2cpacket.startTwoPlayerGameC2CPacket.incoming", (Object[])new Object[]{sender, game.translate()}).method_27693(" [").method_10852((class_2561)clickable).method_27693("]"));
        }
    }

    public void onWon(String sender, UUID senderUUID) {
        ClientCommandHelper.sendFeedback("twoPlayerGame.chat.won", this.translate(), sender);
        this.removeActiveGame(senderUUID);
    }

    public void onDraw(String sender, UUID senderUUID) {
        ClientCommandHelper.sendFeedback("twoPlayerGame.chat.draw", this.translate(), sender);
        this.removeActiveGame(senderUUID);
    }

    public void onLost(String sender, UUID senderUUID) {
        ClientCommandHelper.sendFeedback("twoPlayerGame.chat.lost", sender, this.translate());
        this.removeActiveGame(senderUUID);
    }

    public void onMove(String sender) {
        class_5250 clickable = class_2561.method_43471((String)"twoPlayerGame.clickToMakeYourMove");
        clickable.method_27694(style -> style.method_10977(class_124.field_1060).method_30938(Boolean.valueOf(true)).method_10958((class_2558)new class_2558.class_10609("/" + this.command + " open " + sender)).method_10949((class_2568)new class_2568.class_10613((class_2561)class_2561.method_43470((String)("/" + this.command + " open " + sender)))));
        ClientCommandHelper.sendFeedback((class_2561)class_2561.method_43469((String)"twoPlayerGame.incoming", (Object[])new Object[]{sender, this.translate()}).method_27693(" [").method_10852((class_2561)clickable).method_27693("]"));
    }

    static {
        ClientConnectionEvents.DISCONNECT.register(() -> {
            for (TwoPlayerGame<?, ?> game : TYPE_BY_NAME.values()) {
                game.activeGames.clear();
                game.pendingInvites.clear();
            }
        });
    }

    @FunctionalInterface
    public static interface GameFactory<T> {
        public T create(class_640 var1, boolean var2);
    }

    @FunctionalInterface
    public static interface ScreenFactory<T, S extends class_437> {
        public S createScreen(T var1);
    }
}

