/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.render;

import com.mojang.blaze3d.pipeline.RenderPipeline;
import com.mojang.blaze3d.platform.DepthTestFunction;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalDouble;
import net.earthcomputer.clientcommands.render.Cuboid;
import net.earthcomputer.clientcommands.render.Line;
import net.earthcomputer.clientcommands.render.Shape;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderContext;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_10799;
import net.minecraft.class_1921;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4588;
import net.minecraft.class_4668;

public class RenderQueue {
    private static int tickCounter = 0;
    private static final List<AddQueueEntry> addQueue = new ArrayList<AddQueueEntry>();
    private static final List<RemoveQueueEntry> removeQueue = new ArrayList<RemoveQueueEntry>();
    private static final EnumMap<Layer, Map<Object, Shape>> queue = new EnumMap(Layer.class);
    private static final RenderPipeline LINES_NO_DEPTH_PIPELINE = class_10799.method_67887((RenderPipeline)RenderPipeline.builder((RenderPipeline.Snippet[])new RenderPipeline.Snippet[]{class_10799.field_56859}).withLocation(class_2960.method_60655((String)"clientcommands", (String)"pipeline/lines_no_depth")).withDepthTestFunction(DepthTestFunction.NO_DEPTH_TEST).build());
    public static final class_1921 LINES_NO_DEPTH_LAYER = class_1921.method_24048((String)"clientcommands_no_depth", (int)1536, (RenderPipeline)LINES_NO_DEPTH_PIPELINE, (class_1921.class_4688)class_1921.class_4688.method_23598().method_23607(class_1921.field_22241).method_23609(new class_4668.class_4677(OptionalDouble.of(2.0))).method_23617(false));

    public static void register() {
    }

    public static void add(Layer layer, Object key, Shape shape, int life) {
        addQueue.add(new AddQueueEntry(layer, key, shape, life));
    }

    public static void addCuboid(Layer layer, Object key, class_243 from, class_243 to, int color, int life) {
        RenderQueue.add(layer, key, new Cuboid(from, to, color), life);
    }

    public static void addCuboid(Layer layer, Object key, class_238 cuboid, int color, int life) {
        RenderQueue.add(layer, key, new Cuboid(cuboid, color), life);
    }

    public static void addLine(Layer layer, Object key, class_243 from, class_243 to, int color, int life) {
        RenderQueue.add(layer, key, new Line(from, to, color), life);
    }

    public static void remove(Layer layer, Object key) {
        removeQueue.add(new RemoveQueueEntry(layer, key));
    }

    private static void doAdd(AddQueueEntry entry) {
        Map shapes = queue.computeIfAbsent(entry.layer(), k -> new LinkedHashMap());
        Shape oldShape = (Shape)shapes.get(entry.key());
        entry.shape().prevPos = oldShape != null ? oldShape.prevPos : entry.shape().getPos();
        entry.shape().deathTime = tickCounter + entry.life();
        shapes.put(entry.key(), entry.shape());
    }

    private static void tick(class_310 mc) {
        for (RemoveQueueEntry removeQueueEntry : removeQueue) {
            Map<Object, Shape> shapes2 = queue.get((Object)removeQueueEntry.layer());
            if (shapes2 == null) continue;
            shapes2.remove(removeQueueEntry.key());
        }
        removeQueue.clear();
        queue.values().forEach(shapes -> shapes.values().forEach(shape -> {
            shape.prevPos = shape.getPos();
        }));
        ++tickCounter;
        for (AddQueueEntry addQueueEntry : addQueue) {
            RenderQueue.doAdd(addQueueEntry);
        }
        addQueue.clear();
        for (Map map : queue.values()) {
            Iterator itr = map.values().iterator();
            while (itr.hasNext()) {
                Shape shape = (Shape)itr.next();
                if (tickCounter == shape.deathTime) {
                    itr.remove();
                }
                shape.tick();
            }
        }
    }

    public static void render(Layer layer, class_4588 vertexConsumer, WorldRenderContext context) {
        if (!queue.containsKey((Object)layer)) {
            return;
        }
        queue.get((Object)layer).values().forEach(shape -> shape.render(vertexConsumer, context));
    }

    static {
        ClientTickEvents.START_CLIENT_TICK.register(RenderQueue::tick);
        WorldRenderEvents.AFTER_TRANSLUCENT.register(context -> RenderQueue.render(Layer.ON_TOP, Objects.requireNonNull(context.consumers()).getBuffer(LINES_NO_DEPTH_LAYER), context));
    }

    private record AddQueueEntry(Layer layer, Object key, Shape shape, int life) {
    }

    public static enum Layer {
        ON_TOP;

    }

    private record RemoveQueueEntry(Layer layer, Object key) {
    }
}

