/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.util;

import com.mojang.logging.LogUtils;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import net.earthcomputer.clientcommands.ClientCommands;
import net.earthcomputer.clientcommands.util.DebugRandomSourcePanel;
import net.earthcomputer.clientcommands.util.RandomCall;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5820;
import net.minecraft.class_6673;
import net.minecraft.class_7923;
import org.slf4j.Logger;

public class DebugRandom
extends class_5820 {
    static final Logger LOGGER = LogUtils.getLogger();
    public static final class_1299<?> DEBUG_ENTITY_TYPE;
    private static final Object2IntMap<String> stackTraceIds;
    static final List<String> stackTraceById;
    private final class_1297 entity;
    private boolean firstTick = true;
    private final List<IntList> stackTraces = new ArrayList<IntList>();
    private IntList stackTracesThisTick = new IntArrayList();
    private final ByteArrayOutputStream gzippedNbt = new ByteArrayOutputStream();
    private final DataOutputStream nbtStream;

    public DebugRandom(class_1297 entity) {
        super(class_6673.method_39001());
        this.entity = entity;
        this.stackTraces.add(this.stackTracesThisTick);
        try {
            this.nbtStream = new DataOutputStream(new GZIPOutputStream(this.gzippedNbt));
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public int method_43156(int bits) {
        StringWriter sw = new StringWriter();
        new Throwable("Stack trace").printStackTrace(new PrintWriter(sw));
        int stackTrace = stackTraceIds.computeIfAbsent((Object)sw.toString(), st -> {
            stackTraceById.add((String)st);
            return stackTraceIds.size();
        });
        this.handleStackTrace(stackTrace);
        return super.method_43156(bits);
    }

    public void tick() {
        this.stackTracesThisTick = new IntArrayList();
        this.stackTraces.add(this.stackTracesThisTick);
        this.firstTick = false;
    }

    private void handleStackTrace(int stackTrace) {
        this.stackTracesThisTick.add(stackTrace);
        try {
            class_2507.method_55324((class_2520)(this.firstTick ? new class_2487() : this.entity.method_5647(new class_2487())), (DataOutput)this.nbtStream);
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void writeToFile() {
        try {
            this.nbtStream.close();
            Path debugDir = ClientCommands.CONFIG_DIR.resolve("debug");
            Files.createDirectories(debugDir, new FileAttribute[0]);
            try (DataOutputStream dataOutput = new DataOutputStream(new GZIPOutputStream(Files.newOutputStream(debugDir.resolve(this.entity.method_5845() + ".dat"), new OpenOption[0])));){
                dataOutput.writeInt(stackTraceById.size());
                for (String st : stackTraceById) {
                    dataOutput.writeUTF(st);
                }
                dataOutput.writeInt(this.stackTraces.size());
                for (IntList stackTracesThisTick : this.stackTraces) {
                    dataOutput.writeInt(stackTracesThisTick.size());
                    for (int i = 0; i < stackTracesThisTick.size(); ++i) {
                        dataOutput.writeInt(stackTracesThisTick.getInt(i));
                    }
                }
                dataOutput.write(this.gzippedNbt.toByteArray());
            }
            LOGGER.info("Written debug random for " + this.entity.method_5845() + " to file");
        }
        catch (IOException e) {
            LOGGER.error("Error saving debug source to file", (Throwable)e);
        }
    }

    public static void main(String[] args) {
        ArrayList<List<RandomCall>> randomCalls;
        JFileChooser fileChooser = new JFileChooser("config/clientcommands/debug");
        if (fileChooser.showOpenDialog(null) != 0) {
            return;
        }
        Path path = fileChooser.getSelectedFile().toPath();
        try (DataInputStream in = new DataInputStream(new GZIPInputStream(Files.newInputStream(path, new OpenOption[0])));){
            int numStackTraces = in.readInt();
            for (int i = 0; i < numStackTraces; ++i) {
                String stackTrace = in.readUTF();
                stackTraceById.add(stackTrace);
                stackTraceIds.put((Object)stackTrace, i);
            }
            int numTicks = in.readInt();
            ArrayList<IntArrayList> stackTraces = new ArrayList<IntArrayList>(numTicks);
            for (int tick = 0; tick < numTicks; ++tick) {
                int numStackTracesThisTick = in.readInt();
                IntArrayList stackTracesThisTick = new IntArrayList(numStackTracesThisTick);
                for (int i = 0; i < numStackTracesThisTick; ++i) {
                    stackTracesThisTick.add(in.readInt());
                }
                stackTraces.add(stackTracesThisTick);
            }
            randomCalls = new ArrayList<List<RandomCall>>(numTicks);
            byte[] remainingBytes = in.readAllBytes();
            try (DataInputStream in2 = new DataInputStream(new GZIPInputStream(new ByteArrayInputStream(remainingBytes)));){
                for (IntList intList : stackTraces) {
                    ArrayList<RandomCall> callsThisTick = new ArrayList<RandomCall>(intList.size());
                    for (int j = 0; j < intList.size(); ++j) {
                        callsThisTick.add(new RandomCall(intList.getInt(j), class_2507.method_10627((DataInput)in2)));
                    }
                    randomCalls.add(callsThisTick);
                }
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to read file", (Throwable)e);
            return;
        }
        JFrame frame = new JFrame("Debug Entity RNG");
        frame.add(new DebugRandomSourcePanel(randomCalls));
        frame.setDefaultCloseOperation(2);
        frame.pack();
        frame.setVisible(true);
    }

    static {
        String debugEntityType = System.getProperty("clientcommands.debugEntityRng");
        DEBUG_ENTITY_TYPE = debugEntityType == null ? null : (class_1299)class_7923.field_41177.method_63535(class_2960.method_60654((String)debugEntityType));
        stackTraceIds = new Object2IntOpenHashMap();
        stackTraceById = new ArrayList<String>();
    }
}

