/*
 * Decompiled with CFR 0.152.
 */
package com.seedfinding.mcfeature.structure;

import com.seedfinding.mcbiome.biome.Biome;
import com.seedfinding.mcbiome.biome.Biomes;
import com.seedfinding.mccore.rand.ChunkRand;
import com.seedfinding.mccore.state.Dimension;
import com.seedfinding.mccore.util.block.BlockRotation;
import com.seedfinding.mccore.util.pos.CPos;
import com.seedfinding.mccore.version.MCVersion;
import com.seedfinding.mccore.version.VersionMap;
import com.seedfinding.mcfeature.structure.OldStructure;
import com.seedfinding.mcfeature.structure.RegionStructure;

public class Village
extends OldStructure<Village> {
    public static final VersionMap<OldStructure.Config> CONFIGS = new VersionMap<OldStructure.Config>().add(MCVersion.v1_8, new OldStructure.Config(10387312));

    public Village(MCVersion version) {
        this(CONFIGS.getAsOf(version), version);
    }

    public Village(RegionStructure.Config config, MCVersion version) {
        super(config, version);
    }

    public static String name() {
        return "village";
    }

    public boolean isZombieVillage(long structureSeed, CPos cPos, ChunkRand rand) {
        rand.setCarverSeed(structureSeed, cPos.getX(), cPos.getZ(), this.getVersion());
        rand.advance(1L);
        if (this.getVersion().isNewerOrEqualTo(MCVersion.v1_10) && this.getVersion().isOlderThan(MCVersion.v1_14)) {
            int size = 0;
            rand.getInt(2 + size, 4 + size * 2);
            rand.getInt(0 + size, 1 + size);
            rand.getInt(0 + size, 2 + size);
            rand.getInt(2 + size, 5 + size * 3);
            rand.getInt(0 + size, 2 + size);
            rand.getInt(1 + size, 4 + size);
            rand.getInt(2 + size, 4 + size * 2);
            rand.getInt(0, 1 + size);
            rand.getInt(0 + size, 3 + size * 2);
            BlockRotation rotation = BlockRotation.getRandom(rand);
            return rand.nextInt(50) == 0;
        }
        if (this.getVersion().isNewerOrEqualTo(MCVersion.v1_14) && this.biome != null) {
            if (Biomes.PLAINS.equals(this.biome)) {
                return rand.nextInt(204) >= 200;
            }
            if (Biomes.DESERT.equals(this.biome)) {
                return rand.nextInt(250) >= 245;
            }
            if (Biomes.SAVANNA.equals(this.biome)) {
                return rand.nextInt(459) >= 450;
            }
            if (Biomes.TAIGA.equals(this.biome)) {
                return rand.nextInt(100) >= 98;
            }
            if (Biomes.SNOWY_TUNDRA.equals(this.biome)) {
                return rand.nextInt(306) >= 300;
            }
        }
        return false;
    }

    @Override
    public Dimension getValidDimension() {
        return Dimension.OVERWORLD;
    }

    @Override
    public boolean isValidBiome(Biome biome) {
        if (biome == Biomes.PLAINS || biome == Biomes.DESERT || biome == Biomes.SAVANNA) {
            return true;
        }
        if (biome == Biomes.TAIGA && this.getVersion().isNewerOrEqualTo(MCVersion.v1_10)) {
            return true;
        }
        return biome == Biomes.SNOWY_TUNDRA && this.getVersion().isNewerOrEqualTo(MCVersion.v1_14);
    }
}

