/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.logging.LogUtils;
import java.util.UUID;
import net.earthcomputer.clientcommands.c2c.C2CPacketHandler;
import net.earthcomputer.clientcommands.c2c.packets.PutConnectFourPieceC2CPacket;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.earthcomputer.clientcommands.features.TwoPlayerGame;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_10799;
import net.minecraft.class_11909;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_5348;
import net.minecraft.class_634;
import net.minecraft.class_640;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;

public class ConnectFourCommand {
    private static final Logger LOGGER = LogUtils.getLogger();

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        dispatcher.register(TwoPlayerGame.CONNECT_FOUR_GAME_TYPE.createCommandTree());
    }

    public static void onPutConnectFourPieceC2CPacket(PutConnectFourPieceC2CPacket packet) {
        UUID senderUUID = packet.senderUUID();
        ConnectFourGame game = TwoPlayerGame.CONNECT_FOUR_GAME_TYPE.getActiveGame(senderUUID);
        if (game == null) {
            return;
        }
        game.onMove(packet.x(), game.opponentPiece());
    }

    public static class ConnectFourGame {
        public static final int WIDTH = 7;
        public static final int HEIGHT = 6;
        public final class_640 opponent;
        public final Piece yourPiece;
        public Piece activePiece;
        public final Piece[][] board;
        @Nullable
        public Winner winner;

        public ConnectFourGame(class_640 opponent, Piece yourPiece) {
            this.opponent = opponent;
            this.yourPiece = yourPiece;
            this.activePiece = Piece.RED;
            this.board = new Piece[7][6];
            this.winner = null;
        }

        public void onMove(int x, Piece piece) {
            class_310 mc = class_310.method_1551();
            class_634 connection = mc.method_1562();
            assert (connection != null);
            if (piece != this.activePiece) {
                LOGGER.warn("Invalid piece, the active piece is {} and the piece that was attempted to be placed was {}", (Object)this.activePiece.translate(), (Object)piece.translate());
                return;
            }
            if (!this.isGameActive()) {
                LOGGER.warn("Tried to add piece to the already completed game with {}.", (Object)this.opponent.method_2966().name());
                return;
            }
            if (!this.addPiece(x, piece)) {
                LOGGER.warn("Failed to add piece to your Connect Four game with {}.", (Object)this.opponent.method_2966().name());
                return;
            }
            if (this.isYourTurn()) {
                try {
                    PutConnectFourPieceC2CPacket packet = new PutConnectFourPieceC2CPacket(connection.method_2879().name(), connection.method_2879().id(), x);
                    C2CPacketHandler.getInstance().sendPacket(packet, this.opponent);
                }
                catch (CommandSyntaxException e) {
                    ClientCommandHelper.sendFeedback(class_2561.method_54155((Message)e.getRawMessage()));
                }
            }
            String sender = this.opponent.method_2966().name();
            UUID senderUUID = this.opponent.method_2966().id();
            this.activePiece = piece.opposite();
            this.winner = this.getWinner();
            if (this.winner != null) {
                if (this.winner == this.yourPiece.asWinner()) {
                    TwoPlayerGame.CONNECT_FOUR_GAME_TYPE.onWon(sender, senderUUID);
                } else if (this.winner == this.yourPiece.opposite().asWinner()) {
                    TwoPlayerGame.CONNECT_FOUR_GAME_TYPE.onLost(sender, senderUUID);
                } else if (this.winner == Winner.DRAW) {
                    TwoPlayerGame.CONNECT_FOUR_GAME_TYPE.onDraw(sender, senderUUID);
                }
            } else if (this.isYourTurn()) {
                TwoPlayerGame.CONNECT_FOUR_GAME_TYPE.onMove(sender);
            }
        }

        public boolean isYourTurn() {
            return this.activePiece == this.yourPiece;
        }

        public boolean isGameActive() {
            return this.winner == null;
        }

        public boolean canMove() {
            return this.isYourTurn() && this.isGameActive();
        }

        public Piece opponentPiece() {
            return this.yourPiece.opposite();
        }

        public boolean addPiece(int x, Piece piece) {
            int y;
            if (ConnectFourGame.isValidRow(x) && (y = this.getPlacementY(x)) < 6) {
                this.board[x][y] = piece;
                return true;
            }
            return false;
        }

        @Nullable
        private Winner getWinner() {
            int y;
            int x;
            for (x = 0; x < 4; ++x) {
                for (y = 0; y < 6; ++y) {
                    if (this.board[x][y] == null || this.board[x][y] != this.board[x + 1][y] || this.board[x][y] != this.board[x + 2][y] || this.board[x][y] != this.board[x + 3][y]) continue;
                    return this.board[x][y].asWinner();
                }
            }
            for (x = 0; x < 7; ++x) {
                for (y = 0; y < 3; ++y) {
                    if (this.board[x][y] == null || this.board[x][y] != this.board[x][y + 1] || this.board[x][y] != this.board[x][y + 2] || this.board[x][y] != this.board[x][y + 3]) continue;
                    return this.board[x][y].asWinner();
                }
            }
            for (x = 0; x < 4; ++x) {
                for (y = 0; y < 3; ++y) {
                    if (this.board[x][y] == null || this.board[x][y] != this.board[x + 1][y + 1] || this.board[x][y] != this.board[x + 2][y + 2] || this.board[x][y] != this.board[x + 3][y + 3]) continue;
                    return this.board[x][y].asWinner();
                }
            }
            for (x = 0; x < 4; ++x) {
                for (y = 3; y < 6; ++y) {
                    if (this.board[x][y] == null || this.board[x][y] != this.board[x + 1][y - 1] || this.board[x][y] != this.board[x + 2][y - 2] || this.board[x][y] != this.board[x + 3][y - 3]) continue;
                    return this.board[x][y].asWinner();
                }
            }
            for (x = 0; x < 7; ++x) {
                for (y = 0; y < 6; ++y) {
                    if (this.board[x][y] != null) continue;
                    return null;
                }
            }
            return Winner.DRAW;
        }

        public static boolean isValidRow(int x) {
            return 0 <= x && x < 7;
        }

        public int getPlacementY(int x) {
            int y = 0;
            for (Piece piece : this.board[x]) {
                if (piece == null) break;
                ++y;
            }
            return y;
        }
    }

    public static enum Piece {
        RED,
        YELLOW;


        public Piece opposite() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> YELLOW;
                case 1 -> RED;
            };
        }

        public class_2561 translate() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> class_2561.method_43471((String)"connectFourGame.pieceRed");
                case 1 -> class_2561.method_43471((String)"connectFourGame.pieceYellow");
            };
        }

        public Winner asWinner() {
            return switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> Winner.RED;
                case 1 -> Winner.YELLOW;
            };
        }

        public void render(class_332 graphics, int x, int y, boolean transparent) {
            int xOffset = switch (this.ordinal()) {
                default -> throw new MatchException(null, null);
                case 0 -> 0;
                case 1 -> 16;
            };
            graphics.method_25293(class_10799.field_56883, ConnectFourGameScreen.PIECES_TEXTURE, x, y, (float)xOffset, 0.0f, 64, 64, 16, 16, 32, 16, transparent ? Integer.MAX_VALUE : -1);
        }
    }

    public static class ConnectFourGameScreen
    extends class_437 {
        private final ConnectFourGame game;
        private static final class_2960 BOARD_TEXTURE = class_2960.method_60655((String)"clientcommands", (String)"textures/connect_four/board.png");
        private static final class_2960 PIECES_TEXTURE = class_2960.method_60655((String)"clientcommands", (String)"textures/connect_four/pieces.png");
        private static final int SCALE = 4;
        private static final int TEXTURE_PIECE_WIDTH = 16;
        private static final int TEXTURE_PIECE_HEIGHT = 16;
        private static final int TEXTURE_BOARD_BORDER_WIDTH = 1;
        private static final int TEXTURE_BOARD_BORDER_HEIGHT = 1;
        private static final int TEXTURE_SLOT_BORDER_WIDTH = 1;
        private static final int TEXTURE_SLOT_BORDER_HEIGHT = 1;
        private static final int TEXTURE_SLOT_WIDTH = 18;
        private static final int TEXTURE_SLOT_HEIGHT = 18;
        private static final int TEXTURE_BOARD_WIDTH = 128;
        private static final int TEXTURE_BOARD_HEIGHT = 110;
        private static final int TEXTURE_PIECES_WIDTH = 32;
        private static final int TEXTURE_PIECES_HEIGHT = 16;
        private static final int BOARD_WIDTH = 512;
        private static final int BOARD_HEIGHT = 440;
        private static final int PIECE_WIDTH = 64;
        private static final int PIECE_HEIGHT = 64;
        private static final int BOARD_BORDER_WIDTH = 4;
        private static final int BOARD_BORDER_HEIGHT = 4;
        private static final int SLOT_BORDER_WIDTH = 4;
        private static final int SLOT_BORDER_HEIGHT = 4;
        private static final int SLOT_WIDTH = 72;
        private static final int SLOT_HEIGHT = 72;

        public ConnectFourGameScreen(ConnectFourGame game) {
            super((class_2561)class_2561.method_43469((String)"connectFourGame.title", (Object[])new Object[]{game.opponent.method_2966().name()}));
            this.game = game;
        }

        public void method_25420(class_332 graphics, int mouseX, int mouseY, float partialTick) {
            int x;
            int y;
            super.method_25420(graphics, mouseX, mouseY, partialTick);
            int startX = (this.field_22789 - 512) / 2;
            int startY = (this.field_22790 - 440) / 2;
            class_2561 gameStateTranslate = this.getGameStateTranslate();
            graphics.method_27535(this.field_22793, (class_2561)class_2561.method_43469((String)"connectFourGame.pieceSet", (Object[])new Object[]{this.game.yourPiece.translate()}), startX, startY - 20, -1);
            graphics.method_27535(this.field_22793, this.field_22785, startX, startY - 10, -1);
            graphics.method_27535(this.field_22793, gameStateTranslate, startX + 512 - this.field_22793.method_27525((class_5348)gameStateTranslate), startY - 10, -1);
            graphics.method_25302(class_10799.field_56883, BOARD_TEXTURE, startX, startY, 0.0f, 0.0f, 512, 440, 128, 110, 128, 110);
            for (int x2 = 0; x2 < 7; ++x2) {
                for (int y2 = 0; y2 < 6; ++y2) {
                    Piece piece = this.game.board[x2][y2];
                    if (piece == null) continue;
                    piece.render(graphics, startX + 4 + 72 * x2 + 4, startY + 4 + 72 * (5 - y2) + 4, false);
                }
            }
            int boardMinX = startX + 4;
            int boardMaxX = startX + 512 - 8;
            int boardMaxY = startY + 440;
            if (this.game.canMove() && boardMinX <= mouseX && mouseX < boardMaxX && mouseY < boardMaxY && (y = this.game.getPlacementY(x = (mouseX - boardMinX) / 72)) < 6) {
                this.game.yourPiece.render(graphics, startX + 4 + 72 * x + 4, startY + 4 + 72 * (5 - y) + 4, true);
            }
        }

        private class_2561 getGameStateTranslate() {
            if (this.game.isGameActive()) {
                if (this.game.isYourTurn()) {
                    return class_2561.method_43471((String)"connectFourGame.yourMove");
                }
                return class_2561.method_43471((String)"connectFourGame.opponentMove");
            }
            if (this.game.winner == Winner.DRAW) {
                return class_2561.method_43471((String)"connectFourGame.draw");
            }
            if (this.game.winner == this.game.yourPiece.asWinner()) {
                return class_2561.method_43471((String)"connectFourGame.won").method_27692(class_124.field_1060);
            }
            return class_2561.method_43471((String)"connectFourGame.lost").method_27692(class_124.field_1061);
        }

        public boolean method_25402(class_11909 event, boolean doubleClick) {
            int startX = (this.field_22789 - 512) / 2;
            int startY = (this.field_22790 - 440) / 2;
            int boardMinX = startX + 4;
            int boardMaxX = startX + 512 - 8;
            int boardMaxY = startY + 440;
            if (!((double)boardMinX <= event.comp_4798() && event.comp_4798() < (double)boardMaxX && event.comp_4799() < (double)boardMaxY)) {
                return super.method_25402(event, doubleClick);
            }
            if (event.method_74245() != 0) {
                return false;
            }
            int x = (int)((event.comp_4798() - (double)boardMinX) / 72.0);
            if (this.game.canMove()) {
                this.game.onMove(x, this.game.yourPiece);
                return true;
            }
            return false;
        }
    }

    public static enum Winner {
        RED,
        YELLOW,
        DRAW;

    }
}

