/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.tree.LiteralCommandNode;
import com.seedfinding.mcfeature.loot.LootContext;
import com.seedfinding.mcfeature.loot.LootTable;
import com.seedfinding.mcfeature.loot.MCLootTables;
import com.seedfinding.mcfeature.loot.item.ItemStack;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.earthcomputer.clientcommands.command.ClientCommandHelper;
import net.earthcomputer.clientcommands.command.Flag;
import net.earthcomputer.clientcommands.task.RenderDistanceScanTask;
import net.earthcomputer.clientcommands.task.TaskManager;
import net.earthcomputer.clientcommands.util.CComponentUtil;
import net.earthcomputer.clientcommands.util.SeedfindingUtil;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandManager;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1844;
import net.minecraft.class_1972;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4076;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_746;
import net.minecraft.class_8170;
import net.minecraft.class_9290;
import net.minecraft.class_9298;
import net.minecraft.class_9334;

public class PredictBrushablesCommand {
    public static final Flag<Boolean> FLAG_KEEP_SEARCHING = Flag.ofFlag("keep-searching").build();

    public static void register(CommandDispatcher<FabricClientCommandSource> dispatcher) {
        LiteralCommandNode cpredictbrushables = dispatcher.register((LiteralArgumentBuilder)ClientCommandManager.literal((String)"cpredictbrushables").executes(PredictBrushablesCommand::predictBrushables));
        FLAG_KEEP_SEARCHING.addToCommand(dispatcher, (LiteralCommandNode<FabricClientCommandSource>)cpredictbrushables, ctx -> true);
    }

    private static int predictBrushables(CommandContext<FabricClientCommandSource> ctx) throws CommandSyntaxException {
        boolean keepSearching = ClientCommandHelper.getFlag(ctx, FLAG_KEEP_SEARCHING);
        String taskName = TaskManager.addTask("cpredictbrushables", new PredictBrushablesTask(keepSearching));
        if (keepSearching) {
            ClientCommandHelper.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cpredictbrushables.starting.keepSearching", (Object[])new Object[]{CComponentUtil.getCommandTextComponent("commands.client.cancel", "/ctask stop " + taskName)}));
        } else {
            ClientCommandHelper.sendFeedback((class_2561)class_2561.method_43471((String)"commands.cpredictbrushables.starting"));
        }
        return 1;
    }

    private static final class PredictBrushablesTask
    extends RenderDistanceScanTask {
        private boolean found = false;

        PredictBrushablesTask(boolean keepSearching) {
            super(keepSearching);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        protected void scanBlock(class_1297 cameraEntity, class_2338 pos) {
            long lootSeed;
            Supplier<LootTable> lootTableSupplier;
            class_310 minecraft = class_310.method_1551();
            class_746 player = minecraft.field_1724;
            class_638 level = minecraft.field_1687;
            assert (level != null);
            class_2680 blockState = level.method_8320(pos);
            if (blockState.method_27852(class_2246.field_42728)) {
                biome = level.method_23753(pos);
                if (biome.method_40225(class_1972.field_9424)) {
                    boolean hasWater = Stream.of(pos.method_33096(pos.method_10264() + 1), pos.method_33096(pos.method_10264() + 2)).map(arg_0 -> ((class_638)level).method_8320(arg_0)).anyMatch(s -> s.method_27852(class_2246.field_10382));
                    lootTableSupplier = hasWater ? MCLootTables.DESERT_WELL_ARCHAEOLOGY : MCLootTables.DESERT_PYRAMID_ARCHAEOLOGY;
                    lootSeed = pos.method_10063();
                } else {
                    if (!biome.method_40220(class_6908.field_36527)) return;
                    lootTableSupplier = MCLootTables.OCEAN_RUIN_WARM_ARCHAEOLOGY;
                    class_5819 randomSource = class_5819.method_43049((long)class_3532.method_15389((class_2382)pos));
                    lootSeed = randomSource.method_43055();
                }
            } else {
                if (!blockState.method_27852(class_2246.field_43227)) return;
                biome = level.method_23753(pos);
                if (biome.method_40220(class_6908.field_36526)) {
                    lootTableSupplier = MCLootTables.OCEAN_RUIN_COLD_ARCHAEOLOGY;
                    class_5819 randomSource = class_5819.method_43049((long)class_3532.method_15389((class_2382)pos));
                    lootSeed = randomSource.method_43055();
                } else {
                    if (!biome.method_40220(class_6908.field_43168)) return;
                    return;
                }
            }
            LootContext context = new LootContext(lootSeed, SeedfindingUtil.getMCVersion()).withLuck((int)player.method_7292());
            List<ItemStack> items = lootTableSupplier.get().generate(context);
            for (ItemStack item : items) {
                class_1799 mcItemStack = SeedfindingUtil.fromSeedfindingItem(item, level.method_30349());
                mcItemStack.method_57379(class_9334.field_49632, (Object)PredictBrushablesTask.getItemLore(mcItemStack));
                ClientCommandHelper.sendFeedback((class_2561)class_2561.method_43469((String)"commands.cpredictbrushables.foundBrushableBlock", (Object[])new Object[]{blockState.method_26204().method_9518(), CComponentUtil.getLookCoordsTextComponent(pos), mcItemStack.method_7954(), CComponentUtil.getGlowButtonTextComponent(pos)}));
            }
            this.found = true;
        }

        private static class_9290 getItemLore(class_1799 itemStack) {
            class_9298 effects = (class_9298)itemStack.method_58694(class_9334.field_49652);
            if (effects == null) {
                return class_9290.field_49340;
            }
            ArrayList<class_5250> components = new ArrayList<class_5250>();
            for (class_9298.class_8751 entry : effects.comp_2416()) {
                class_1293 mobEffectInstance = entry.method_53247();
                class_5250 description = class_1844.method_66698((class_6880)mobEffectInstance.method_5579(), (int)mobEffectInstance.method_5578());
                class_5250 line = class_2561.method_43469((String)"commands.cpredictbrushables.stewEffect", (Object[])new Object[]{description, entry.comp_1839() / 20});
                components.add(line);
            }
            return new class_9290(components);
        }

        @Override
        protected void onBlockStateUpdate(class_638 level, class_2338 pos, class_2680 oldState, class_2680 newState) {
        }

        @Override
        protected boolean canScanChunkSection(class_1297 cameraEntity, class_4076 pos) {
            return this.hasBlockState(pos, s -> s.method_26204() instanceof class_8170) && super.canScanChunkSection(cameraEntity, pos);
        }

        @Override
        public void onCompleted() {
            super.onCompleted();
            if (!this.found) {
                ClientCommandHelper.sendError((class_2561)class_2561.method_43471((String)"commands.cpredictbrushables.notFound"));
            }
        }
    }
}

