/*
 * Decompiled with CFR 0.152.
 */
package net.earthcomputer.clientcommands.command.arguments;

import com.mojang.brigadier.ImmutableStringReader;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.DynamicCommandExceptionType;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import com.mojang.brigadier.suggestion.Suggestions;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.earthcomputer.clientcommands.util.MultiVersionCompat;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1889;
import net.minecraft.class_1935;
import net.minecraft.class_2096;
import net.minecraft.class_2172;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import net.minecraft.class_7733;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9889;
import org.jetbrains.annotations.Nullable;

public class ItemAndEnchantmentsPredicateArgument
implements ArgumentType<ItemAndEnchantmentsPredicate> {
    private static final Collection<String> EXAMPLES = Arrays.asList("stick with sharpness 4 without sweeping *", "minecraft:diamond_sword with sharpness *");
    private static final SimpleCommandExceptionType INCOMPATIBLE_ENCHANTMENT_EXCEPTION = new SimpleCommandExceptionType((Message)class_2561.method_43471((String)"commands.cenchant.incompatible"));
    private static final DynamicCommandExceptionType ID_INVALID_EXCEPTION = new DynamicCommandExceptionType(id -> class_2561.method_43469((String)"argument.item.id.invalid", (Object[])new Object[]{id}));
    private final class_7225<class_1887> enchantmentLookup;
    private Predicate<class_1792> itemPredicate = item -> true;
    private BiPredicate<class_1792, class_6880<class_1887>> enchantmentPredicate = (item, ench) -> true;
    private boolean constrainMaxLevel = false;

    private ItemAndEnchantmentsPredicateArgument(class_7225.class_7874 holderLookupProvider) {
        this.enchantmentLookup = holderLookupProvider.method_46762(class_7924.field_41265);
    }

    public static ItemAndEnchantmentsPredicateArgument itemAndEnchantmentsPredicate(class_7225.class_7874 holderLookupProvider) {
        return new ItemAndEnchantmentsPredicateArgument(holderLookupProvider);
    }

    public ItemAndEnchantmentsPredicateArgument withItemPredicate(Predicate<class_1792> predicate) {
        this.itemPredicate = predicate;
        return this;
    }

    public ItemAndEnchantmentsPredicateArgument withEnchantmentPredicate(BiPredicate<class_1792, class_6880<class_1887>> predicate) {
        this.enchantmentPredicate = predicate;
        return this;
    }

    public ItemAndEnchantmentsPredicateArgument constrainMaxLevel() {
        this.constrainMaxLevel = true;
        return this;
    }

    public static ItemAndEnchantmentsPredicate getItemAndEnchantmentsPredicate(CommandContext<?> context, String name) {
        return (ItemAndEnchantmentsPredicate)context.getArgument(name, ItemAndEnchantmentsPredicate.class);
    }

    public ItemAndEnchantmentsPredicate parse(StringReader reader) throws CommandSyntaxException {
        Parser parser = new Parser(reader);
        parser.parse();
        Predicate<List<class_1889>> predicate = enchantments -> {
            if (parser.exact && parser.with.size() != enchantments.size()) {
                return false;
            }
            if (parser.ordered) {
                int enchIndex = 0;
                for (EnchantmentInstancePredicate with : parser.with) {
                    while (enchIndex < enchantments.size() && !with.test((class_1889)enchantments.get(enchIndex))) {
                        ++enchIndex;
                    }
                    if (enchIndex >= enchantments.size()) {
                        return false;
                    }
                    ++enchIndex;
                }
            } else {
                for (EnchantmentInstancePredicate with : parser.with) {
                    boolean found = false;
                    for (class_1889 ench : enchantments) {
                        if (!with.test(ench)) continue;
                        found = true;
                        break;
                    }
                    if (found) continue;
                    return false;
                }
            }
            if (parser.exact) {
                return true;
            }
            for (EnchantmentInstancePredicate without : parser.without) {
                for (class_1889 ench : enchantments) {
                    if (!without.test(ench)) continue;
                    return false;
                }
            }
            return true;
        };
        return new ItemAndEnchantmentsPredicate(parser.item, predicate, parser.with.size());
    }

    public <S> CompletableFuture<Suggestions> listSuggestions(CommandContext<S> context, SuggestionsBuilder builder) {
        StringReader reader = new StringReader(builder.getInput());
        reader.setCursor(builder.getStart());
        Parser parser = new Parser(reader);
        try {
            parser.parse();
        }
        catch (CommandSyntaxException commandSyntaxException) {
            // empty catch block
        }
        if (parser.suggestor != null) {
            parser.suggestor.accept(builder);
        }
        return builder.buildFuture();
    }

    public Collection<String> getExamples() {
        return EXAMPLES;
    }

    public record ItemAndEnchantmentsPredicate(class_1792 item, Predicate<List<class_1889>> predicate, int numEnchantments) implements Predicate<class_1799>
    {
        @Override
        public boolean test(class_1799 stack) {
            if (this.item != stack.method_7909() && (this.item != class_1802.field_8529 || stack.method_7909() != class_1802.field_8598)) {
                return false;
            }
            List<class_1889> enchantments = ((class_9304)stack.method_58695(class_9334.field_49633, (Object)class_9304.field_49385)).method_57539().stream().map(entry -> new class_1889((class_6880)entry.getKey(), entry.getIntValue())).toList();
            return this.predicate.test(enchantments);
        }
    }

    private class Parser {
        private final StringReader reader;
        private Consumer<SuggestionsBuilder> suggestor;
        private class_1792 item;
        private final List<EnchantmentInstancePredicate> with = new ArrayList<EnchantmentInstancePredicate>();
        private final List<EnchantmentInstancePredicate> without = new ArrayList<EnchantmentInstancePredicate>();
        private boolean exact = false;
        private boolean ordered = false;

        public Parser(StringReader reader) {
            this.reader = reader;
        }

        public void parse() throws CommandSyntaxException {
            this.item = this.parseItem();
            while (this.reader.canRead()) {
                this.parseSpace();
                if (this.parseEnchantmentInstancePredicate()) continue;
                break;
            }
        }

        private class_1792 parseItem() throws CommandSyntaxException {
            this.suggestEnchantableItem();
            int start = this.reader.getCursor();
            class_2960 identifier = class_2960.method_12835((StringReader)this.reader);
            class_1792 item = (class_1792)class_7923.field_41178.method_17966(identifier).orElseThrow(() -> {
                this.reader.setCursor(start);
                return ID_INVALID_EXCEPTION.createWithContext((ImmutableStringReader)this.reader, (Object)identifier);
            });
            if (!(item.method_57347().method_57832(class_9334.field_53695) && ItemAndEnchantmentsPredicateArgument.this.itemPredicate.test(item) || item == class_1802.field_8598 && ItemAndEnchantmentsPredicateArgument.this.itemPredicate.test(class_1802.field_8529))) {
                this.reader.setCursor(start);
                throw INCOMPATIBLE_ENCHANTMENT_EXCEPTION.createWithContext((ImmutableStringReader)this.reader);
            }
            if (item == class_1802.field_8598) {
                item = class_1802.field_8529;
            }
            return item;
        }

        private boolean parseEnchantmentInstancePredicate() throws CommandSyntaxException {
            class_1799 stack = new class_1799((class_1935)this.item);
            int start = this.reader.getCursor();
            Option option = this.parseOption();
            if (option == null) {
                this.reader.setCursor(start);
                return false;
            }
            boolean suggest = this.reader.canRead();
            if (option == Option.EXACT) {
                this.exact = true;
                return true;
            }
            if (option == Option.ORDERED) {
                this.ordered = true;
                return true;
            }
            if (this.exact || this.ordered) {
                this.reader.setCursor(start);
                return false;
            }
            this.parseSpace();
            class_6880<class_1887> enchantment = this.parseEnchantment(suggest, option, stack);
            suggest = this.reader.canRead();
            this.parseSpace();
            class_2096.class_2100 level = this.parseEnchantmentLevel(suggest, option, stack, enchantment);
            if (option == Option.WITH) {
                this.with.add(new EnchantmentInstancePredicate(enchantment, level));
            } else {
                this.without.add(new EnchantmentInstancePredicate(enchantment, level));
            }
            return true;
        }

        @Nullable
        private Option parseOption() {
            String option;
            this.suggestOption();
            return switch (option = this.reader.readUnquotedString()) {
                case "with" -> Option.WITH;
                case "without" -> Option.WITHOUT;
                case "exactly" -> {
                    if (this.exact) {
                        yield null;
                    }
                    yield Option.EXACT;
                }
                case "ordered" -> {
                    if (this.ordered || MultiVersionCompat.INSTANCE.getProtocolVersion() >= 767) {
                        yield null;
                    }
                    yield Option.ORDERED;
                }
                default -> null;
            };
        }

        private class_6880<class_1887> parseEnchantment(boolean suggest, Option option, class_1799 stack) throws CommandSyntaxException {
            class_2960 identifier;
            class_5321 enchantmentKey;
            class_6880 enchantment;
            ArrayList allowedEnchantments = new ArrayList();
            ItemAndEnchantmentsPredicateArgument.this.enchantmentLookup.method_42017().forEach(ench -> {
                boolean skip;
                boolean bl = skip = !((class_1887)ench.comp_349()).method_8192(stack) && stack.method_7909() != class_1802.field_8529 || !ItemAndEnchantmentsPredicateArgument.this.enchantmentPredicate.test(stack.method_7909(), (class_6880<class_1887>)ench);
                if (skip) {
                    return;
                }
                if (option == Option.WITH) {
                    for (EnchantmentInstancePredicate ench2 : this.with) {
                        if (class_1887.method_60033((class_6880)ench, ench2.enchantment)) continue;
                        return;
                    }
                    for (EnchantmentInstancePredicate ench2 : this.without) {
                        if (ench2.enchantment != ench || !ench2.level.method_9041()) continue;
                        return;
                    }
                } else {
                    for (EnchantmentInstancePredicate ench2 : this.with) {
                        if (ench2.enchantment != ench || !ench2.level.method_9041()) continue;
                        return;
                    }
                    for (EnchantmentInstancePredicate ench2 : this.without) {
                        if (ench2.enchantment != ench || !ench2.level.method_9041()) continue;
                        return;
                    }
                }
                allowedEnchantments.add(ench);
            });
            int start = this.reader.getCursor();
            if (suggest) {
                this.suggestor = suggestions -> {
                    SuggestionsBuilder builder = suggestions.createOffset(start);
                    class_2172.method_9257(allowedEnchantments.stream().map(ench -> ench.method_40237().method_29177()), (SuggestionsBuilder)builder);
                    suggestions.add(builder);
                };
            }
            if (!((class_1887)(enchantment = (class_6880)ItemAndEnchantmentsPredicateArgument.this.enchantmentLookup.method_46746(enchantmentKey = class_5321.method_29179((class_5321)class_7924.field_41265, (class_2960)(identifier = class_2960.method_12835((StringReader)this.reader)))).orElseThrow(() -> {
                this.reader.setCursor(start);
                return class_7733.field_40401.createWithContext((ImmutableStringReader)this.reader, (Object)identifier, (Object)class_7924.field_41265.method_29177());
            })).comp_349()).method_8192(stack) && stack.method_7909() != class_1802.field_8529) {
                this.reader.setCursor(start);
                throw INCOMPATIBLE_ENCHANTMENT_EXCEPTION.createWithContext((ImmutableStringReader)this.reader);
            }
            return enchantment;
        }

        private class_2096.class_2100 parseEnchantmentLevel(boolean suggest, Option option, class_1799 stack, class_6880<class_1887> enchantment) throws CommandSyntaxException {
            int maxLevel;
            if (ItemAndEnchantmentsPredicateArgument.this.constrainMaxLevel) {
                class_9889 enchantable = (class_9889)stack.method_58694(class_9334.field_53695);
                int enchantability = enchantable == null ? 0 : enchantable.comp_2938();
                int level = 31 + enchantability / 4 + enchantability / 4;
                level += Math.round((float)level * 0.15f);
                for (maxLevel = ((class_1887)enchantment.comp_349()).method_8183(); maxLevel >= 1 && level < ((class_1887)enchantment.comp_349()).method_8182(maxLevel); --maxLevel) {
                }
            } else {
                maxLevel = ((class_1887)enchantment.comp_349()).method_8183();
            }
            ArrayList<Integer> allowedLevels = new ArrayList<Integer>();
            block1: for (int level = -1; level <= maxLevel; ++level) {
                if (level == 0) continue;
                if (option == Option.WITH) {
                    for (EnchantmentInstancePredicate ench : this.without) {
                        if (ench.enchantment != enchantment || level != -1 && !ench.level.method_9054(level)) continue;
                        continue block1;
                    }
                } else {
                    for (EnchantmentInstancePredicate ench : this.with) {
                        if (ench.enchantment != enchantment || level != -1 && !ench.level.method_9054(level)) continue;
                        continue block1;
                    }
                    for (EnchantmentInstancePredicate ench : this.without) {
                        if (ench.enchantment != enchantment || level != -1 && !ench.level.method_9054(level)) continue;
                        continue block1;
                    }
                }
                allowedLevels.add(level);
            }
            int start = this.reader.getCursor();
            if (suggest) {
                this.suggestor = suggestions -> {
                    SuggestionsBuilder builder = suggestions.createOffset(start);
                    Iterator iterator = allowedLevels.iterator();
                    while (iterator.hasNext()) {
                        int allowed = (Integer)iterator.next();
                        if (allowed == -1) {
                            builder.suggest("*");
                            continue;
                        }
                        builder.suggest(allowed);
                    }
                    suggestions.add(builder);
                };
            }
            if (!this.reader.canRead()) {
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerExpectedInt().createWithContext((ImmutableStringReader)this.reader);
            }
            if (this.reader.peek() == '*') {
                this.reader.skip();
                return class_2096.class_2100.field_9708;
            }
            int levelStart = this.reader.getCursor();
            class_2096.class_2100 result = class_2096.class_2100.method_9060((StringReader)this.reader);
            if (allowedLevels.stream().noneMatch(arg_0 -> ((class_2096.class_2100)result).method_9054(arg_0))) {
                int levelEnd = this.reader.getCursor();
                this.reader.setCursor(levelStart);
                throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.readerInvalidInt().createWithContext((ImmutableStringReader)this.reader, (Object)this.reader.getString().substring(levelStart, levelEnd));
            }
            return result;
        }

        private void parseSpace() throws CommandSyntaxException {
            if (this.reader.canRead()) {
                if (this.reader.peek() != ' ') {
                    throw CommandSyntaxException.BUILT_IN_EXCEPTIONS.dispatcherExpectedArgumentSeparator().createWithContext((ImmutableStringReader)this.reader);
                }
                this.reader.skip();
            }
        }

        private void suggestEnchantableItem() {
            ArrayList<class_2960> allowed = new ArrayList<class_2960>();
            for (class_1792 item : class_7923.field_41178) {
                if (item.method_57347().method_57832(class_9334.field_53695) && ItemAndEnchantmentsPredicateArgument.this.itemPredicate.test(item)) {
                    if (!MultiVersionCompat.INSTANCE.doesItemExist(item)) continue;
                    allowed.add(class_7923.field_41178.method_10221((Object)item));
                    continue;
                }
                if (item != class_1802.field_8598 || !ItemAndEnchantmentsPredicateArgument.this.itemPredicate.test(class_1802.field_8529) || !MultiVersionCompat.INSTANCE.doesItemExist(item)) continue;
                allowed.add(class_7923.field_41178.method_10221((Object)class_1802.field_8598));
            }
            int start = this.reader.getCursor();
            this.suggestor = suggestions -> {
                SuggestionsBuilder builder = suggestions.createOffset(start);
                class_2172.method_9270((Iterable)allowed, (SuggestionsBuilder)builder);
                suggestions.add(builder);
            };
        }

        private void suggestOption() {
            int start = this.reader.getCursor();
            this.suggestor = suggestions -> {
                SuggestionsBuilder builder = suggestions.createOffset(start);
                ArrayList<String> validOptions = new ArrayList<String>(4);
                if (!this.exact && !this.ordered) {
                    Collections.addAll(validOptions, "with", "without");
                }
                if (!this.exact) {
                    validOptions.add("exactly");
                }
                if (!this.ordered && MultiVersionCompat.INSTANCE.getProtocolVersion() < 767) {
                    validOptions.add("ordered");
                }
                class_2172.method_9265(validOptions, (SuggestionsBuilder)builder);
                suggestions.add(builder);
            };
        }

        private static enum Option {
            WITH,
            WITHOUT,
            EXACT,
            ORDERED;

        }
    }

    private record EnchantmentInstancePredicate(class_6880<class_1887> enchantment, class_2096.class_2100 level) implements Predicate<class_1889>
    {
        @Override
        public boolean test(class_1889 enchInstance) {
            return this.enchantment.equals((Object)enchInstance.comp_3486()) && this.level.method_9054(enchInstance.comp_3487());
        }
    }
}

