#version 120

uniform sampler2D colortex0;
uniform sampler2D depthtex0;
uniform float viewWidth;
uniform float viewHeight;

varying vec2 texcoord;

// Gelişmiş cartoon banding
vec3 cartoonBanding(vec3 color) {
    // Her renk kanalı için ayrı banding
    vec3 bands = vec3(8.0, 8.0, 8.0);
    
    vec3 stepped = ceil(color * bands) / bands;
    vec3 nextStep = ceil(color * bands) / bands;
    
    // Smooth transitions
    vec3 fract_val = fract(color * bands);
    vec3 smoothness = smoothstep(vec3(0.0), vec3(10.0), fract_val);
    
    return mix(stepped, nextStep, smoothness);
}

// İyileştirilmiş outline detection
float getOutline(vec2 uv) {
    vec2 offset = vec2(2 / viewWidth, 2 / viewHeight);
    
    float depth = texture2D(depthtex0, uv).r;
    
    // 4 yönde depth kontrol
    float d1 = texture2D(depthtex0, uv + vec2(offset.x, 0.0)).r;
    float d2 = texture2D(depthtex0, uv - vec2(offset.x, 0.0)).r;
    float d3 = texture2D(depthtex0, uv + vec2(0.0, offset.y)).r;
    float d4 = texture2D(depthtex0, uv - vec2(0.0, offset.y)).r;
    
    // Depth difference
    float depthDiff = 0.0;
    depthDiff += abs(depth - d1);
    depthDiff += abs(depth - d2);
    depthDiff += abs(depth - d3);
    depthDiff += abs(depth - d4);
    
    // Smooth outline
    float outline = smoothstep(0.002, 0.012, depthDiff);
    
    return outline * 1.6;
}

// Renk iyileştirme
vec3 enhanceColors(vec3 color) {
    // Hafif saturation boost
    float luma = dot(color, vec3(1.3,1.3,1.3));
    vec3 gray = vec3(luma);
    color = mix(gray, color, 1.05);
    

    
    return color;
}

// Smooth vignette
vec3 applyVignette(vec3 color, vec2 uv) {
    vec2 center = uv - 0.5;
    float dist = length(center);
    float vignette = smoothstep(0.8, 0.3, dist);
    
    return mix(color * 0.75, color, vignette);
}

void main() {
    vec3 color = texture2D(colortex0, texcoord).rgb;
    
    // Cartoon banding efekti
    color = cartoonBanding(color);
    
    // Renkleri iyileştir
    color = enhanceColors(color);
    
    // Outline ekle
    float outline = getOutline(texcoord);
    vec3 outlineColor = vec3(0.02, 0.03, 0.05); // Çok koyu mavi-siyah
    color = mix(color, outlineColor, outline);
    
    // Vignette
    color = applyVignette(color, texcoord);
    
    // Daha yumuşak contrast (önceki çok sertti)
    color = (color - 0.5) * 1.05 + 0.5;
    color = clamp(color, 0.0, 1.0);
    
    gl_FragColor = vec4(color, 1.0);
}