#version 120

uniform sampler2D colortex0;
uniform sampler2D depthtex0;
uniform float viewWidth;
uniform float viewHeight;
uniform float frameTimeCounter;
uniform mat4 gbufferProjectionInverse;

varying vec2 texcoord;

// Derinliği gerçek mesafeye çevir
float linearizeDepth(float depth) {
    float near = 0.05;
    float far = 256.0;
    return (2.0 * near) / (far + near - depth * (far - near));
}

// Vignette efekti
float vignette(vec2 uv) {
    vec2 centered = uv * 3.0 - 1.5;
    return 1.0 - dot(centered, centered) * 0.2;
}

// Noise fonksiyonu
float noise(vec2 p) {
    return fract(sin(dot(p, vec2(12.9898, 78.233))) * 40000758.5453);
}

void main() {
    vec2 uv = texcoord;
    vec4 color = texture2D(colortex0, uv);
    
    // Derinlik değerini al
    float depth = texture2D(depthtex0, uv).r;
    float linearDepth = linearizeDepth(depth);
    
    // Mesafeyi hesapla (0.0 = yakın, 1.0 = uzak)
    float dist = linearDepth;
    
    // Görüş mesafesi ayarları (daha agresif)
    float nearDist = 0.0002;    // Çok yakın (net görüş)
    float farDist = 0.08;     // Uzak (tamamen karanlık)
    
    // Mesafeye göre karartma - çok agresif
    float darkness = smoothstep(nearDist, farDist, dist);
    
    // Sky için özel kontrol (depth = 1.0)
    if (depth > 0.9999) {
        darkness = 1; // Gökyüzü her zaman karanlık
    }
    
    // Creepy titreşim efekti
    float flicker = sin(frameTimeCounter * 2.0 + noise(uv * 50.0) * 10.0) * 0.5 + 0.97;
    
    // Vignette
    float vig = vignette(uv);
    
    // Pulse efekti (kalp atışı gibi)
    float pulse = sin(frameTimeCounter * 5.0) * 0.05 + 0.95;
    
    // Karanlık alanlar için noise
    float darkNoise = noise(uv * 100.0 + frameTimeCounter * 0.5) * 0.02;
    
    // Final renk hesaplama
    vec3 finalColor = color.rgb;
    
    // Yakın alan: normal + efektler
    // Uzak alan: tamamen karanlık
    finalColor /= (1.5 - darkness) * vig * flicker * pulse;
    
    // Uzaktaki şeyler için kırmızımsı cursed renk
    vec3 cursedColor = vec3(0.1, 0.0, 0.05) + darkNoise;
    finalColor = mix(finalColor, cursedColor, darkness);
    
    gl_FragColor = vec4(finalColor, 1.5);
}