#version 120

uniform sampler2D texture;

varying vec4 texcoord;
varying vec4 color;
varying vec3 normal;
varying vec3 viewPos;

void main() {
    vec4 texColor = texture2D(texture, texcoord.st);
    vec4 finalColor = texColor * color;
    
    // Normal lighting hesaplama
    float lighting = max(dot(normal, normalize(vec3(0.5, 1.0, 0.3))), 0.3);
    finalColor.rgb *= lighting;
    
    gl_FragData[0] = finalColor;
    gl_FragData[1] = vec4(normal * 0.5 + 0.5, 1.0);
    gl_FragData[2] = vec4(viewPos, 1.0);
}