
# uses macros to control various levels of the enchantment
# macros are slow_fall,grav_descend,delay_predicate,descend_score,height_predicate,levitation,ascend_score,hover_score

# Calculates flight time and removes durability when one dura worth has been flown
# additional dura remove in jetpack_ench_tick for hitting 0
execute if data entity @s active_effects[{id:"minecraft:levitation"}] run scoreboard players add @s talon_jetpack_flight_time 1
execute if score @s talon_jetpack_flight_time >= @s talon_max_jetpack if data entity @s equipment.chest.components.minecraft:enchantments{"minecraft:unbreaking":3} unless predicate {"condition":"random_chance","chance":0.75} run tag @s add talon_jetpack_dura_remove
execute if score @s talon_jetpack_flight_time >= @s talon_max_jetpack if data entity @s equipment.chest.components.minecraft:enchantments{"minecraft:unbreaking":2} unless predicate {"condition":"random_chance","chance":0.67} run tag @s add talon_jetpack_dura_remove
execute if score @s talon_jetpack_flight_time >= @s talon_max_jetpack if data entity @s equipment.chest.components.minecraft:enchantments{"minecraft:unbreaking":1} unless predicate {"condition":"random_chance","chance":0.5} run tag @s add talon_jetpack_dura_remove
execute if score @s talon_jetpack_flight_time >= @s talon_max_jetpack unless data entity @s equipment.chest.components.minecraft:enchantments."minecraft:unbreaking" run tag @s add talon_jetpack_dura_remove
execute if score @s talon_jetpack_flight_time >= @s talon_max_jetpack run scoreboard players set @s talon_jetpack_flight_time 0

# When pressing the sneak button, gently floats down
#BUG: not removing score when shifting down
$execute if predicate talon_jetpack:is_holding_sneak if score @s[tag=!talon_jetpack_pre_hover_on] talon_jetpack matches $(descend_score).. run effect give @s slow_falling 1 $(slow_fall) true
$execute if predicate talon_jetpack:is_holding_sneak unless data entity @s attributes[{id:"minecraft:gravity"}].modifiers[{id:"minecraft:talon_jetpack_descend"}] if score @s[tag=!talon_jetpack_pre_hover_on] talon_jetpack matches $(ascend_score).. run attribute @s gravity modifier add talon_jetpack_descend $(grav_descend) add_value
$execute if predicate talon_jetpack:is_holding_sneak if data entity @s attributes[{id:"minecraft:gravity"}].modifiers[{id:"minecraft:talon_jetpack_descend"}] if score @s[tag=!talon_jetpack_pre_hover_on] talon_jetpack matches 1.. if predicate $(delay_predicate) run scoreboard players remove @s talon_jetpack $(descend_score)
execute unless predicate talon_jetpack:is_holding_sneak if data entity @s attributes[{id:"minecraft:gravity"}].modifiers[{id:"minecraft:talon_jetpack_descend"}] run attribute @s gravity modifier remove talon_jetpack_descend

# When pressing jump, ascends; levitation allows to save self when falling which gravity attrib can't do
$execute if predicate talon_jetpack:is_holding_jump unless predicate $(height_predicate) unless data entity @s attributes[{id:"minecraft:gravity"}].modifiers[{id:"minecraft:talon_jetpack"}] if score @s[tag=!talon_jetpack_pre_hover_on] talon_jetpack matches $(ascend_score).. run effect give @s levitation 1 $(levitate) false
$execute if predicate talon_jetpack:is_holding_jump unless predicate $(height_predicate) unless data entity @s attributes[{id:"minecraft:gravity"}].modifiers[{id:"minecraft:talon_jetpack"}] if score @s[tag=!talon_jetpack_pre_hover_on] talon_jetpack matches 1.. if predicate $(delay_predicate) run scoreboard players remove @s talon_jetpack $(ascend_score)
execute unless predicate talon_jetpack:is_holding_jump run effect clear @s levitation

# When holding jump and sneak, toggles hover mode (when button is released)
# remove hover mode if too high
$execute positioned ~ ~-1 ~ if block ~ ~ ~ #replaceable if predicate $(height_predicate) run playsound minecraft:entity.zombie_villager.converted player @s ~ ~ ~ 0.8 0.85 0.8
$execute positioned ~ ~-1 ~ if block ~ ~ ~ #replaceable if predicate $(height_predicate) run attribute @s gravity modifier remove minecraft:talon_jetpack_hover
# if hovering, remove some fuel
$execute if data entity @s attributes[{id:"minecraft:gravity"}].modifiers[{id:"minecraft:talon_jetpack_hover"}] if score @s talon_jetpack matches 1.. if predicate $(delay_predicate) run scoreboard players remove @s talon_jetpack $(hover_score)
# if hovering with Shulker Lift IV add fuel back if motionless
$execute if data entity @s equipment.chest.components.minecraft:enchantments{"talon_jetpack:jetpack":4} if data entity @s attributes[{id:"minecraft:gravity"}].modifiers[{id:"minecraft:talon_jetpack_hover"}] if score @s talon_jetpack matches 1.. if predicate $(delay_predicate) if predicate talon_jetpack:not_moving run scoreboard players add @s talon_jetpack 1
# clean up scoreboard for actionbar display
execute if score @s talon_jetpack matches ..0 run scoreboard players set @s talon_jetpack 0
# hover display
$execute if data entity @s attributes[{id:"minecraft:gravity"}].modifiers[{id:"minecraft:talon_jetpack_hover"}] if predicate $(delay_predicate) run title @s actionbar [{"text":"[","color":"gray"},{"text":"Hovering","color":"green"},{"text":"]","color":"gray"},{"text":" - Flight Time [","color":"gray"},{"score":{"name":"@s","objective":"talon_jetpack"},"color":"green","bold":true},{"text":"]","color":"gray"}]
$execute unless data entity @s attributes[{id:"minecraft:gravity"}].modifiers[{id:"minecraft:talon_jetpack_hover"}] if predicate $(delay_predicate) run title @s actionbar [{"text":"[","color":"gray"},{"text":"Hovering","color":"red"},{"text":"]","color":"gray"},{"text":" - Flight Time [","color":"gray"},{"score":{"name":"@s","objective":"talon_jetpack"},"color":"green","bold":true},{"text":"]","color":"gray"}]
# sets tag to track when jump and sneak are not both pressed
# toggle on
$execute if predicate talon_jetpack:is_holding_jump_sneak unless predicate $(height_predicate) unless data entity @s attributes[{id:"minecraft:gravity"}].modifiers[{id:"minecraft:talon_jetpack_hover"}] if score @s talon_jetpack matches $(hover_score).. run return run tag @s[tag=!talon_jetpack_pre_hover_on] add talon_jetpack_pre_hover_on
$execute if entity @s[tag=talon_jetpack_pre_hover_on] unless predicate talon_jetpack:is_holding_jump_sneak unless predicate $(height_predicate) unless data entity @s attributes[{id:"minecraft:gravity"}].modifiers[{id:"minecraft:talon_jetpack_hover"}] if score @s talon_jetpack matches $(hover_score).. run playsound minecraft:entity.zombie_villager.converted player @s ~ ~ ~ 0.8 1.3 0.8
$execute if entity @s[tag=talon_jetpack_pre_hover_on] unless predicate talon_jetpack:is_holding_jump_sneak unless predicate $(height_predicate) unless data entity @s attributes[{id:"minecraft:gravity"}].modifiers[{id:"minecraft:talon_jetpack_hover"}] if score @s talon_jetpack matches $(hover_score).. run attribute @s gravity modifier add talon_jetpack_hover -0.08 add_value
# kills momentum by swapping from spect to survival mode (tp @s @s also works but is jarring) only works in survival mode
$execute if entity @s[tag=talon_jetpack_pre_hover_on,gamemode=survival] unless predicate talon_jetpack:is_holding_jump_sneak unless predicate $(height_predicate) if score @s talon_jetpack matches $(hover_score).. run gamemode spectator @s
$execute if entity @s[tag=talon_jetpack_pre_hover_on,gamemode=spectator] unless predicate talon_jetpack:is_holding_jump_sneak unless predicate $(height_predicate) if score @s talon_jetpack matches $(hover_score).. run gamemode survival @s
execute if data entity @s[tag=talon_jetpack_pre_hover_on] attributes[{id:"minecraft:gravity"}].modifiers[{id:"minecraft:talon_jetpack_hover"}] if predicate talon_jetpack:not_holding_jump_sneak run tag @s remove talon_jetpack_pre_hover_on
# toggle off
execute if predicate talon_jetpack:is_holding_jump_sneak if data entity @s attributes[{id:"minecraft:gravity"}].modifiers[{id:"minecraft:talon_jetpack_hover"}] run return run tag @s[tag=!talon_jetpack_pre_hover_off] add talon_jetpack_pre_hover_off
execute if entity @s[tag=talon_jetpack_pre_hover_off] unless predicate talon_jetpack:is_holding_jump_sneak if data entity @s attributes[{id:"minecraft:gravity"}].modifiers[{id:"minecraft:talon_jetpack_hover"}] run playsound minecraft:entity.zombie_villager.converted player @s ~ ~ ~ 0.8 0.85 0.8
execute if entity @s[tag=talon_jetpack_pre_hover_off] unless predicate talon_jetpack:is_holding_jump_sneak if data entity @s attributes[{id:"minecraft:gravity"}].modifiers[{id:"minecraft:talon_jetpack_hover"}] run attribute @s gravity modifier remove talon_jetpack_hover
execute if entity @s[tag=talon_jetpack_pre_hover_off] unless data entity @s attributes[{id:"minecraft:gravity"}].modifiers[{id:"minecraft:talon_jetpack_hover"}] unless predicate talon_jetpack:is_holding_jump_sneak run return run tag @s remove talon_jetpack_pre_hover_off

# Random sounds
execute if predicate talon_jetpack:is_holding_sneak if predicate {"condition":"random_chance","chance":0.1} run playsound minecraft:block.conduit.ambient player @a[distance=..12] ~ ~ ~ 1 1.1 1
execute if predicate talon_jetpack:is_holding_sneak if predicate {"condition":"random_chance","chance":0.1} run particle minecraft:end_rod ~ ~ ~ 1 1 1 0.06 4
execute if predicate talon_jetpack:is_holding_jump if predicate {"condition":"random_chance","chance":0.1} run playsound minecraft:block.conduit.ambient player @a[distance=..12] ~ ~ ~ 0.9 1.3 0.9
execute if predicate talon_jetpack:is_holding_jump if predicate {"condition":"random_chance","chance":0.1} run particle minecraft:end_rod ~ ~ ~ 1 1 1 0.05 3
execute if predicate talon_jetpack:is_holding_jump if predicate {"condition":"random_chance","chance":0.1}
execute if data entity @s attributes[{id:"minecraft:gravity"}].modifiers[{id:"minecraft:talon_jetpack_hover"}] if predicate {"condition":"random_chance","chance":0.1} run playsound minecraft:block.conduit.ambient player @a[distance=..12] ~ ~ ~ 0.8 1.6 0.8
execute if data entity @s attributes[{id:"minecraft:gravity"}].modifiers[{id:"minecraft:talon_jetpack_hover"}] if predicate {"condition":"random_chance","chance":0.15} run particle minecraft:end_rod ~ ~ ~ 1 1 1 0.01 2

# Height limit warning message
$execute positioned ~ ~-1 ~ if block ~ ~ ~ #replaceable if predicate $(height_predicate) run title @s actionbar [{"text":"Warning: too high above ground!","color":"red"}]