/*
 * Decompiled with CFR 0.152.
 */
package me.dralle.shop;

import java.util.ArrayList;
import java.util.List;
import me.dralle.shop.ShopPlugin;
import org.bukkit.ChatColor;
import org.bukkit.configuration.file.FileConfiguration;

public class MessageManager {
    private final ShopPlugin plugin;

    public MessageManager(ShopPlugin plugin) {
        this.plugin = plugin;
    }

    public String getMessage(String path) {
        FileConfiguration cfg = this.plugin.getMessagesConfig();
        String raw = cfg.getString("messages." + path);
        if (raw == null) {
            return "";
        }
        raw = raw.replace("%prefix%", this.getRaw("prefix"));
        return this.color(raw);
    }

    private String getRaw(String path) {
        return this.plugin.getMessagesConfig().getString("messages." + path, "");
    }

    public String getGuiString(String path, String def) {
        return this.color(this.plugin.getGuiConfig().getString("gui." + path, def));
    }

    public List<String> getGuiStringList(String path) {
        List raw = this.plugin.getGuiConfig().getStringList("gui." + path);
        ArrayList<String> out = new ArrayList<String>();
        for (String line : raw) {
            line = line.replace("%prefix%", this.getRaw("prefix"));
            out.add(this.color(line));
        }
        return out;
    }

    public String color(String s) {
        if (s == null) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)s);
    }
}

