/*
 * Decompiled with CFR 0.152.
 */
package me.dralle.shop;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import me.dralle.shop.ShopPlugin;
import me.dralle.shop.model.ShopData;
import me.dralle.shop.model.ShopItem;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.FileConfiguration;

public class ShopManager {
    private final Map<String, ShopData> shops = new LinkedHashMap<String, ShopData>();

    public ShopManager(ShopPlugin plugin) {
        FileConfiguration shopsCfg = plugin.getShopsConfig();
        ConfigurationSection root = shopsCfg.getConfigurationSection("shops");
        if (root == null) {
            if (plugin.getConfig().getBoolean("debug", false)) {
                plugin.getLogger().warning("[Genius-Shop] No 'shops' section found in shops.yml");
            }
            return;
        }
        for (String key : root.getKeys(false)) {
            ConfigurationSection shopSec = root.getConfigurationSection(key);
            if (shopSec == null) continue;
            String guiName = shopSec.getString("gui-name", "&8Shop");
            int rows = shopSec.getInt("rows", 4);
            String permission = shopSec.getString("permission", null);
            ArrayList<ShopItem> items = new ArrayList<ShopItem>();
            List rawItems = shopSec.getList("items");
            if (rawItems != null) {
                for (Object o : rawItems) {
                    Material material;
                    Map map;
                    String matName;
                    if (!(o instanceof Map) || (matName = (String)(map = (Map)o).get("material")) == null || (material = Material.matchMaterial((String)matName)) == null) continue;
                    double price = 0.0;
                    Object priceObj = map.get("price");
                    if (priceObj instanceof Number) {
                        price = ((Number)priceObj).doubleValue();
                    }
                    int amount = 1;
                    Object amountObj = map.get("amount");
                    if (amountObj instanceof Number) {
                        amount = ((Number)amountObj).intValue();
                    }
                    String spawnerType = (String)map.get("spawner-type");
                    String name = (String)map.get("name");
                    if (name == null) {
                        name = (String)map.get("display-name");
                    }
                    ArrayList<String> lore = new ArrayList<String>();
                    Object loreObj = map.get("lore");
                    if (loreObj instanceof List) {
                        for (Object line : (List)loreObj) {
                            if (line == null) continue;
                            lore.add(line.toString());
                        }
                    }
                    Double sellPrice = null;
                    Object sellObj = map.get("sell-price");
                    if (sellObj instanceof Number) {
                        sellPrice = ((Number)sellObj).doubleValue();
                    }
                    boolean hideAttributes = this.getBoolean(map, "hide-attributes", false);
                    boolean hideAdditional = this.getBoolean(map, "hide-additional", false);
                    items.add(new ShopItem(material, price, amount, spawnerType, name, lore, sellPrice, hideAttributes, hideAdditional));
                }
            }
            this.shops.put(key, new ShopData(key, guiName, rows, items, permission));
        }
    }

    private boolean getBoolean(Map<String, Object> map, String key, boolean def) {
        Object o = map.get(key);
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        if (o instanceof String) {
            return Boolean.parseBoolean((String)o);
        }
        return def;
    }

    public ShopData getShop(String key) {
        return this.shops.get(key);
    }

    public Set<String> getShopKeys() {
        return this.shops.keySet();
    }
}

