/*
 * Decompiled with CFR 0.152.
 */
package me.dralle.shop;

import java.io.File;
import java.io.IOException;
import me.dralle.shop.MessageManager;
import me.dralle.shop.ShopManager;
import me.dralle.shop.economy.EconomyHook;
import me.dralle.shop.gui.GenericShopGui;
import me.dralle.shop.gui.MainMenu;
import me.dralle.shop.gui.PurchaseMenu;
import me.dralle.shop.gui.SellMenu;
import me.dralle.shop.metrics.Metrics;
import me.dralle.shop.util.ConfigUpdater;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class ShopPlugin
extends JavaPlugin {
    private static ShopPlugin instance;
    private FileConfiguration messagesConfig;
    private FileConfiguration guiConfig;
    private FileConfiguration shopsConfig;
    private MessageManager messages;
    private ShopManager shopManager;
    private GenericShopGui genericShopGui;
    private EconomyHook economy;

    public static ShopPlugin getInstance() {
        return instance;
    }

    public void onEnable() {
        instance = this;
        if (!this.getDataFolder().exists()) {
            this.getDataFolder().mkdirs();
        }
        this.saveDefaultConfig();
        this.saveDefaultResourceIfNotExists("messages.yml");
        this.saveDefaultResourceIfNotExists("gui.yml");
        this.saveDefaultResourceIfNotExists("shops.yml");
        ConfigUpdater.update(this, "config.yml");
        ConfigUpdater.update(this, "messages.yml");
        ConfigUpdater.update(this, "gui.yml");
        ConfigUpdater.update(this, "shops.yml");
        this.reloadAllConfigs();
        this.messages = new MessageManager(this);
        this.shopManager = new ShopManager(this);
        this.economy = new EconomyHook(this);
        this.genericShopGui = new GenericShopGui(this);
        this.getServer().getPluginManager().registerEvents((Listener)new MainMenu(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)this.genericShopGui, (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PurchaseMenu(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new SellMenu(this), (Plugin)this);
        this.getCommand("shop").setExecutor((sender, cmd, label, args) -> {
            if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
                if (!sender.hasPermission("geniusshop.reload") && !sender.hasPermission("shop.admin")) {
                    sender.sendMessage(this.getMessages().getMessage("reload-no-permission"));
                    return true;
                }
                try {
                    this.reloadPlugin();
                    sender.sendMessage(this.getMessages().getMessage("reload-success"));
                }
                catch (Exception ex) {
                    sender.sendMessage(this.getMessages().getMessage("reload-failed"));
                    ex.printStackTrace();
                }
                return true;
            }
            if (!(sender instanceof Player)) {
                sender.sendMessage(this.getMessages().getMessage("player-only"));
                return true;
            }
            Player p = (Player)sender;
            MainMenu.open(p);
            return true;
        });
        if (this.getConfig().getBoolean("enable-metrics", true)) {
            try {
                int pluginId = 27943;
                new Metrics((Plugin)this, pluginId);
                this.getLogger().info("Genius-Shop metrics enabled.");
            }
            catch (Throwable t) {
                this.getLogger().warning("Could not start bStats metrics: " + t.getMessage());
            }
        }
        this.getLogger().info("Genius-Shop enabled.");
    }

    public void onDisable() {
        try {
            this.getMessagesConfig().save(new File(this.getDataFolder(), "messages.yml"));
            this.getGuiConfig().save(new File(this.getDataFolder(), "gui.yml"));
            this.getShopsConfig().save(new File(this.getDataFolder(), "shops.yml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void saveDefaultResourceIfNotExists(String name) {
        File f = new File(this.getDataFolder(), name);
        if (!f.exists()) {
            this.saveResource(name, false);
        }
    }

    public void reloadPlugin() {
        ConfigUpdater.update(this, "config.yml");
        ConfigUpdater.update(this, "messages.yml");
        ConfigUpdater.update(this, "gui.yml");
        ConfigUpdater.update(this, "shops.yml");
        this.reloadAllConfigs();
        this.messages = new MessageManager(this);
        this.shopManager = new ShopManager(this);
        this.economy = new EconomyHook(this);
        this.getLogger().info("Genius-Shop reloaded from disk.");
    }

    public void reloadAllConfigs() {
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "messages.yml"));
        this.guiConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "gui.yml"));
        this.shopsConfig = YamlConfiguration.loadConfiguration((File)new File(this.getDataFolder(), "shops.yml"));
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }

    public FileConfiguration getGuiConfig() {
        return this.guiConfig;
    }

    public FileConfiguration getShopsConfig() {
        return this.shopsConfig;
    }

    public MessageManager getMessages() {
        return this.messages;
    }

    public ShopManager getShopManager() {
        return this.shopManager;
    }

    public GenericShopGui getGenericShopGui() {
        return this.genericShopGui;
    }

    public EconomyHook getEconomy() {
        return this.economy;
    }
}

