/*
 * Decompiled with CFR 0.152.
 */
package me.dralle.shop.economy;

import me.dralle.shop.ShopPlugin;
import net.milkbowl.vault.economy.Economy;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.RegisteredServiceProvider;

public class EconomyHook {
    private final ShopPlugin plugin;
    private Economy economy;

    public EconomyHook(ShopPlugin plugin) {
        this.plugin = plugin;
        this.setupEconomy();
    }

    private void setupEconomy() {
        if (this.plugin.getServer().getPluginManager().getPlugin("Vault") == null) {
            this.plugin.getLogger().warning("[Genius-Shop] Vault not found. Economy features disabled.");
            return;
        }
        RegisteredServiceProvider rsp = Bukkit.getServicesManager().getRegistration(Economy.class);
        if (rsp == null) {
            this.plugin.getLogger().warning("[Genius-Shop] No Economy provider found via Vault.");
            return;
        }
        this.economy = (Economy)rsp.getProvider();
        this.plugin.getLogger().info("[Genius-Shop] Hooked into economy: " + this.economy.getName());
    }

    public boolean isReady() {
        return this.economy != null;
    }

    public double getBalance(Player player) {
        if (!this.isReady()) {
            return 0.0;
        }
        return this.economy.getBalance((OfflinePlayer)player);
    }

    public boolean withdraw(Player player, double amount) {
        if (!this.isReady()) {
            return false;
        }
        return this.economy.withdrawPlayer((OfflinePlayer)player, amount).transactionSuccess();
    }

    public void deposit(Player player, double amount) {
        if (!this.isReady()) {
            return;
        }
        this.economy.depositPlayer((OfflinePlayer)player, amount);
    }
}

