/*
 * Decompiled with CFR 0.152.
 */
package me.dralle.shop.gui;

import java.util.ArrayList;
import java.util.List;
import me.dralle.shop.ShopPlugin;
import me.dralle.shop.gui.MainMenu;
import me.dralle.shop.gui.PurchaseMenu;
import me.dralle.shop.gui.SellMenu;
import me.dralle.shop.model.ShopData;
import me.dralle.shop.model.ShopItem;
import me.dralle.shop.util.ItemUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class GenericShopGui
implements Listener {
    private final ShopPlugin plugin;

    public GenericShopGui(ShopPlugin plugin) {
        this.plugin = plugin;
    }

    public void openShop(Player player, String shopKey, int page) {
        List<ShopItem> allItems;
        ShopData shop = this.plugin.getShopManager().getShop(shopKey);
        if (shop == null) {
            player.sendMessage(this.plugin.getMessages().getMessage("shop-does-not-exist").replace("%shop%", shopKey));
            return;
        }
        String cleanShopName = ItemUtil.stripColor(shop.getGuiName());
        String perm = shop.getPermission();
        if (perm != null && !perm.isEmpty() && !player.hasPermission(perm)) {
            player.sendMessage(this.plugin.getMessages().getMessage("shop-no-permission").replace("%shop%", cleanShopName));
            return;
        }
        int configuredRows = shop.getRows();
        int usableRows = Math.max(configuredRows, 1);
        int totalRows = usableRows + 1;
        if (totalRows > 6) {
            totalRows = 6;
        }
        int totalSlots = totalRows * 9;
        int usableSlots = usableRows * 9;
        if (usableSlots > 45) {
            usableSlots = 45;
        }
        if ((allItems = shop.getItems()) == null || allItems.isEmpty()) {
            player.sendMessage(this.plugin.getMessages().getMessage("shop-no-items"));
            return;
        }
        int totalPages = (int)Math.ceil((double)allItems.size() / (double)usableSlots);
        if (totalPages < 1) {
            totalPages = 1;
        }
        if (page < 1) {
            page = 1;
        }
        if (page > totalPages) {
            page = totalPages;
        }
        String title = ItemUtil.color(shop.getGuiName() + " &7(" + page + "/" + totalPages + ")");
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)totalSlots, (String)title);
        FileConfiguration gui = this.plugin.getGuiConfig();
        String backName = ItemUtil.color(gui.getString("gui.navigation.back-name", "&9&lBack to Categories"));
        List<String> backLore = this.colorList(gui.getStringList("gui.navigation.back-lore"));
        String prevName = ItemUtil.color(gui.getString("gui.navigation.prev-name", "&e&l<- Previous Page"));
        List<String> prevLore = this.colorList(gui.getStringList("gui.navigation.prev-lore"));
        String nextName = ItemUtil.color(gui.getString("gui.navigation.next-name", "&e&lNext Page ->"));
        List<String> nextLore = this.colorList(gui.getStringList("gui.navigation.next-lore"));
        String hintBoth = ItemUtil.color(gui.getString("gui.hints.both", "&8(L-Click to Buy, R-Click to Sell)"));
        String hintBuy = ItemUtil.color(gui.getString("gui.hints.buy", "&8(L-Click to Buy)"));
        String hintSell = ItemUtil.color(gui.getString("gui.hints.sell", "&8(R-Click to Sell)"));
        int startIndex = (page - 1) * usableSlots;
        int endIndex = Math.min(startIndex + usableSlots, allItems.size());
        int slotIndex = 0;
        for (int i = startIndex; i < endIndex; ++i) {
            ItemMeta meta;
            ShopItem si = allItems.get(i);
            ArrayList<String> lore = new ArrayList<String>();
            lore.add("");
            Double buy = si.getPrice();
            Double sell = si.getSellPrice();
            if (buy != null && buy > 0.0) {
                lore.add(ItemUtil.color("&6Buy Price: &a$" + buy));
            }
            if (sell != null && sell > 0.0) {
                lore.add(ItemUtil.color("&cSell Price: &a$" + sell));
            }
            if (si.getSpawnerType() != null && !si.getSpawnerType().isEmpty()) {
                lore.add(ItemUtil.color("&7Spawner Type: &e" + si.getSpawnerType()));
            }
            if (buy != null && buy > 0.0 && sell != null && sell > 0.0) {
                lore.add(hintBoth);
            } else if (buy != null && buy > 0.0) {
                lore.add(hintBuy);
            } else if (sell != null && sell > 0.0) {
                lore.add(hintSell);
            }
            lore.add("");
            int slot = slotIndex++;
            if (slot >= usableSlots) continue;
            ItemStack stack = ItemUtil.create(si.getMaterial(), si.getAmount(), si.getName(), lore);
            if ((si.isHideAttributes() || si.isHideAdditional()) && (meta = stack.getItemMeta()) != null) {
                if (si.isHideAttributes()) {
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ATTRIBUTES});
                }
                if (si.isHideAdditional()) {
                    meta.addItemFlags(new ItemFlag[]{ItemFlag.HIDE_ADDITIONAL_TOOLTIP});
                }
                stack.setItemMeta(meta);
            }
            inv.setItem(slot, stack);
        }
        int bottomRowStart = totalSlots - 9;
        int backSlot = bottomRowStart + 4;
        int prevSlot = bottomRowStart + 3;
        int nextSlot = bottomRowStart + 5;
        inv.setItem(backSlot, ItemUtil.create(Material.ENDER_CHEST, 1, backName, backLore));
        if (page > 1) {
            inv.setItem(prevSlot, ItemUtil.create(Material.ARROW, 1, prevName, prevLore));
        }
        if (page < totalPages) {
            inv.setItem(nextSlot, ItemUtil.create(Material.ARROW, 1, nextName, nextLore));
        }
        player.openInventory(inv);
        player.setMetadata("shop.current", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)shopKey));
        player.setMetadata("shop.page", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)page));
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getWhoClicked();
        if (!player.hasMetadata("shop.current") || !player.hasMetadata("shop.page")) {
            return;
        }
        String shopKey = ((MetadataValue)player.getMetadata("shop.current").get(0)).asString();
        ShopData shop = this.plugin.getShopManager().getShop(shopKey);
        if (shop == null) {
            return;
        }
        String expectedTitlePart = ItemUtil.color(shop.getGuiName());
        String actualTitle = e.getView().getTitle();
        if (actualTitle == null || !actualTitle.contains(ItemUtil.stripColor(expectedTitlePart))) {
            return;
        }
        e.setCancelled(true);
        ItemStack clicked = e.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        int page = ((MetadataValue)player.getMetadata("shop.page").get(0)).asInt();
        int configuredRows = shop.getRows();
        int usableRows = Math.max(configuredRows, 1);
        int totalRows = usableRows + 1;
        if (totalRows > 6) {
            totalRows = 6;
        }
        int totalSlots = totalRows * 9;
        int usableSlots = usableRows * 9;
        if (usableSlots > 45) {
            usableSlots = 45;
        }
        int bottomRowStart = totalSlots - 9;
        int prevSlot = bottomRowStart + 3;
        int backSlot = bottomRowStart + 4;
        int nextSlot = bottomRowStart + 5;
        int slot = e.getSlot();
        int totalPages = (int)Math.ceil((double)shop.getItems().size() / (double)usableSlots);
        FileConfiguration gui = this.plugin.getGuiConfig();
        String backName = ItemUtil.color(gui.getString("gui.navigation.back-name", "&9&lBack to Categories"));
        String prevName = ItemUtil.color(gui.getString("gui.navigation.prev-name", "&e&l<- Previous Page"));
        String nextName = ItemUtil.color(gui.getString("gui.navigation.next-name", "&e&lNext Page ->"));
        if (slot == backSlot && clicked.getType() == Material.ENDER_CHEST && this.hasName(clicked, backName)) {
            MainMenu.open(player);
            return;
        }
        if (slot == prevSlot && clicked.getType() == Material.ARROW && this.hasName(clicked, prevName) && page > 1) {
            this.openShop(player, shopKey, page - 1);
            return;
        }
        if (slot == nextSlot && clicked.getType() == Material.ARROW && this.hasName(clicked, nextName) && page < totalPages) {
            this.openShop(player, shopKey, page + 1);
            return;
        }
        if (slot >= bottomRowStart) {
            return;
        }
        int startIndex = (page - 1) * usableSlots;
        int itemIndex = startIndex + slot;
        if (itemIndex < 0 || itemIndex >= shop.getItems().size()) {
            return;
        }
        ShopItem shopItem = shop.getItems().get(itemIndex);
        Double buyPrice = shopItem.getPrice();
        Double sellPrice = shopItem.getSellPrice();
        if (e.getClick() == ClickType.RIGHT) {
            if (sellPrice != null && sellPrice > 0.0) {
                SellMenu.open(player, shopItem);
            } else {
                player.sendMessage(this.plugin.getMessages().getMessage("cannot-sell"));
            }
            return;
        }
        if (e.getClick() == ClickType.LEFT) {
            if (buyPrice != null && buyPrice > 0.0) {
                PurchaseMenu.open(player, shopItem);
            } else {
                player.sendMessage(this.plugin.getMessages().getMessage("cannot-buy"));
            }
        }
    }

    private boolean hasName(ItemStack item, String expected) {
        if (!item.hasItemMeta()) {
            return false;
        }
        ItemMeta meta = item.getItemMeta();
        if (!meta.hasDisplayName()) {
            return false;
        }
        return meta.getDisplayName().equals(expected);
    }

    private List<String> colorList(List<String> raw) {
        ArrayList<String> out = new ArrayList<String>();
        for (String s : raw) {
            out.add(ItemUtil.color(s));
        }
        return out;
    }
}

