/*
 * Decompiled with CFR 0.152.
 */
package me.dralle.shop.gui;

import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import me.dralle.shop.ShopPlugin;
import me.dralle.shop.model.ShopData;
import me.dralle.shop.util.ItemUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;

public class MainMenu
implements Listener {
    private final ShopPlugin plugin;

    public MainMenu(ShopPlugin plugin) {
        this.plugin = plugin;
    }

    public static void open(Player player) {
        ShopPlugin plugin = ShopPlugin.getInstance();
        ConfigurationSection mainSec = plugin.getGuiConfig().getConfigurationSection("gui.main");
        if (mainSec == null) {
            Inventory fallback = Bukkit.createInventory((InventoryHolder)player, (int)27, (String)ItemUtil.color("&8Shop Menu"));
            player.openInventory(fallback);
            return;
        }
        String title = plugin.getMessages().color(mainSec.getString("title", "&8Shop Menu"));
        int size = mainSec.getInt("size", 27);
        if (size < 9) {
            size = 9;
        }
        if (size > 54) {
            size = 54;
        }
        if (size % 9 != 0) {
            size = 27;
        }
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)size, (String)title);
        ConfigurationSection itemsSec = mainSec.getConfigurationSection("items");
        if (itemsSec != null) {
            for (String key : itemsSec.getKeys(false)) {
                int slot;
                ConfigurationSection itemSec = itemsSec.getConfigurationSection(key);
                if (itemSec == null || (slot = itemSec.getInt("slot", -1)) < 0 || slot >= size) continue;
                String matName = itemSec.getString("material", "BARRIER");
                Material mat = Material.matchMaterial((String)matName);
                if (mat == null) {
                    mat = Material.BARRIER;
                }
                String name = itemSec.getString("name", key);
                List loreRaw = itemSec.getStringList("lore");
                ArrayList<String> lore = new ArrayList<String>();
                for (String line : loreRaw) {
                    lore.add(plugin.getMessages().color(line));
                }
                inv.setItem(slot, ItemUtil.create(mat, 1, name, lore));
            }
        }
        player.openInventory(inv);
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getWhoClicked();
        String expectedTitle = this.plugin.getMessages().color(this.plugin.getGuiConfig().getString("gui.main.title", "&8Shop Menu"));
        if (!e.getView().getTitle().equals(expectedTitle)) {
            return;
        }
        e.setCancelled(true);
        if (e.getCurrentItem() == null) {
            return;
        }
        int clickedSlot = e.getSlot();
        ConfigurationSection mainSec = this.plugin.getGuiConfig().getConfigurationSection("gui.main");
        if (mainSec == null) {
            return;
        }
        ConfigurationSection itemsSec = mainSec.getConfigurationSection("items");
        if (itemsSec == null) {
            return;
        }
        LinkedHashMap<Integer, ConfigurationSection> slotToItem = new LinkedHashMap<Integer, ConfigurationSection>();
        for (String key : itemsSec.getKeys(false)) {
            int slot;
            ConfigurationSection itemSec = itemsSec.getConfigurationSection(key);
            if (itemSec == null || (slot = itemSec.getInt("slot", -1)) < 0) continue;
            slotToItem.put(slot, itemSec);
        }
        if (!slotToItem.containsKey(clickedSlot)) {
            return;
        }
        ConfigurationSection clickedItem = (ConfigurationSection)slotToItem.get(clickedSlot);
        String shopKey = clickedItem.getString("shop-key", null);
        if (shopKey == null || shopKey.isEmpty()) {
            return;
        }
        ShopData shop = this.plugin.getShopManager().getShop(shopKey);
        if (shop == null) {
            player.sendMessage(this.plugin.getMessages().getMessage("shop-not-found").replace("%shop%", shopKey));
            return;
        }
        String shopPermission = shop.getPermission();
        if (shopPermission != null && !shopPermission.isEmpty() && !player.hasPermission(shopPermission)) {
            String cleanName = ItemUtil.stripColor(shop.getGuiName());
            player.sendMessage(this.plugin.getMessages().getMessage("shop-no-permission").replace("%shop%", cleanName));
            return;
        }
        this.plugin.getGenericShopGui().openShop(player, shopKey, 1);
    }
}

