/*
 * Decompiled with CFR 0.152.
 */
package me.dralle.shop.gui;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import me.dralle.shop.ShopPlugin;
import me.dralle.shop.economy.EconomyHook;
import me.dralle.shop.gui.MainMenu;
import me.dralle.shop.model.ShopItem;
import me.dralle.shop.util.ItemUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.BlockState;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class PurchaseMenu
implements Listener {
    private final ShopPlugin plugin;

    public PurchaseMenu(ShopPlugin plugin) {
        this.plugin = plugin;
    }

    public static void open(Player player, ShopItem item) {
        ShopPlugin plugin = ShopPlugin.getInstance();
        if (item.getPrice() <= 0.0) {
            player.sendMessage(plugin.getMessages().getMessage("cannot-buy"));
            return;
        }
        PurchaseMenu.open(player, item.getMaterial(), item.getPrice(), item.getAmount(), item.getSpawnerType(), item.getName(), item.getLore());
    }

    public static void open(Player player, Material material, double unitPrice, int amount, String spawnerType, String customName, List<String> customLore) {
        ShopPlugin plugin = ShopPlugin.getInstance();
        if (unitPrice <= 0.0) {
            player.sendMessage(plugin.getMessages().getMessage("cannot-buy"));
            return;
        }
        String titlePrefix = plugin.getMessages().getGuiString("purchase.title-prefix", "&8Buying ");
        String title = ItemUtil.color(titlePrefix + material.name());
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)title);
        ArrayList<String> mainLore = new ArrayList<String>();
        if (customLore != null && !customLore.isEmpty()) {
            for (String line : customLore) {
                mainLore.add(ItemUtil.color(line));
            }
            mainLore.add("");
        }
        mainLore.add(ItemUtil.color("&eAmount: &7" + amount));
        mainLore.add(ItemUtil.color("&eTotal: &7$" + unitPrice * (double)amount));
        if (spawnerType != null && !spawnerType.isEmpty()) {
            mainLore.add(ItemUtil.color("&7Spawner: &e" + spawnerType));
        }
        mainLore.add("");
        String displayName = customName != null ? ItemUtil.color(customName) : null;
        inv.setItem(22, ItemUtil.create(material, amount, displayName, mainLore));
        String add1 = plugin.getMessages().getGuiString("purchase.add-1", "&aAdd 1");
        String add10 = plugin.getMessages().getGuiString("purchase.add-10", "&aAdd 10");
        String set64 = plugin.getMessages().getGuiString("purchase.set-64", "&aSet to 64");
        String rem1 = plugin.getMessages().getGuiString("purchase.remove-1", "&cRemove 1");
        String rem10 = plugin.getMessages().getGuiString("purchase.remove-10", "&cRemove 10");
        String set1 = plugin.getMessages().getGuiString("purchase.set-1", "&cSet to 1");
        String confirmName = plugin.getMessages().getGuiString("purchase.confirm-name", "&aCONFIRM PURCHASE");
        String backName = plugin.getMessages().getGuiString("purchase.back-name", "&9BACK TO CATEGORIES");
        String cancelName = plugin.getMessages().getGuiString("purchase.cancel-name", "&cCANCEL PURCHASE");
        if (amount < 64) {
            inv.setItem(24, ItemUtil.create(Material.LIME_STAINED_GLASS_PANE, 1, add1, null));
        }
        if (amount <= 54) {
            inv.setItem(25, ItemUtil.create(Material.LIME_STAINED_GLASS_PANE, 10, add10, null));
        }
        if (amount < 64) {
            inv.setItem(26, ItemUtil.create(Material.LIME_STAINED_GLASS_PANE, 64, set64, null));
        }
        if (amount > 1) {
            inv.setItem(20, ItemUtil.create(Material.RED_STAINED_GLASS_PANE, 1, rem1, null));
            inv.setItem(18, ItemUtil.create(Material.RED_STAINED_GLASS_PANE, 1, set1, null));
        }
        if (amount > 10) {
            inv.setItem(19, ItemUtil.create(Material.RED_STAINED_GLASS_PANE, 10, rem10, null));
        }
        inv.setItem(39, ItemUtil.create(Material.LIME_STAINED_GLASS, 1, confirmName, null));
        inv.setItem(40, ItemUtil.create(Material.ENDER_CHEST, 1, backName, Arrays.asList("", ItemUtil.color("&7Return to main shop."), "")));
        inv.setItem(41, ItemUtil.create(Material.RED_STAINED_GLASS, 1, cancelName, null));
        player.openInventory(inv);
        player.setMetadata("shop.unitprice", (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)unitPrice));
        player.setMetadata("shop.material", (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)material.name()));
        player.setMetadata("shop.amount", (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)amount));
        if (spawnerType != null) {
            player.setMetadata("shop.spawnerType", (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)spawnerType));
        } else {
            player.removeMetadata("shop.spawnerType", (Plugin)plugin);
        }
        if (customName != null) {
            player.setMetadata("shop.customName", (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)customName));
        } else {
            player.removeMetadata("shop.customName", (Plugin)plugin);
        }
        if (customLore != null && !customLore.isEmpty()) {
            player.setMetadata("shop.customLore", (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)String.join((CharSequence)"\n", customLore)));
        } else {
            player.removeMetadata("shop.customLore", (Plugin)plugin);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        String name;
        Material material;
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getWhoClicked();
        ShopPlugin plugin = ShopPlugin.getInstance();
        String titlePrefix = plugin.getMessages().getGuiString("purchase.title-prefix", "&8Buying ");
        if (!e.getView().getTitle().startsWith(ItemUtil.color(titlePrefix))) {
            return;
        }
        e.setCancelled(true);
        ItemStack clicked = e.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        String materialName = player.hasMetadata("shop.material") ? ((MetadataValue)player.getMetadata("shop.material").get(0)).asString() : "DIRT";
        double unitPrice = player.hasMetadata("shop.unitprice") ? ((MetadataValue)player.getMetadata("shop.unitprice").get(0)).asDouble() : 0.0;
        int amount = player.hasMetadata("shop.amount") ? ((MetadataValue)player.getMetadata("shop.amount").get(0)).asInt() : 1;
        String spawnerType = player.hasMetadata("shop.spawnerType") ? ((MetadataValue)player.getMetadata("shop.spawnerType").get(0)).asString() : null;
        String customName = player.hasMetadata("shop.customName") ? ((MetadataValue)player.getMetadata("shop.customName").get(0)).asString() : null;
        String customLorePacked = player.hasMetadata("shop.customLore") ? ((MetadataValue)player.getMetadata("shop.customLore").get(0)).asString() : null;
        List<String> customLore = null;
        if (customLorePacked != null && !customLorePacked.isEmpty()) {
            customLore = Arrays.asList(customLorePacked.split("\n"));
        }
        if ((material = Material.matchMaterial((String)materialName)) == null) {
            material = Material.DIRT;
        }
        String add1 = plugin.getMessages().getGuiString("purchase.add-1", "&aAdd 1");
        String add10 = plugin.getMessages().getGuiString("purchase.add-10", "&aAdd 10");
        String set64 = plugin.getMessages().getGuiString("purchase.set-64", "&aSet to 64");
        String rem1 = plugin.getMessages().getGuiString("purchase.remove-1", "&cRemove 1");
        String rem10 = plugin.getMessages().getGuiString("purchase.remove-10", "&cRemove 10");
        String set1 = plugin.getMessages().getGuiString("purchase.set-1", "&cSet to 1");
        String confirmName = plugin.getMessages().getGuiString("purchase.confirm-name", "&aCONFIRM PURCHASE");
        String backName = plugin.getMessages().getGuiString("purchase.back-name", "&9BACK TO CATEGORIES");
        String cancelName = plugin.getMessages().getGuiString("purchase.cancel-name", "&cCANCEL PURCHASE");
        String string = name = clicked.hasItemMeta() && clicked.getItemMeta().hasDisplayName() ? clicked.getItemMeta().getDisplayName() : "";
        if (clicked.getType() == Material.LIME_STAINED_GLASS_PANE) {
            if (name.equals(ItemUtil.color(add1))) {
                int newAmt = Math.min(amount + 1, 64);
                PurchaseMenu.open(player, material, unitPrice, newAmt, spawnerType, customName, customLore);
                return;
            }
            if (name.equals(ItemUtil.color(add10))) {
                int newAmt = Math.min(amount + 10, 64);
                PurchaseMenu.open(player, material, unitPrice, newAmt, spawnerType, customName, customLore);
                return;
            }
            if (name.equals(ItemUtil.color(set64))) {
                PurchaseMenu.open(player, material, unitPrice, 64, spawnerType, customName, customLore);
                return;
            }
        }
        if (clicked.getType() == Material.RED_STAINED_GLASS_PANE) {
            if (name.equals(ItemUtil.color(rem1))) {
                int newAmt = Math.max(1, amount - 1);
                PurchaseMenu.open(player, material, unitPrice, newAmt, spawnerType, customName, customLore);
                return;
            }
            if (name.equals(ItemUtil.color(rem10))) {
                int newAmt = Math.max(1, amount - 10);
                PurchaseMenu.open(player, material, unitPrice, newAmt, spawnerType, customName, customLore);
                return;
            }
            if (name.equals(ItemUtil.color(set1))) {
                PurchaseMenu.open(player, material, unitPrice, 1, spawnerType, customName, customLore);
                return;
            }
        }
        if (clicked.getType() == Material.LIME_STAINED_GLASS && name.equals(ItemUtil.color(confirmName))) {
            EconomyHook eco = plugin.getEconomy();
            double total = (double)amount * unitPrice;
            if (!eco.isReady()) {
                player.sendMessage(plugin.getMessages().getMessage("economy-not-ready"));
                return;
            }
            if (!eco.withdraw(player, total)) {
                player.sendMessage(plugin.getMessages().getMessage("not-enough-money").replace("%amount%", String.valueOf(amount)).replace("%item%", customName != null ? customName.replace("&", "\u00a7") : material.name()).replace("%price%", String.valueOf(total)));
                return;
            }
            this.giveItem(player, material, amount, spawnerType, customName);
            player.sendMessage(plugin.getMessages().getMessage("buy-success").replace("%amount%", String.valueOf(amount)).replace("%item%", customName != null ? customName.replace("&", "\u00a7") : material.name()).replace("%price%", String.valueOf(total)));
            player.closeInventory();
            return;
        }
        if (clicked.getType() == Material.ENDER_CHEST && name.equals(ItemUtil.color(backName))) {
            MainMenu.open(player);
            return;
        }
        if (clicked.getType() == Material.RED_STAINED_GLASS && name.equals(ItemUtil.color(cancelName))) {
            player.closeInventory();
        }
    }

    private void giveItem(Player player, Material material, int amount, String spawnerType, String customName) {
        int stackSize;
        for (int remaining = amount; remaining > 0; remaining -= stackSize) {
            HashMap leftover;
            ItemStack toGive;
            stackSize = Math.min(remaining, material.getMaxStackSize());
            if (material != Material.SPAWNER) {
                toGive = new ItemStack(material, stackSize);
                if (customName != null && !customName.isEmpty()) {
                    meta = toGive.getItemMeta();
                    meta.setDisplayName(ItemUtil.color(customName));
                    toGive.setItemMeta((ItemMeta)meta);
                }
            } else {
                toGive = new ItemStack(Material.SPAWNER, stackSize);
                meta = (BlockStateMeta)toGive.getItemMeta();
                CreatureSpawner cs = (CreatureSpawner)meta.getBlockState();
                if (spawnerType != null && !spawnerType.isEmpty()) {
                    try {
                        cs.setSpawnedType(EntityType.valueOf((String)spawnerType.toUpperCase()));
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        // empty catch block
                    }
                }
                meta.setBlockState((BlockState)cs);
                if (customName != null && !customName.isEmpty()) {
                    meta.setDisplayName(ItemUtil.color(customName));
                }
                toGive.setItemMeta((ItemMeta)meta);
            }
            if ((leftover = player.getInventory().addItem(new ItemStack[]{toGive})).isEmpty()) continue;
            leftover.values().forEach(left -> {
                if (left != null && left.getType() != Material.AIR && left.getAmount() > 0) {
                    player.getWorld().dropItemNaturally(player.getLocation(), left);
                }
            });
        }
    }
}

