/*
 * Decompiled with CFR 0.152.
 */
package me.dralle.shop.gui;

import java.util.ArrayList;
import java.util.List;
import me.dralle.shop.ShopPlugin;
import me.dralle.shop.economy.EconomyHook;
import me.dralle.shop.gui.MainMenu;
import me.dralle.shop.model.ShopItem;
import me.dralle.shop.util.ItemUtil;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.block.CreatureSpawner;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public class SellMenu
implements Listener {
    private final ShopPlugin plugin;

    public SellMenu(ShopPlugin plugin) {
        this.plugin = plugin;
    }

    public static void open(Player player, ShopItem item) {
        ShopPlugin plugin = ShopPlugin.getInstance();
        SellMenu.open(player, item.getMaterial(), item.getSellPrice(), 1, item.getSpawnerType(), item.getName(), item.getLore());
    }

    public static void open(Player player, Material material, Double sellPrice, int amount, String spawnerType, String customName, List<String> customLore) {
        ShopPlugin plugin = ShopPlugin.getInstance();
        if (sellPrice == null) {
            player.sendMessage(plugin.getMessages().getMessage("cannot-sell"));
            return;
        }
        FileConfiguration guiCfg = plugin.getGuiConfig();
        String titlePrefix = plugin.getMessages().getGuiString("sell.title-prefix", "&8Selling ");
        String title = ItemUtil.color(titlePrefix + material.name());
        Inventory inv = Bukkit.createInventory((InventoryHolder)player, (int)54, (String)title);
        int owned = SellMenu.countPlayerItems(player, material, spawnerType);
        if (amount > owned) {
            amount = owned;
        }
        ArrayList<String> mainLore = new ArrayList<String>();
        if (customLore != null && !customLore.isEmpty()) {
            for (String line : customLore) {
                mainLore.add(ItemUtil.color(line));
            }
            mainLore.add("");
        }
        mainLore.add(ItemUtil.color("&eSelected amount: &7" + amount));
        mainLore.add(ItemUtil.color("&eSell price: &7$" + sellPrice));
        mainLore.add(ItemUtil.color("&eYou own: &7" + owned));
        if (spawnerType != null && !spawnerType.isEmpty()) {
            mainLore.add(ItemUtil.color("&7Spawner: &e" + spawnerType));
        }
        mainLore.add("");
        String displayName = customName != null ? ItemUtil.color(customName) : null;
        inv.setItem(22, ItemUtil.create(material, amount > 0 ? amount : 1, displayName, mainLore));
        String add1 = plugin.getMessages().getGuiString("sell.add-1", "&aAdd 1");
        String add10 = plugin.getMessages().getGuiString("sell.add-10", "&aAdd 10");
        String set64 = plugin.getMessages().getGuiString("sell.set-64", "&aSet to 64");
        String rem1 = plugin.getMessages().getGuiString("sell.remove-1", "&cRemove 1");
        String rem10 = plugin.getMessages().getGuiString("sell.remove-10", "&cRemove 10");
        String set1 = plugin.getMessages().getGuiString("sell.set-1", "&cSet to 1");
        String confirmName = plugin.getMessages().getGuiString("sell.confirm-name", "&aCONFIRM SELL");
        String sellAllName = plugin.getMessages().getGuiString("sell.sell-all-name", "&6SELL ALL");
        String backName = plugin.getMessages().getGuiString("sell.back-name", "&9BACK TO CATEGORIES");
        String cancelName = plugin.getMessages().getGuiString("sell.cancel-name", "&cCANCEL");
        int sellAllSlot = guiCfg.getInt("gui.sell.sell-all-slot", 38);
        if (sellAllSlot < 0) {
            sellAllSlot = 0;
        }
        if (sellAllSlot > 53) {
            sellAllSlot = 53;
        }
        if (amount < owned) {
            inv.setItem(24, ItemUtil.create(Material.LIME_STAINED_GLASS_PANE, 1, add1, null));
            inv.setItem(25, ItemUtil.create(Material.LIME_STAINED_GLASS_PANE, 10, add10, null));
            inv.setItem(26, ItemUtil.create(Material.LIME_STAINED_GLASS_PANE, 64, set64, null));
        }
        if (amount > 1) {
            inv.setItem(20, ItemUtil.create(Material.RED_STAINED_GLASS_PANE, 1, rem1, null));
            inv.setItem(19, ItemUtil.create(Material.RED_STAINED_GLASS_PANE, 10, rem10, null));
            inv.setItem(18, ItemUtil.create(Material.RED_STAINED_GLASS_PANE, 1, set1, null));
        }
        inv.setItem(39, ItemUtil.create(Material.LIME_STAINED_GLASS, 1, confirmName, null));
        if (owned > 0) {
            inv.setItem(sellAllSlot, ItemUtil.create(Material.GOLD_BLOCK, 1, sellAllName, null));
        }
        inv.setItem(40, ItemUtil.create(Material.ENDER_CHEST, 1, backName, null));
        inv.setItem(41, ItemUtil.create(Material.RED_STAINED_GLASS, 1, cancelName, null));
        player.openInventory(inv);
        player.setMetadata("sell.material", (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)material.name()));
        player.setMetadata("sell.price", (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)sellPrice));
        player.setMetadata("sell.amount", (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)amount));
        if (spawnerType != null) {
            player.setMetadata("sell.spawnerType", (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)spawnerType));
        } else {
            player.removeMetadata("sell.spawnerType", (Plugin)plugin);
        }
        if (customName != null) {
            player.setMetadata("sell.customName", (MetadataValue)new FixedMetadataValue((Plugin)plugin, (Object)customName));
        } else {
            player.removeMetadata("sell.customName", (Plugin)plugin);
        }
    }

    @EventHandler
    public void onClick(InventoryClickEvent e) {
        ItemStack clicked;
        if (!(e.getWhoClicked() instanceof Player)) {
            return;
        }
        Player player = (Player)e.getWhoClicked();
        ShopPlugin plugin = ShopPlugin.getInstance();
        String titlePrefix = plugin.getMessages().getGuiString("sell.title-prefix", "&8Selling ");
        if (!e.getView().getTitle().startsWith(ItemUtil.color(titlePrefix))) {
            return;
        }
        e.setCancelled(true);
        if (e.getCurrentItem() == null) {
            return;
        }
        String materialName = player.hasMetadata("sell.material") ? ((MetadataValue)player.getMetadata("sell.material").get(0)).asString() : "DIRT";
        double sellPrice = player.hasMetadata("sell.price") ? ((MetadataValue)player.getMetadata("sell.price").get(0)).asDouble() : 0.0;
        int amount = player.hasMetadata("sell.amount") ? ((MetadataValue)player.getMetadata("sell.amount").get(0)).asInt() : 1;
        String spawnerType = player.hasMetadata("sell.spawnerType") ? ((MetadataValue)player.getMetadata("sell.spawnerType").get(0)).asString() : null;
        String customName = player.hasMetadata("sell.customName") ? ((MetadataValue)player.getMetadata("sell.customName").get(0)).asString() : null;
        Material material = Material.matchMaterial((String)materialName);
        if (material == null) {
            material = Material.DIRT;
        }
        String name = (clicked = e.getCurrentItem()).hasItemMeta() && clicked.getItemMeta().hasDisplayName() ? clicked.getItemMeta().getDisplayName() : "";
        String add1 = plugin.getMessages().getGuiString("sell.add-1", "&aAdd 1");
        String add10 = plugin.getMessages().getGuiString("sell.add-10", "&aAdd 10");
        String set64 = plugin.getMessages().getGuiString("sell.set-64", "&aSet to 64");
        String rem1 = plugin.getMessages().getGuiString("sell.remove-1", "&cRemove 1");
        String rem10 = plugin.getMessages().getGuiString("sell.remove-10", "&cRemove 10");
        String set1 = plugin.getMessages().getGuiString("sell.set-1", "&cSet to 1");
        String confirmName = plugin.getMessages().getGuiString("sell.confirm-name", "&aCONFIRM SELL");
        String sellAllName = plugin.getMessages().getGuiString("sell.sell-all-name", "&6SELL ALL");
        String backName = plugin.getMessages().getGuiString("sell.back-name", "&9BACK TO CATEGORIES");
        String cancelName = plugin.getMessages().getGuiString("sell.cancel-name", "&cCANCEL");
        int owned = SellMenu.countPlayerItems(player, material, spawnerType);
        if (owned < 0) {
            owned = 0;
        }
        if (amount > owned) {
            amount = owned;
        }
        if (clicked.getType() == Material.LIME_STAINED_GLASS_PANE) {
            if (name.equals(ItemUtil.color(add1))) {
                int newAmt = Math.min(amount + 1, owned);
                SellMenu.open(player, material, sellPrice, newAmt, spawnerType, customName, null);
                return;
            }
            if (name.equals(ItemUtil.color(add10))) {
                int newAmt = Math.min(amount + 10, owned);
                SellMenu.open(player, material, sellPrice, newAmt, spawnerType, customName, null);
                return;
            }
            if (name.equals(ItemUtil.color(set64))) {
                int newAmt = Math.min(64, owned);
                SellMenu.open(player, material, sellPrice, newAmt, spawnerType, customName, null);
                return;
            }
        }
        if (clicked.getType() == Material.RED_STAINED_GLASS_PANE) {
            if (name.equals(ItemUtil.color(rem1))) {
                int newAmt = Math.max(1, amount - 1);
                SellMenu.open(player, material, sellPrice, newAmt, spawnerType, customName, null);
                return;
            }
            if (name.equals(ItemUtil.color(rem10))) {
                int newAmt = Math.max(1, amount - 10);
                SellMenu.open(player, material, sellPrice, newAmt, spawnerType, customName, null);
                return;
            }
            if (name.equals(ItemUtil.color(set1))) {
                SellMenu.open(player, material, sellPrice, 1, spawnerType, customName, null);
                return;
            }
        }
        if (clicked.getType() == Material.LIME_STAINED_GLASS && name.equals(ItemUtil.color(confirmName))) {
            this.sellSelected(player, material, spawnerType, amount, sellPrice, customName);
            return;
        }
        if (clicked.getType() == Material.GOLD_BLOCK && name.equals(ItemUtil.color(sellAllName))) {
            if (owned <= 0) {
                player.sendMessage(plugin.getMessages().getMessage("no-items-to-sell").replace("%item%", material.name()));
                return;
            }
            this.sellAll(player, material, spawnerType, sellPrice, customName);
            return;
        }
        if (clicked.getType() == Material.ENDER_CHEST && name.equals(ItemUtil.color(backName))) {
            MainMenu.open(player);
            return;
        }
        if (clicked.getType() == Material.RED_STAINED_GLASS && name.equals(ItemUtil.color(cancelName))) {
            player.closeInventory();
        }
    }

    private void sellSelected(Player player, Material material, String spawnerType, int amount, double sellPrice, String customName) {
        int owned = SellMenu.countPlayerItems(player, material, spawnerType);
        if (owned < amount) {
            player.sendMessage(ShopPlugin.getInstance().getMessages().getMessage("no-items-to-sell").replace("%item%", material.name()));
            return;
        }
        SellMenu.removeItems(player, material, spawnerType, amount);
        EconomyHook eco = ShopPlugin.getInstance().getEconomy();
        if (eco.isReady()) {
            eco.deposit(player, (double)amount * sellPrice);
        }
        String itemName = customName != null ? customName.replace("&", "\u00a7") : material.name();
        player.sendMessage(ShopPlugin.getInstance().getMessages().getMessage("sell-success").replace("%amount%", String.valueOf(amount)).replace("%item%", itemName).replace("%price%", String.valueOf((double)amount * sellPrice)));
        player.closeInventory();
    }

    private void sellAll(Player player, Material material, String spawnerType, double sellPrice, String customName) {
        int owned = SellMenu.countPlayerItems(player, material, spawnerType);
        if (owned <= 0) {
            player.sendMessage(ShopPlugin.getInstance().getMessages().getMessage("no-items-to-sell").replace("%item%", material.name()));
            return;
        }
        SellMenu.removeItems(player, material, spawnerType, owned);
        EconomyHook eco = ShopPlugin.getInstance().getEconomy();
        if (eco.isReady()) {
            eco.deposit(player, (double)owned * sellPrice);
        }
        String itemName = customName != null ? customName.replace("&", "\u00a7") : material.name();
        player.sendMessage(ShopPlugin.getInstance().getMessages().getMessage("sell-all-success").replace("%amount%", String.valueOf(owned)).replace("%item%", itemName).replace("%price%", String.valueOf((double)owned * sellPrice)));
        player.closeInventory();
    }

    private static int countPlayerItems(Player player, Material material, String spawnerType) {
        int count = 0;
        for (ItemStack it : player.getInventory().getContents()) {
            if (it == null || it.getType() == Material.AIR || it.getType() != material || material == Material.SPAWNER && spawnerType != null && !spawnerType.isEmpty() && !SellMenu.spawnerMatches(it, spawnerType)) continue;
            count += it.getAmount();
        }
        return count;
    }

    private static boolean spawnerMatches(ItemStack it, String spawnerType) {
        if (!(it.getItemMeta() instanceof BlockStateMeta)) {
            return false;
        }
        BlockStateMeta bsm = (BlockStateMeta)it.getItemMeta();
        if (!(bsm.getBlockState() instanceof CreatureSpawner)) {
            return false;
        }
        CreatureSpawner cs = (CreatureSpawner)bsm.getBlockState();
        EntityType type = cs.getSpawnedType();
        return type != null && type.name().equalsIgnoreCase(spawnerType);
    }

    private static void removeItems(Player player, Material material, String spawnerType, int amount) {
        int toRemove = amount;
        for (int i = 0; i < player.getInventory().getSize(); ++i) {
            ItemStack it = player.getInventory().getItem(i);
            if (it == null || it.getType() == Material.AIR || it.getType() != material || material == Material.SPAWNER && spawnerType != null && !spawnerType.isEmpty() && !SellMenu.spawnerMatches(it, spawnerType)) continue;
            int stackAmount = it.getAmount();
            if (stackAmount <= toRemove) {
                player.getInventory().setItem(i, null);
                toRemove -= stackAmount;
            } else {
                it.setAmount(stackAmount - toRemove);
                toRemove = 0;
            }
            if (toRemove <= 0) break;
        }
    }
}

