/*
 * Decompiled with CFR 0.152.
 */
package me.dralle.shop.metrics;

import java.io.DataOutputStream;
import java.io.File;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.UUID;
import java.util.logging.Level;
import javax.net.ssl.HttpsURLConnection;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class Metrics {
    private static final String BSTATS_URL = "https://bStats.org/submitData/bukkit";
    private final Plugin plugin;
    private final int pluginId;
    private boolean enabled;
    private String serverUuid;

    public Metrics(Plugin plugin, int pluginId) {
        this.plugin = plugin;
        this.pluginId = pluginId;
        File bStatsFolder = new File(plugin.getDataFolder().getParentFile(), "bStats");
        File configFile = new File(bStatsFolder, "config.yml");
        YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
        if (!config.isSet("serverUuid")) {
            config.set("serverUuid", (Object)UUID.randomUUID().toString());
        }
        if (!config.isSet("enabled")) {
            config.set("enabled", (Object)true);
        }
        this.serverUuid = config.getString("serverUuid");
        this.enabled = config.getBoolean("enabled", true);
        try {
            if (!bStatsFolder.exists()) {
                bStatsFolder.mkdirs();
            }
            config.save(configFile);
        }
        catch (Exception ex) {
            plugin.getLogger().log(Level.WARNING, "[bStats] Could not save config", ex);
        }
        if (this.enabled) {
            this.startSubmitting();
        } else {
            plugin.getLogger().info("[bStats] Metrics disabled in config.");
        }
    }

    private void startSubmitting() {
        new BukkitRunnable(){

            public void run() {
                Metrics.this.submitData();
            }
        }.runTaskTimerAsynchronously(this.plugin, 1200L, 36000L);
    }

    private void submitData() {
        try {
            String json = this.buildJson();
            HttpsURLConnection connection = (HttpsURLConnection)new URL(BSTATS_URL).openConnection();
            connection.setRequestMethod("POST");
            connection.addRequestProperty("Content-Type", "application/json");
            connection.addRequestProperty("Accept", "application/json");
            connection.setDoOutput(true);
            try (DataOutputStream out = new DataOutputStream(connection.getOutputStream());){
                out.write(json.getBytes(StandardCharsets.UTF_8));
            }
            connection.getInputStream().close();
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.FINE, "[bStats] Failed to submit stats: " + e.getMessage());
        }
    }

    private String buildJson() {
        int playerCount = Bukkit.getOnlinePlayers().size();
        String version = this.plugin.getDescription().getVersion();
        String name = this.plugin.getDescription().getName();
        return "{\"serverUUID\":\"" + this.serverUuid + "\",\"playerAmount\":" + playerCount + ",\"pluginVersion\":\"" + version + "\",\"pluginName\":\"" + name + "\",\"id\":" + this.pluginId + "}";
    }
}

