/*
 * Decompiled with CFR 0.152.
 */
package me.dralle.shop.util;

import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Set;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigUpdater {
    public static void update(JavaPlugin plugin, String fileName) {
        File userFile = new File(plugin.getDataFolder(), fileName);
        if (!userFile.exists()) {
            plugin.saveResource(fileName, false);
            plugin.getLogger().info("Created default " + fileName);
            return;
        }
        boolean mergeMissingDefaults = true;
        try {
            File mainConfig = new File(plugin.getDataFolder(), "config.yml");
            if (mainConfig.exists()) {
                YamlConfiguration main = YamlConfiguration.loadConfiguration((File)mainConfig);
                mergeMissingDefaults = main.getBoolean("merge-missing-defaults", true);
            }
        }
        catch (Exception ex) {
            plugin.getLogger().warning("Could not read merge-missing-defaults from config.yml: " + ex.getMessage());
        }
        try (InputStream in = plugin.getResource(fileName);){
            if (in == null) {
                plugin.getLogger().warning("Default " + fileName + " not found in jar.");
                return;
            }
            YamlConfiguration defCfg = YamlConfiguration.loadConfiguration((Reader)new InputStreamReader(in, StandardCharsets.UTF_8));
            YamlConfiguration userCfg = YamlConfiguration.loadConfiguration((File)userFile);
            int defaultVersion = defCfg.getInt("config-version", 1);
            int userVersion = userCfg.getInt("config-version", -1);
            if (userVersion == -1) {
                plugin.getLogger().info("[ConfigUpdater] " + fileName + " is missing config-version. Applying latest defaults.");
                if (mergeMissingDefaults) {
                    boolean changed = ConfigUpdater.mergeSections((ConfigurationSection)defCfg, (ConfigurationSection)userCfg, "", true);
                    userCfg.set("config-version", (Object)defaultVersion);
                    userCfg.save(userFile);
                    if (changed) {
                        plugin.getLogger().info("Updated " + fileName + " to version " + defaultVersion);
                    }
                } else {
                    plugin.getLogger().info("[ConfigUpdater] merge-missing-defaults is false \u2014 skipping update.");
                }
                return;
            }
            if (userVersion >= defaultVersion) {
                return;
            }
            if (!mergeMissingDefaults) {
                plugin.getLogger().info("[ConfigUpdater] " + fileName + " has newer defaults (" + defaultVersion + ") but merge-missing-defaults=false. Skipping merge.");
                return;
            }
            boolean changed = ConfigUpdater.mergeSections((ConfigurationSection)defCfg, (ConfigurationSection)userCfg, "", true);
            userCfg.set("config-version", (Object)defaultVersion);
            userCfg.save(userFile);
            if (changed) {
                plugin.getLogger().info("Merged new defaults into " + fileName + " (updated to version " + defaultVersion + ").");
            } else {
                plugin.getLogger().info(fileName + " version bumped to " + defaultVersion);
            }
        }
        catch (Exception e) {
            plugin.getLogger().warning("Could not update " + fileName + ": " + e.getMessage());
            e.printStackTrace();
        }
    }

    private static boolean mergeSections(ConfigurationSection def, ConfigurationSection user, String path, boolean allowAdd) {
        boolean changed = false;
        Set keys = def.getKeys(false);
        for (String key : keys) {
            String fullPath;
            String string = fullPath = path.isEmpty() ? key : path + "." + key;
            if (!user.contains(key)) {
                if (!allowAdd) continue;
                user.set(key, def.get(key));
                changed = true;
                continue;
            }
            if (!def.isConfigurationSection(key)) continue;
            ConfigurationSection defChild = def.getConfigurationSection(key);
            ConfigurationSection userChild = user.getConfigurationSection(key);
            if (defChild == null || userChild == null || !ConfigUpdater.mergeSections(defChild, userChild, fullPath, allowAdd)) continue;
            changed = true;
        }
        return changed;
    }
}

