/*
 * Decompiled with CFR 0.152.
 */
package me.dralle.shop.util;

import java.util.ArrayList;
import java.util.List;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class ItemUtil {
    public static String color(String text) {
        if (text == null) {
            return "";
        }
        return ChatColor.translateAlternateColorCodes((char)'&', (String)text);
    }

    public static String stripColor(String text) {
        if (text == null) {
            return "";
        }
        return ChatColor.stripColor((String)ChatColor.translateAlternateColorCodes((char)'&', (String)text));
    }

    public static ItemStack create(Material material, int amount, String name, List<String> loreList) {
        ItemStack item;
        ItemMeta meta;
        if (material == null) {
            material = Material.BARRIER;
        }
        if (amount <= 0) {
            amount = 1;
        }
        if ((meta = (item = new ItemStack(material, amount)).getItemMeta()) != null) {
            if (name != null && !name.isEmpty()) {
                meta.setDisplayName(ItemUtil.color(name));
            }
            if (loreList != null && !loreList.isEmpty()) {
                ArrayList<String> coloredLore = new ArrayList<String>();
                for (String line : loreList) {
                    coloredLore.add(ItemUtil.color(line));
                }
                meta.setLore(coloredLore);
            }
            item.setItemMeta(meta);
        }
        return item;
    }
}

