/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore;

import com.mojang.logging.LogUtils;
import liedge.limacore.lib.ModResources;
import liedge.limacore.network.packet.ClientboundBlockEntityDataWatcherPacket;
import liedge.limacore.network.packet.ClientboundMenuDataWatcherPacket;
import liedge.limacore.network.packet.ClientboundParticlePacket;
import liedge.limacore.network.packet.ServerboundBlockEntityDataRequestPacket;
import liedge.limacore.network.packet.ServerboundCustomMenuButtonPacket;
import liedge.limacore.network.packet.ServerboundFluidSlotClickPacket;
import liedge.limacore.registry.LimaCoreRegistries;
import liedge.limacore.registry.game.LimaCoreAttributes;
import liedge.limacore.registry.game.LimaCoreDataComponents;
import liedge.limacore.registry.game.LimaCoreIngredientTypes;
import liedge.limacore.registry.game.LimaCoreLootRegistries;
import liedge.limacore.registry.game.LimaCoreNetworkSerializers;
import liedge.limacore.registry.game.LimaCoreTriggerTypes;
import liedge.limacore.registry.game.LimaCoreWorldGen;
import liedge.limacore.util.LimaNetworkUtil;
import net.minecraft.core.Holder;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.ModContainer;
import net.neoforged.fml.common.Mod;
import net.neoforged.neoforge.event.entity.EntityAttributeModificationEvent;
import net.neoforged.neoforge.network.event.RegisterPayloadHandlersEvent;
import net.neoforged.neoforge.network.registration.PayloadRegistrar;
import net.neoforged.neoforge.registries.NewRegistryEvent;
import org.slf4j.Logger;

@Mod(value="limacore")
public class LimaCore {
    public static final String MODID = "limacore";
    public static final ModResources RESOURCES = new ModResources("limacore");
    public static final Logger LOGGER = LogUtils.getLogger();

    public LimaCore(IEventBus modBus, ModContainer modContainer) {
        LimaCoreAttributes.register(modBus);
        LimaCoreDataComponents.register(modBus);
        LimaCoreIngredientTypes.register(modBus);
        LimaCoreLootRegistries.register(modBus);
        LimaCoreNetworkSerializers.register(modBus);
        LimaCoreTriggerTypes.register(modBus);
        LimaCoreWorldGen.register(modBus);
        modBus.register((Object)new CommonSetup());
    }

    private static class CommonSetup {
        private CommonSetup() {
        }

        @SubscribeEvent
        private void registerPayloadHandlers(RegisterPayloadHandlersEvent event) {
            PayloadRegistrar registrar = event.registrar(LimaCore.MODID);
            LimaNetworkUtil.registerPlayToClient(registrar, ClientboundBlockEntityDataWatcherPacket.TYPE, ClientboundBlockEntityDataWatcherPacket.STREAM_CODEC);
            LimaNetworkUtil.registerPlayToClient(registrar, ClientboundMenuDataWatcherPacket.TYPE, ClientboundMenuDataWatcherPacket.STREAM_CODEC);
            LimaNetworkUtil.registerPlayToClient(registrar, ClientboundParticlePacket.TYPE, ClientboundParticlePacket.STREAM_CODEC);
            LimaNetworkUtil.registerPlayToServer(registrar, ServerboundCustomMenuButtonPacket.TYPE, ServerboundCustomMenuButtonPacket.STREAM_CODEC);
            LimaNetworkUtil.registerPlayToServer(registrar, ServerboundFluidSlotClickPacket.TYPE, ServerboundFluidSlotClickPacket.STREAM_CODEC);
            LimaNetworkUtil.registerPlayToServer(registrar, ServerboundBlockEntityDataRequestPacket.TYPE, ServerboundBlockEntityDataRequestPacket.STREAM_CODEC);
        }

        @SubscribeEvent
        private void registerCustomRegistries(NewRegistryEvent event) {
            event.register(LimaCoreRegistries.NETWORK_SERIALIZERS);
        }

        @SubscribeEvent
        private void modifyEntityAttributes(EntityAttributeModificationEvent event) {
            for (EntityType type : event.getTypes()) {
                this.addAttributeToEntity(event, (EntityType<? extends LivingEntity>)type, (Holder<Attribute>)LimaCoreAttributes.DAMAGE_MULTIPLIER);
                this.addAttributeToEntity(event, (EntityType<? extends LivingEntity>)type, (Holder<Attribute>)LimaCoreAttributes.KNOCKBACK_MULTIPLIER);
            }
        }

        private void addAttributeToEntity(EntityAttributeModificationEvent event, EntityType<? extends LivingEntity> type, Holder<Attribute> attribute) {
            if (!event.has(type, attribute)) {
                event.add(type, attribute);
            }
        }
    }
}

