/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.advancement;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import liedge.limacore.advancement.LimaAdvancementUtil;
import liedge.limacore.registry.game.LimaCoreTriggerTypes;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

public final class CustomRecipeTypeTrigger
extends SimpleCriterionTrigger<TriggerInstance> {
    private static final Codec<TriggerInstance> CODEC = RecordCodecBuilder.create(instance -> LimaAdvancementUtil.playerCodecStart(instance).and((App)BuiltInRegistries.RECIPE_TYPE.byNameCodec().fieldOf("recipe_type").forGetter(TriggerInstance::recipeType)).and((App)ItemPredicate.CODEC.optionalFieldOf("item_crafted").forGetter(TriggerInstance::itemCrafted)).apply((Applicative)instance, TriggerInstance::new));

    public static Criterion<TriggerInstance> itemCrafted(RecipeType<?> recipeType, @Nullable ContextAwarePredicate player, @Nullable ItemPredicate itemPredicate) {
        return ((CustomRecipeTypeTrigger)((Object)LimaCoreTriggerTypes.CUSTOM_RECIPE_TYPE_USED.get())).createCriterion((CriterionTriggerInstance)new TriggerInstance(Optional.ofNullable(player), recipeType, Optional.ofNullable(itemPredicate)));
    }

    public static Criterion<TriggerInstance> itemCrafted(RecipeType<?> recipeType, @Nullable ContextAwarePredicate player, ItemPredicate.Builder builder) {
        return CustomRecipeTypeTrigger.itemCrafted(recipeType, player, builder.build());
    }

    public static Criterion<TriggerInstance> itemCrafted(RecipeType<?> recipeType, ItemLike item) {
        return CustomRecipeTypeTrigger.itemCrafted(recipeType, null, ItemPredicate.Builder.item().of(new ItemLike[]{item}));
    }

    public void trigger(ServerPlayer serverPlayer, RecipeType<?> recipeType, ItemStack stack) {
        this.trigger(serverPlayer, instance -> instance.matches(recipeType, stack));
    }

    public Codec<TriggerInstance> codec() {
        return CODEC;
    }

    public record TriggerInstance(Optional<ContextAwarePredicate> player, RecipeType<?> recipeType, Optional<ItemPredicate> itemCrafted) implements SimpleCriterionTrigger.SimpleInstance
    {
        private boolean matches(RecipeType<?> recipeType, ItemStack stack) {
            return this.recipeType.equals(recipeType) && this.itemCrafted.map(o -> o.test(stack)).orElse(true) != false;
        }
    }
}

