/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.advancement;

import com.mojang.datafixers.Products;
import com.mojang.datafixers.kinds.App;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.Optional;
import liedge.limacore.lib.ModResources;
import liedge.limacore.registry.game.LimaCoreTriggerTypes;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.advancements.critereon.ContextAwarePredicate;
import net.minecraft.advancements.critereon.EntityPredicate;
import net.minecraft.advancements.critereon.InventoryChangeTrigger;
import net.minecraft.advancements.critereon.ItemPredicate;
import net.minecraft.advancements.critereon.PlayerTrigger;
import net.minecraft.advancements.critereon.SimpleCriterionTrigger;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.storage.loot.LootTable;
import org.jetbrains.annotations.Nullable;

public final class LimaAdvancementUtil {
    private LimaAdvancementUtil() {
    }

    public static <T extends SimpleCriterionTrigger.SimpleInstance> Products.P1<RecordCodecBuilder.Mu<T>, Optional<ContextAwarePredicate>> playerCodecStart(RecordCodecBuilder.Instance<T> instance) {
        return instance.group((App)EntityPredicate.ADVANCEMENT_CODEC.optionalFieldOf("player").forGetter(SimpleCriterionTrigger.SimpleInstance::player));
    }

    public static boolean testEntityPredicate(Optional<ContextAwarePredicate> optional, ServerPlayer serverPlayer, Entity toTest) {
        return optional.map(predicate -> LimaAdvancementUtil.testEntityPredicate(predicate, serverPlayer, toTest)).orElse(true);
    }

    public static boolean testEntityPredicate(ContextAwarePredicate predicate, ServerPlayer serverPlayer, Entity toTest) {
        return predicate.matches(EntityPredicate.createContext((ServerPlayer)serverPlayer, (Entity)toTest));
    }

    public static Criterion<PlayerTrigger.TriggerInstance> playerLoggedIn(@Nullable EntityPredicate.Builder playerPredicate) {
        Optional<ContextAwarePredicate> player = Optional.ofNullable(playerPredicate).map(EntityPredicate::wrap);
        return ((PlayerTrigger)LimaCoreTriggerTypes.PLAYER_LOGGED_IN.get()).createCriterion((CriterionTriggerInstance)new PlayerTrigger.TriggerInstance(player));
    }

    public static Criterion<PlayerTrigger.TriggerInstance> playerLoggedIn() {
        return LimaAdvancementUtil.playerLoggedIn(null);
    }

    public static Criterion<InventoryChangeTrigger.TriggerInstance> playerHasItems(TagKey<Item> tagKey) {
        ItemPredicate predicate = ItemPredicate.Builder.item().of(tagKey).build();
        return InventoryChangeTrigger.TriggerInstance.hasItems((ItemPredicate[])new ItemPredicate[]{predicate});
    }

    public static String defaultAdvancementTitleKey(ResourceLocation id) {
        return ModResources.prefixedIdLangKey("advancement", id);
    }

    public static String defaultAdvancementDescriptionKey(ResourceLocation id) {
        return ModResources.prefixedVariantIdLangKey("advancement", "desc", id);
    }

    public static ResourceKey<LootTable> defaultAdvancementLootTable(ResourceLocation id) {
        return ResourceKey.create((ResourceKey)Registries.LOOT_TABLE, (ResourceLocation)id.withPrefix("advancement/"));
    }
}

