/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.capability.energy;

import liedge.limacore.network.sync.AutomaticDataWatcher;
import liedge.limacore.network.sync.DataWatcherHolder;
import liedge.limacore.network.sync.LimaDataWatcher;
import liedge.limacore.registry.game.LimaCoreDataComponents;
import liedge.limacore.registry.game.LimaCoreNetworkSerializers;
import net.minecraft.core.component.DataComponentMap;
import net.neoforged.neoforge.common.MutableDataComponentHolder;
import net.neoforged.neoforge.energy.IEnergyStorage;

public abstract class LimaEnergyStorage
implements IEnergyStorage {
    private int maxEnergy;
    private int transferRate;

    protected LimaEnergyStorage(int maxEnergy, int transferRate) {
        this.setMaxEnergyStored(maxEnergy);
        this.setTransferRate(transferRate);
    }

    public void writeComponents(MutableDataComponentHolder dataHolder) {
        dataHolder.set(LimaCoreDataComponents.ENERGY, (Object)this.getEnergyStored());
        dataHolder.set(LimaCoreDataComponents.ENERGY_CAPACITY, (Object)this.getMaxEnergyStored());
        dataHolder.set(LimaCoreDataComponents.ENERGY_TRANSFER_RATE, (Object)this.getTransferRate());
    }

    public void writeComponents(DataComponentMap.Builder builder) {
        builder.set(LimaCoreDataComponents.ENERGY, (Object)this.getEnergyStored());
        builder.set(LimaCoreDataComponents.ENERGY_CAPACITY, (Object)this.getMaxEnergyStored());
        builder.set(LimaCoreDataComponents.ENERGY_TRANSFER_RATE, (Object)this.getTransferRate());
    }

    public LimaDataWatcher<Integer> keepStoredEnergySynced() {
        return AutomaticDataWatcher.keepSynced(LimaCoreNetworkSerializers.VAR_INT, this::getEnergyStored, this::setEnergyStored);
    }

    public LimaDataWatcher<Integer> keepCapacitySynced() {
        return AutomaticDataWatcher.keepSynced(LimaCoreNetworkSerializers.VAR_INT, this::getMaxEnergyStored, this::setMaxEnergyStored);
    }

    public LimaDataWatcher<Integer> keepTransferRateSynced() {
        return AutomaticDataWatcher.keepSynced(LimaCoreNetworkSerializers.VAR_INT, this::getTransferRate, this::setTransferRate);
    }

    public void keepAllPropertiesSynced(DataWatcherHolder.DataWatcherCollector collector) {
        collector.register(this.keepStoredEnergySynced());
        collector.register(this.keepCapacitySynced());
        collector.register(this.keepTransferRateSynced());
    }

    public int getTransferRate() {
        return this.transferRate;
    }

    public void setTransferRate(int transferRate) {
        this.transferRate = Math.max(1, transferRate);
    }

    public void setMaxEnergyStored(int maxEnergy) {
        this.maxEnergy = Math.max(1, maxEnergy);
    }

    public int receiveEnergy(int toReceive, boolean simulate, boolean ignoreLimit) {
        if (toReceive <= 0) {
            return 0;
        }
        int limit = ignoreLimit ? Integer.MAX_VALUE : this.transferRate;
        int energy = this.getEnergyStored();
        int actuallyReceived = Math.min(this.maxEnergy - energy, Math.min(toReceive, limit));
        if (!simulate && actuallyReceived > 0) {
            this.setEnergyStored(energy + actuallyReceived);
        }
        return actuallyReceived;
    }

    public int extractEnergy(int toExtract, boolean simulate, boolean ignoreLimit) {
        if (toExtract <= 0) {
            return 0;
        }
        int limit = ignoreLimit ? Integer.MAX_VALUE : this.transferRate;
        int energy = this.getEnergyStored();
        int actuallyExtracted = Math.min(energy, Math.min(toExtract, limit));
        if (!simulate && actuallyExtracted > 0) {
            this.setEnergyStored(energy - actuallyExtracted);
        }
        return actuallyExtracted;
    }

    public int receiveEnergy(int toReceive, boolean simulate) {
        return this.receiveEnergy(toReceive, simulate, false);
    }

    public int extractEnergy(int toExtract, boolean simulate) {
        return this.extractEnergy(toExtract, simulate, false);
    }

    public abstract void setEnergyStored(int var1);

    public abstract int getEnergyStored();

    public int getMaxEnergyStored() {
        return this.maxEnergy;
    }

    public boolean canExtract() {
        return true;
    }

    public boolean canReceive() {
        return true;
    }
}

