/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.capability.fluid;

import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class CombinedFluidsWrapper
implements IFluidHandler {
    private final IFluidHandler[] handlers;
    private final int[] indexOffsets;
    private final int tanks;

    public CombinedFluidsWrapper(IFluidHandler ... handlers) {
        this.handlers = handlers;
        this.indexOffsets = new int[handlers.length];
        int index = 0;
        for (int i = 0; i < handlers.length; ++i) {
            this.indexOffsets[i] = index += handlers[i].getTanks();
        }
        this.tanks = index;
    }

    private int resolveHandlerIndex(int tank) {
        for (int i = 0; i < this.indexOffsets.length; ++i) {
            if (tank >= this.indexOffsets[i]) continue;
            return i;
        }
        throw new IndexOutOfBoundsException("Tank " + tank + " not in valid range [0," + this.tanks + ")");
    }

    private int resolveTankIndex(int tank, int handlerIndex) {
        if (handlerIndex == 0) {
            return tank;
        }
        return tank - this.indexOffsets[handlerIndex - 1];
    }

    public int getTanks() {
        return this.tanks;
    }

    public FluidStack getFluidInTank(int tank) {
        int handlerIndex = this.resolveHandlerIndex(tank);
        tank = this.resolveTankIndex(tank, handlerIndex);
        return this.handlers[handlerIndex].getFluidInTank(tank);
    }

    public int getTankCapacity(int tank) {
        int handlerIndex = this.resolveHandlerIndex(tank);
        tank = this.resolveTankIndex(tank, handlerIndex);
        return this.handlers[handlerIndex].getTankCapacity(tank);
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        int handlerIndex = this.resolveHandlerIndex(tank);
        tank = this.resolveTankIndex(tank, handlerIndex);
        return this.handlers[handlerIndex].isFluidValid(tank, stack);
    }

    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        IFluidHandler handler;
        int result = 0;
        IFluidHandler[] iFluidHandlerArray = this.handlers;
        int n = iFluidHandlerArray.length;
        for (int i = 0; i < n && (result = (handler = iFluidHandlerArray[i]).fill(resource, action)) <= 0; ++i) {
        }
        return result;
    }

    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        IFluidHandler handler;
        FluidStack result = FluidStack.EMPTY;
        IFluidHandler[] iFluidHandlerArray = this.handlers;
        int n = iFluidHandlerArray.length;
        for (int i = 0; i < n && (result = (handler = iFluidHandlerArray[i]).drain(resource, action)).isEmpty(); ++i) {
        }
        return result;
    }

    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        IFluidHandler handler;
        FluidStack result = FluidStack.EMPTY;
        IFluidHandler[] iFluidHandlerArray = this.handlers;
        int n = iFluidHandlerArray.length;
        for (int i = 0; i < n && (result = (handler = iFluidHandlerArray[i]).drain(maxDrain, action)).isEmpty(); ++i) {
        }
        return result;
    }
}

