/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.capability.fluid;

import com.google.common.base.Preconditions;
import java.lang.invoke.MethodHandle;
import java.lang.runtime.ObjectMethods;
import liedge.limacore.blockentity.BlockContentsType;
import liedge.limacore.blockentity.IOAccess;
import liedge.limacore.capability.fluid.FluidHandlerIOWrapper;
import liedge.limacore.capability.fluid.FluidHolderBlockEntity;
import liedge.limacore.capability.fluid.LimaFluidHandler;
import liedge.limacore.capability.fluid.LimaFluidTank;
import liedge.limacore.capability.fluid.SimpleFluidHandler;
import liedge.limacore.capability.fluid.VariableFluidTank;
import liedge.limacore.network.sync.DataWatcherHolder;
import liedge.limacore.util.LimaCollectionsUtil;
import liedge.limacore.util.LimaStreamsUtil;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.neoforged.neoforge.common.util.INBTSerializable;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public class LimaBlockEntityFluidHandler
extends LimaFluidHandler
implements INBTSerializable<ListTag> {
    private final NonNullList<VariableFluidTank> tanks;
    private final FluidHolderBlockEntity blockEntity;
    private final BlockContentsType contentsType;

    public LimaBlockEntityFluidHandler(FluidHolderBlockEntity blockEntity, int size, BlockContentsType contentsType) {
        Preconditions.checkArgument((size > 0 ? 1 : 0) != 0, (Object)"Fluid handler must have at least 1 tank.");
        this.tanks = NonNullList.createWithCapacity((int)size);
        this.blockEntity = blockEntity;
        this.contentsType = contentsType;
        for (int i = 0; i < size; ++i) {
            VariableFluidTank tank = new VariableFluidTank(blockEntity.getBaseFluidCapacity(contentsType, i), blockEntity.getBaseFluidTransferRate(contentsType, i));
            this.tanks.add((Object)tank);
        }
    }

    public void syncAllTanks(DataWatcherHolder.DataWatcherCollector collector) {
        this.tanks.forEach(tank -> tank.syncTank(collector));
    }

    public FluidHandlerIOWrapper createIOWrapper(IOAccess blockAccessLevel) {
        return new IOWrapper(this, blockAccessLevel);
    }

    public LimaFluidHandler copyHandler() {
        NonNullList copiedTanks = this.tanks.stream().map(VariableFluidTank::copy).collect(LimaStreamsUtil.toNonNullList());
        return new SimpleFluidHandler(copiedTanks);
    }

    protected NonNullList<VariableFluidTank> getFluidTanks() {
        return this.tanks;
    }

    @Override
    protected void onTankChanged(int tank) {
        this.blockEntity.onFluidsChanged(this.contentsType, tank);
    }

    @Override
    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.blockEntity.isValidFluid(this.contentsType, tank, stack);
    }

    public ListTag serializeNBT(HolderLookup.Provider provider) {
        ListTag tag = new ListTag();
        for (int i = 0; i < this.tanks.size(); ++i) {
            LimaFluidTank tank = (LimaFluidTank)this.tanks.get(i);
            if (tank.getFluid().isEmpty()) continue;
            CompoundTag tankTag = new CompoundTag();
            tankTag.putInt("tank", i);
            tag.add((Object)tank.getFluid().save(provider, (Tag)tankTag));
        }
        return tag;
    }

    public void deserializeNBT(HolderLookup.Provider provider, ListTag nbt) {
        LimaCollectionsUtil.streamCompoundList(nbt).forEach(tankTag -> {
            int tank = tankTag.getInt("tank");
            FluidStack stack = FluidStack.parseOptional((HolderLookup.Provider)provider, (CompoundTag)tankTag);
            this.getFluidTank(tank).setFluid(stack);
        });
    }

    private static final class IOWrapper
    extends Record
    implements FluidHandlerIOWrapper {
        private final LimaBlockEntityFluidHandler fluidHandler;
        private final IOAccess blockAccessLevel;

        private IOWrapper(LimaBlockEntityFluidHandler fluidHandler, IOAccess blockAccessLevel) {
            this.fluidHandler = fluidHandler;
            this.blockAccessLevel = blockAccessLevel;
        }

        public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.blockAccessLevel.allowsInput()) {
                for (int i = 0; i < this.getTanks(); ++i) {
                    int filled;
                    if (!this.fluidHandler.blockEntity.getFluidTankIO(this.fluidHandler.contentsType, i).allowsInput() || (filled = this.fluidHandler.fillTank(i, resource, action, false)) <= 0) continue;
                    return filled;
                }
            }
            return 0;
        }

        public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
            if (this.blockAccessLevel.allowsOutput()) {
                for (int i = 0; i < this.getTanks(); ++i) {
                    FluidStack drained;
                    if (!this.fluidHandler.blockEntity.getFluidTankIO(this.fluidHandler.contentsType, i).allowsOutput() || (drained = this.fluidHandler.drainTank(i, resource, action, false)).isEmpty()) continue;
                    return drained;
                }
            }
            return FluidStack.EMPTY;
        }

        public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
            if (this.blockAccessLevel.allowsOutput()) {
                for (int i = 0; i < this.getTanks(); ++i) {
                    FluidStack drained;
                    if (!this.fluidHandler.blockEntity.getFluidTankIO(this.fluidHandler.contentsType, i).allowsOutput() || (drained = this.fluidHandler.drainTank(i, maxDrain, action, false)).isEmpty()) continue;
                    return drained;
                }
            }
            return FluidStack.EMPTY;
        }

        @Override
        public final String toString() {
            return ObjectMethods.bootstrap("toString", new MethodHandle[]{IOWrapper.class, "fluidHandler;blockAccessLevel", "fluidHandler", "blockAccessLevel"}, this);
        }

        @Override
        public final int hashCode() {
            return (int)ObjectMethods.bootstrap("hashCode", new MethodHandle[]{IOWrapper.class, "fluidHandler;blockAccessLevel", "fluidHandler", "blockAccessLevel"}, this);
        }

        @Override
        public final boolean equals(Object o) {
            return (boolean)ObjectMethods.bootstrap("equals", new MethodHandle[]{IOWrapper.class, "fluidHandler;blockAccessLevel", "fluidHandler", "blockAccessLevel"}, this, o);
        }

        @Override
        public LimaBlockEntityFluidHandler fluidHandler() {
            return this.fluidHandler;
        }

        public IOAccess blockAccessLevel() {
            return this.blockAccessLevel;
        }
    }
}

