/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.capability.fluid;

import liedge.limacore.capability.fluid.LimaFluidTank;
import net.minecraft.core.NonNullList;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public abstract class LimaFluidHandler
implements IFluidHandler {
    public LimaFluidTank getFluidTank(int tank) throws IndexOutOfBoundsException {
        this.validateTankIndex(tank);
        return (LimaFluidTank)this.getFluidTanks().get(tank);
    }

    protected abstract NonNullList<? extends LimaFluidTank> getFluidTanks();

    private void validateTankIndex(int tank) {
        if (tank < 0 || tank >= this.getTanks()) {
            throw new IndexOutOfBoundsException(String.format("Tank index %s out of valid range [0,%s)", tank, this.getTanks()));
        }
    }

    protected void onTankChanged(int tank) {
    }

    public int getTanks() {
        return this.getFluidTanks().size();
    }

    public FluidStack getFluidInTank(int tank) {
        return this.getFluidTank(tank).getFluid();
    }

    public int getTankCapacity(int tank) {
        return this.getFluidTank(tank).getCapacity();
    }

    public boolean isFluidValid(int tank, FluidStack stack) {
        return this.getFluidTank(tank).isFluidValid(stack);
    }

    public int fillTank(int tank, FluidStack resource, IFluidHandler.FluidAction action, boolean ignoreLimit) {
        int filled = this.getFluidTank(tank).fill(resource, action, ignoreLimit);
        if (filled == 0) {
            return 0;
        }
        if (!action.simulate()) {
            this.onTankChanged(tank);
        }
        return filled;
    }

    public FluidStack drainTank(int tank, FluidStack resource, IFluidHandler.FluidAction action, boolean ignoreLimit) {
        FluidStack drained = this.getFluidTank(tank).drain(resource, action, ignoreLimit);
        if (drained.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (!action.simulate()) {
            this.onTankChanged(tank);
        }
        return drained;
    }

    public FluidStack drainTank(int tank, int maxDrain, IFluidHandler.FluidAction action, boolean ignoreLimit) {
        FluidStack drained = this.getFluidTank(tank).drain(maxDrain, action, ignoreLimit);
        if (drained.isEmpty()) {
            return FluidStack.EMPTY;
        }
        if (!action.simulate()) {
            this.onTankChanged(tank);
        }
        return drained;
    }

    public int fillAny(FluidStack resource, IFluidHandler.FluidAction action, boolean ignoreLimit) {
        FluidStack remaining = resource.copy();
        int filled = 0;
        for (int i = 0; i < this.getTanks(); ++i) {
            int accepted = this.fillTank(i, remaining, action, ignoreLimit);
            if (accepted <= 0) continue;
            remaining.shrink(accepted);
            filled += accepted;
            if (remaining.isEmpty()) break;
        }
        return filled;
    }

    public FluidStack drainFromAny(FluidStack resource, IFluidHandler.FluidAction action, boolean ignoreLimit) {
        if (resource.isEmpty()) {
            return FluidStack.EMPTY;
        }
        FluidStack result = FluidStack.EMPTY;
        FluidStack remaining = resource.copy();
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidStack accepted = this.drainTank(i, remaining, action, ignoreLimit);
            if (accepted.isEmpty()) continue;
            remaining.shrink(accepted.getAmount());
            if (result.isEmpty()) {
                result = accepted.copy();
            } else {
                result.grow(accepted.getAmount());
            }
            if (remaining.isEmpty()) break;
        }
        return result;
    }

    public int fillFirst(FluidStack resource, IFluidHandler.FluidAction action, boolean ignoreLimit) {
        for (int i = 0; i < this.getTanks(); ++i) {
            int filled = this.fillTank(i, resource, action, ignoreLimit);
            if (filled <= 0) continue;
            return filled;
        }
        return 0;
    }

    public FluidStack drainFromFirst(FluidStack resource, IFluidHandler.FluidAction action, boolean ignoreLimit) {
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidStack drained = this.drainTank(i, resource, action, ignoreLimit);
            if (drained.isEmpty()) continue;
            return drained;
        }
        return FluidStack.EMPTY;
    }

    public FluidStack drainFromFirst(int maxDrain, IFluidHandler.FluidAction action, boolean ignoreLimit) {
        for (int i = 0; i < this.getTanks(); ++i) {
            FluidStack drained = this.drainTank(i, maxDrain, action, ignoreLimit);
            if (drained.isEmpty()) continue;
            return drained;
        }
        return FluidStack.EMPTY;
    }

    @Deprecated
    public int fill(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.fillFirst(resource, action, false);
    }

    @Deprecated
    public FluidStack drain(FluidStack resource, IFluidHandler.FluidAction action) {
        return this.drainFromFirst(resource, action, false);
    }

    @Deprecated
    public FluidStack drain(int maxDrain, IFluidHandler.FluidAction action) {
        return this.drainFromFirst(maxDrain, action, false);
    }
}

