/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.capability.itemhandler;

import liedge.limacore.blockentity.BlockContentsType;
import liedge.limacore.blockentity.IOAccess;
import liedge.limacore.blockentity.LimaBlockEntityAccess;
import liedge.limacore.capability.itemhandler.ItemHandlerIOWrapper;
import liedge.limacore.capability.itemhandler.LimaBlockEntityItemHandler;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.neoforged.neoforge.items.wrapper.CombinedInvWrapper;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nullable;

public interface ItemHolderBlockEntity
extends LimaBlockEntityAccess {
    @Nullable
    public LimaBlockEntityItemHandler getItemHandler(BlockContentsType var1);

    default public LimaBlockEntityItemHandler getItemHandlerOrThrow(BlockContentsType contentsType) {
        LimaBlockEntityItemHandler handler = this.getItemHandler(contentsType);
        if (handler != null) {
            return handler;
        }
        throw new IllegalArgumentException("Block entity does not support item contents type " + contentsType.getSerializedName());
    }

    @ApiStatus.OverrideOnly
    public boolean isItemValid(BlockContentsType var1, int var2, ItemStack var3);

    @ApiStatus.OverrideOnly
    default public void onItemSlotChanged(BlockContentsType contentsType, int slot) {
        this.setChanged();
    }

    public IOAccess getSideIOForItems(@Nullable Direction var1);

    @ApiStatus.OverrideOnly
    default public IOAccess getItemHandlerSlotIO(BlockContentsType contentsType, int slot) {
        return switch (contentsType) {
            default -> throw new MatchException(null, null);
            case BlockContentsType.GENERAL -> IOAccess.INPUT_AND_OUTPUT;
            case BlockContentsType.AUXILIARY -> IOAccess.DISABLED;
            case BlockContentsType.INPUT -> IOAccess.INPUT_ONLY;
            case BlockContentsType.OUTPUT -> IOAccess.OUTPUT_ONLY;
        };
    }

    @ApiStatus.OverrideOnly
    default public void onItemHandlerLoaded(BlockContentsType contentsType) {
    }

    @Nullable
    public IItemHandler createItemIOWrapper(@Nullable Direction var1);

    @ApiStatus.NonExtendable
    @Nullable
    default public IItemHandler wrapInputOutputInventories(@Nullable Direction side) {
        IOAccess blockAccessLevel = this.getSideIOForItems(side);
        return switch (blockAccessLevel) {
            default -> throw new MatchException(null, null);
            case IOAccess.DISABLED -> null;
            case IOAccess.INPUT_ONLY -> this.itemWrapper(BlockContentsType.INPUT, blockAccessLevel);
            case IOAccess.OUTPUT_ONLY -> this.itemWrapper(BlockContentsType.OUTPUT, blockAccessLevel);
            case IOAccess.INPUT_AND_OUTPUT -> new CombinedInvWrapper(new IItemHandlerModifiable[]{this.itemWrapper(BlockContentsType.INPUT, blockAccessLevel), this.itemWrapper(BlockContentsType.OUTPUT, blockAccessLevel)});
        };
    }

    private ItemHandlerIOWrapper itemWrapper(BlockContentsType contentsType, IOAccess blockAccessLevel) {
        return this.getItemHandlerOrThrow(contentsType).createIOWrapper(blockAccessLevel);
    }
}

