/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.client;

import liedge.limacore.blockentity.LimaBlockEntity;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;

public abstract class LimaBlockEntityRenderer<BE extends LimaBlockEntity>
implements BlockEntityRenderer<BE> {
    protected final ItemRenderer itemRenderer;
    protected final EntityRenderDispatcher entityRenderer;

    protected LimaBlockEntityRenderer(BlockEntityRendererProvider.Context context) {
        this.itemRenderer = context.getItemRenderer();
        this.entityRenderer = context.getEntityRenderer();
    }

    protected double[] lerpEntityCenter(BlockPos pos, Entity entity, float partialTick) {
        double x = Mth.lerp((double)partialTick, (double)(entity.xo - (double)pos.getX()), (double)(entity.getX() - (double)pos.getX()));
        double y = Mth.lerp((double)partialTick, (double)(entity.yo - (double)pos.getY()), (double)(entity.getY() - (double)pos.getY())) + entity.getBoundingBox().getYsize() / 2.0;
        double z = Mth.lerp((double)partialTick, (double)(entity.zo - (double)pos.getZ()), (double)(entity.getZ() - (double)pos.getZ()));
        return new double[]{x, y, z};
    }
}

