/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.client;

import java.util.Collection;
import java.util.Map;
import liedge.limacore.LimaCore;
import liedge.limacore.lib.Translatable;
import liedge.limacore.util.LimaCollectionsUtil;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentUtils;
import net.minecraft.network.chat.MutableComponent;

public final class LimaComponentUtil {
    public static final Component COMMA_SEPARATOR = ComponentUtils.DEFAULT_NO_STYLE_SEPARATOR;
    public static final Component INFINITY_SYMBOL = Component.literal((String)"\u221e");
    public static final Component BULLET_1_INDENT = Component.literal((String)" \u2022 ");
    public static final Component BULLET_2_INDENT = Component.literal((String)"  \u2022 ");
    public static final Component MINUS_1_INDENT = Component.literal((String)" - ");
    public static final Component MINUS_2_INDENT = Component.literal((String)"  - ");
    public static final Component COLON_SPACE_SEPARATOR = Component.literal((String)": ");
    private static final Map<Direction, Translatable> DIRECTION_KEYS = LimaCollectionsUtil.fillAndCreateImmutableEnumMap(Direction.class, side -> LimaCore.RESOURCES.translationHolder("direction", "{}", side.getSerializedName()));

    private LimaComponentUtil() {
    }

    public static Translatable localizeDirection(Direction side) {
        return DIRECTION_KEYS.get(side);
    }

    public static MutableComponent colonSpaced(MutableComponent first, MutableComponent second) {
        return first.append(COLON_SPACE_SEPARATOR).append((Component)second);
    }

    public static MutableComponent bulletPointListWithHeader(Component header, Component bullet, Collection<? extends Component> elements) {
        return header.copy().append(CommonComponents.NEW_LINE).append((Component)LimaComponentUtil.bulletPointList(bullet, elements));
    }

    public static MutableComponent bulletPointList(Component bullet, Collection<? extends Component> elements) {
        return ComponentUtils.formatList(elements, (Component)CommonComponents.NEW_LINE, component -> bullet.copy().append(component));
    }
}

