/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.client;

import java.util.stream.Collectors;
import liedge.limacore.util.LimaBlockUtil;
import liedge.limacore.util.LimaCoreUtil;
import liedge.limacore.util.LimaRegistryUtil;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.chunk.LevelChunk;
import org.jetbrains.annotations.Nullable;

public final class LimaCoreClientUtil {
    private LimaCoreClientUtil() {
    }

    public static ModelResourceLocation blockStateModelPath(BlockState state) {
        String variant = state.getValues().entrySet().stream().map(e -> ((Property)e.getKey()).getName() + "=" + ((Comparable)e.getValue()).toString()).collect(Collectors.joining(","));
        ResourceLocation id = LimaRegistryUtil.getBlockId(state.getBlock());
        return new ModelResourceLocation(id, variant);
    }

    public static ModelResourceLocation inventoryModelPath(ItemLike itemLike) {
        ResourceLocation id = LimaRegistryUtil.getItemId(itemLike.asItem());
        return ModelResourceLocation.inventory((ResourceLocation)id);
    }

    public static <T extends BakedModel> T getCustomBakedModel(ModelResourceLocation modelPath, Class<T> modelClass) {
        BakedModel model = Minecraft.getInstance().getModelManager().getModel(modelPath);
        if (model.equals((Object)Minecraft.getInstance().getModelManager().getMissingModel())) {
            throw new NullPointerException("Baked model '" + String.valueOf(modelPath) + "' not found");
        }
        if (modelClass.isInstance(model)) {
            return (T)((BakedModel)modelClass.cast(model));
        }
        throw new ClassCastException("Expected baked model class '" + modelClass.getSimpleName() + ", got '" + model.getClass().getSimpleName() + "' instead");
    }

    @Nullable
    public static AbstractContainerMenu getClientPlayerMenu(int containerId) {
        LocalPlayer player = Minecraft.getInstance().player;
        if (player != null && player.containerMenu.containerId == containerId) {
            return player.containerMenu;
        }
        return null;
    }

    @Nullable
    public static <T> T getClientPlayerMenu(int containerId, Class<T> menuClass) {
        return LimaCoreUtil.castOrNull(menuClass, LimaCoreClientUtil.getClientPlayerMenu(containerId));
    }

    @Nullable
    public static BlockEntity getClientSafeBlockEntity(BlockPos blockPos) {
        return LimaBlockUtil.getSafeBlockEntity((LevelReader)Minecraft.getInstance().level, blockPos);
    }

    @Nullable
    public static <BE> BE getClientSafeBlockEntity(BlockPos blockPos, Class<BE> beClass) {
        return LimaBlockUtil.getSafeBlockEntity((LevelReader)Minecraft.getInstance().level, blockPos, beClass);
    }

    @Nullable
    public static LevelChunk getClientSafeLevelChunk(int chunkX, int chunkZ) {
        return LimaBlockUtil.getSafeLevelChunk((LevelReader)Minecraft.getInstance().level, chunkX, chunkZ);
    }

    @Nullable
    public static LevelChunk getClientSafeLevelChunk(ChunkPos chunkPos) {
        return LimaBlockUtil.getSafeLevelChunk((LevelReader)Minecraft.getInstance().level, chunkPos);
    }

    @Nullable
    public static Entity getClientEntity(int remoteEntityId) {
        ClientLevel level = Minecraft.getInstance().level;
        if (level != null) {
            return level.getEntity(remoteEntityId);
        }
        return null;
    }

    @Nullable
    public static <T extends Entity> T getClientEntity(int remoteEntityId, Class<T> entityClass) {
        return (T)((Entity)LimaCoreUtil.castOrNull(entityClass, LimaCoreClientUtil.getClientEntity(remoteEntityId)));
    }

    @Nullable
    public static Player getClientPlayer() {
        return Minecraft.getInstance().player;
    }

    public static ItemStack getClientHeldItem(InteractionHand hand) {
        if (Minecraft.getInstance().player != null) {
            return Minecraft.getInstance().player.getItemInHand(hand);
        }
        return ItemStack.EMPTY;
    }

    public static ItemStack getClientMainHandItem() {
        return LimaCoreClientUtil.getClientHeldItem(InteractionHand.MAIN_HAND);
    }

    public static boolean isHoldingShiftGUI(@Nullable Level level) {
        if (level != null && level.isClientSide()) {
            return Screen.hasShiftDown();
        }
        return false;
    }
}

