/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.client;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.geom.EntityModelSet;
import net.minecraft.client.renderer.BlockEntityWithoutLevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;

public abstract class LimaSpecialItemRenderer<T extends Item>
extends BlockEntityWithoutLevelRenderer {
    public static final float FONT_SCALE = 0.015625f;

    protected LimaSpecialItemRenderer() {
        super(Minecraft.getInstance().getBlockEntityRenderDispatcher(), Minecraft.getInstance().getEntityModels());
    }

    public final void onResourceManagerReload(ResourceManager manager) {
        T renderableItem = this.getRenderableItem();
        this.onResourceManagerReload(manager, renderableItem);
    }

    public final void renderByItem(ItemStack itemStack, ItemDisplayContext displayContext, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay) {
        Item item = itemStack.getItem();
        float partialTick = Minecraft.getInstance().getTimer().getGameTimeDeltaPartialTick(true);
        this.renderCustomItem(itemStack, item, displayContext, poseStack, bufferSource, partialTick, light, overlay);
    }

    protected abstract T getRenderableItem();

    protected abstract void onResourceManagerReload(ResourceManager var1, T var2);

    protected abstract void renderCustomItem(ItemStack var1, T var2, ItemDisplayContext var3, PoseStack var4, MultiBufferSource var5, float var6, int var7, int var8);

    protected EntityModelSet getEntityModels() {
        return Minecraft.getInstance().getEntityModels();
    }

    protected boolean isRightHanded(ItemDisplayContext displayContext) {
        return displayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND || displayContext == ItemDisplayContext.THIRD_PERSON_RIGHT_HAND;
    }

    protected boolean isLeftHanded(ItemDisplayContext displayContext) {
        return displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND || displayContext == ItemDisplayContext.THIRD_PERSON_LEFT_HAND;
    }

    protected boolean isFirstPersonMainHand(ItemDisplayContext displayContext) {
        if (displayContext.firstPerson()) {
            if (((HumanoidArm)Minecraft.getInstance().options.mainHand().get()).getId() == 0) {
                return displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
            }
            return displayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
        }
        return false;
    }

    protected boolean isFirstPersonOffHand(ItemDisplayContext displayContext) {
        if (displayContext.firstPerson()) {
            if (((HumanoidArm)Minecraft.getInstance().options.mainHand().get()).getOpposite().getId() == 0) {
                return displayContext == ItemDisplayContext.FIRST_PERSON_LEFT_HAND;
            }
            return displayContext == ItemDisplayContext.FIRST_PERSON_RIGHT_HAND;
        }
        return false;
    }
}

