/*
 * Decompiled with CFR 0.152.
 */
package liedge.limacore.client.gui;

import liedge.limacore.client.gui.LimaGuiUtil;
import liedge.limacore.client.gui.LimaRenderable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;

public abstract class FillBarWidget
implements LimaRenderable {
    private final int x;
    private final int y;
    private final int backgroundWidth;
    private final int backgroundHeight;
    private final int foregroundWidth;
    private final int foregroundHeight;

    protected FillBarWidget(int x, int y, int backgroundWidth, int backgroundHeight, int foregroundWidth, int foregroundHeight) {
        this.x = x;
        this.y = y;
        this.backgroundWidth = backgroundWidth;
        this.backgroundHeight = backgroundHeight;
        this.foregroundWidth = foregroundWidth;
        this.foregroundHeight = foregroundHeight;
    }

    protected abstract float getFillPercentage();

    protected abstract ResourceLocation getBackgroundSprite();

    protected abstract ResourceLocation getForegroundSprite(float var1);

    protected void renderBackground(GuiGraphics graphics) {
        graphics.blitSprite(this.getBackgroundSprite(), this.getX(), this.getY(), this.backgroundWidth, this.backgroundHeight);
    }

    protected void renderHorizontalBar(GuiGraphics graphics, float fillPercentage) {
        if (fillPercentage > 0.0f) {
            TextureAtlasSprite sprite = Minecraft.getInstance().getGuiSprites().getSprite(this.getForegroundSprite(fillPercentage));
            LimaGuiUtil.partialHorizontalBlit(graphics, this.getX() + 1, this.getY() + 1, this.foregroundWidth, this.foregroundHeight, Mth.clamp((float)fillPercentage, (float)0.0f, (float)1.0f), sprite);
        }
    }

    protected void renderVerticalBar(GuiGraphics graphics, float fillPercentage) {
        if (fillPercentage > 0.0f) {
            TextureAtlasSprite sprite = Minecraft.getInstance().getGuiSprites().getSprite(this.getForegroundSprite(fillPercentage));
            LimaGuiUtil.partialVerticalBlit(graphics, this.getX() + 1, this.getY() + 1, this.foregroundWidth, this.foregroundHeight, Mth.clamp((float)fillPercentage, (float)0.0f, (float)1.0f), sprite);
        }
    }

    @Override
    public int getX() {
        return this.x;
    }

    @Override
    public int getY() {
        return this.y;
    }

    @Override
    public int getWidth() {
        return this.backgroundWidth;
    }

    @Override
    public int getHeight() {
        return this.backgroundHeight;
    }

    public static abstract class VerticalBar
    extends FillBarWidget {
        protected VerticalBar(int x, int y, int backgroundWidth, int backgroundHeight, int foregroundWidth, int foregroundHeight) {
            super(x, y, backgroundWidth, backgroundHeight, foregroundWidth, foregroundHeight);
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            this.renderBackground(graphics);
            this.renderVerticalBar(graphics, this.getFillPercentage());
        }
    }

    public static abstract class HorizontalBar
    extends FillBarWidget {
        protected HorizontalBar(int x, int y, int backgroundWidth, int backgroundHeight, int foregroundWidth, int foregroundHeight) {
            super(x, y, backgroundWidth, backgroundHeight, foregroundWidth, foregroundHeight);
        }

        @Override
        public void render(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
            this.renderBackground(graphics);
            this.renderHorizontalBar(graphics, this.getFillPercentage());
        }
    }
}

